/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpSession;
import com.mockrunner.mock.web.MockRequestDispatcher;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import junit.framework.TestCase;

public class MockHttpServletRequestTest
extends TestCase {
    private MockHttpServletRequest request;

    protected void setUp() {
        this.request = new MockHttpServletRequest();
    }

    protected void tearDown() {
        this.request = null;
    }

    public void testResetAll() throws Exception {
        this.request.setAttribute("key", "value");
        this.request.addHeader("header", "headervalue");
        this.request.setContentLength(5);
        this.request.resetAll();
        MockHttpServletRequestTest.assertNull((Object)this.request.getAttribute("key"));
        MockHttpServletRequestTest.assertNull((Object)this.request.getHeader("header"));
        MockHttpServletRequestTest.assertEquals((int)-1, (int)this.request.getContentLength());
    }

    public void testAttributeListenerCalled() {
        TestAttributeListener listener1 = new TestAttributeListener();
        TestAttributeListener listener2 = new TestAttributeListener();
        TestAttributeListener listener3 = new TestAttributeListener();
        this.request.addAttributeListener(listener1);
        this.request.addAttributeListener(listener2);
        this.request.addAttributeListener(listener3);
        this.request.setAttribute("key", "value");
        MockHttpServletRequestTest.assertTrue((boolean)listener1.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener2.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener3.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener1.wasAttributeReplacedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener2.wasAttributeReplacedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener3.wasAttributeReplacedCalled());
        listener1.reset();
        listener2.reset();
        listener3.reset();
        this.request.setAttribute("key", "value1");
        MockHttpServletRequestTest.assertFalse((boolean)listener1.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener2.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener3.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener1.wasAttributeReplacedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener2.wasAttributeReplacedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener3.wasAttributeReplacedCalled());
        this.request.removeAttribute("key");
        MockHttpServletRequestTest.assertTrue((boolean)listener1.wasAttributeRemovedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener2.wasAttributeRemovedCalled());
        MockHttpServletRequestTest.assertTrue((boolean)listener3.wasAttributeRemovedCalled());
    }

    public void testAttributeListenerValues() {
        TestAttributeOrderListener listener = new TestAttributeOrderListener();
        this.request.addAttributeListener(listener);
        this.request.setAttribute("key", "value");
        MockHttpServletRequestTest.assertEquals((String)"key", (String)listener.getAddedEventKey());
        MockHttpServletRequestTest.assertEquals((Object)"value", (Object)listener.getAddedEventValue());
        this.request.setAttribute("key", "anotherValue");
        MockHttpServletRequestTest.assertEquals((String)"key", (String)listener.getReplacedEventKey());
        MockHttpServletRequestTest.assertEquals((Object)"value", (Object)listener.getReplacedEventValue());
        this.request.removeAttribute("key");
        MockHttpServletRequestTest.assertEquals((String)"key", (String)listener.getRemovedEventKey());
        MockHttpServletRequestTest.assertEquals((Object)"anotherValue", (Object)listener.getRemovedEventValue());
    }

    public void testAttributeListenerNullValue() {
        TestAttributeListener listener = new TestAttributeListener();
        this.request.addAttributeListener(listener);
        this.request.setAttribute("key", null);
        MockHttpServletRequestTest.assertFalse((boolean)listener.wasAttributeAddedCalled());
        this.request.setAttribute("key", "xyz");
        MockHttpServletRequestTest.assertTrue((boolean)listener.wasAttributeAddedCalled());
        this.request.setAttribute("key", null);
        MockHttpServletRequestTest.assertTrue((boolean)listener.wasAttributeRemovedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener.wasAttributeReplacedCalled());
        listener.reset();
        this.request.setAttribute("key", "xyz");
        MockHttpServletRequestTest.assertTrue((boolean)listener.wasAttributeAddedCalled());
        MockHttpServletRequestTest.assertFalse((boolean)listener.wasAttributeReplacedCalled());
        this.request.removeAttribute("myKey");
        MockHttpServletRequestTest.assertFalse((boolean)listener.wasAttributeRemovedCalled());
    }

    public void testGetAttributeNames() {
        Enumeration enumeration = this.request.getAttributeNames();
        MockHttpServletRequestTest.assertFalse((boolean)enumeration.hasMoreElements());
        this.request.setAttribute("key", null);
        enumeration = this.request.getAttributeNames();
        MockHttpServletRequestTest.assertFalse((boolean)enumeration.hasMoreElements());
        this.request.setAttribute("key1", "value1");
        this.request.setAttribute("key2", "value2");
        MockHttpServletRequestTest.assertEquals((Object)"value1", (Object)this.request.getAttribute("key1"));
        MockHttpServletRequestTest.assertEquals((Object)"value2", (Object)this.request.getAttribute("key2"));
        enumeration = this.request.getAttributeNames();
        ArrayList testList = new ArrayList();
        testList.add(enumeration.nextElement());
        testList.add(enumeration.nextElement());
        MockHttpServletRequestTest.assertFalse((boolean)enumeration.hasMoreElements());
        MockHttpServletRequestTest.assertTrue((boolean)testList.contains("key1"));
        MockHttpServletRequestTest.assertTrue((boolean)testList.contains("key2"));
        this.request.setAttribute("key2", null);
        MockHttpServletRequestTest.assertNull((Object)this.request.getAttribute("key2"));
        enumeration = this.request.getAttributeNames();
        testList = new ArrayList();
        testList.add(enumeration.nextElement());
        MockHttpServletRequestTest.assertFalse((boolean)enumeration.hasMoreElements());
        MockHttpServletRequestTest.assertTrue((boolean)testList.contains("key1"));
        this.request.setAttribute("key1", null);
        MockHttpServletRequestTest.assertNull((Object)this.request.getAttribute("key1"));
        enumeration = this.request.getAttributeNames();
        MockHttpServletRequestTest.assertFalse((boolean)enumeration.hasMoreElements());
    }

    public void testAddRequestParameter() throws Exception {
        this.request.setupAddParameter("abc", "abc");
        MockHttpServletRequestTest.assertEquals((String)"abc", (String)this.request.getParameter("abc"));
        this.request.setupAddParameter("abc", "123");
        MockHttpServletRequestTest.assertEquals((String)"123", (String)this.request.getParameter("abc"));
        MockHttpServletRequestTest.assertEquals((int)1, (int)this.request.getParameterValues("abc").length);
        this.request.setupAddParameter("abc", new String[]{"123", "456"});
        MockHttpServletRequestTest.assertEquals((String)"123", (String)this.request.getParameter("abc"));
        MockHttpServletRequestTest.assertEquals((int)2, (int)this.request.getParameterValues("abc").length);
        MockHttpServletRequestTest.assertEquals((String)"123", (String)this.request.getParameterValues("abc")[0]);
        MockHttpServletRequestTest.assertEquals((String)"456", (String)this.request.getParameterValues("abc")[1]);
    }

    public void testHeaders() {
        this.request.addHeader("testHeader", "xyz");
        this.request.addHeader("testHeader", "abc");
        Enumeration headers = this.request.getHeaders("testHeader");
        ArrayList list = new ArrayList();
        list.add(headers.nextElement());
        list.add(headers.nextElement());
        MockHttpServletRequestTest.assertFalse((boolean)headers.hasMoreElements());
        MockHttpServletRequestTest.assertTrue((boolean)list.contains("xyz"));
        MockHttpServletRequestTest.assertTrue((boolean)list.contains("abc"));
        MockHttpServletRequestTest.assertNull((Object)this.request.getHeader("anotherHeader"));
        this.request.addHeader("dateHeader", "Friday, 06 Feb 2004 22:59:48 GMT");
        headers = this.request.getHeaderNames();
        list = new ArrayList();
        list.add(headers.nextElement());
        list.add(headers.nextElement());
        MockHttpServletRequestTest.assertFalse((boolean)headers.hasMoreElements());
        MockHttpServletRequestTest.assertTrue((boolean)list.contains("testHeader"));
        MockHttpServletRequestTest.assertTrue((boolean)list.contains("dateHeader"));
        long date = this.request.getDateHeader("dateHeader");
        MockHttpServletRequestTest.assertEquals((long)1076108388000L, (long)date);
        MockHttpServletRequestTest.assertEquals((long)-1L, (long)this.request.getDateHeader("anotherDateHeader"));
        this.request.setHeader("dateHeader", "3.3.1980");
        try {
            this.request.getDateHeader("dateHeader");
            MockHttpServletRequestTest.fail();
        }
        catch (IllegalArgumentException exc) {
            // empty catch block
        }
        this.request.setHeader("intHeader", "25");
        int value = this.request.getIntHeader("intHeader");
        MockHttpServletRequestTest.assertEquals((int)25, (int)value);
        MockHttpServletRequestTest.assertEquals((int)-1, (int)this.request.getIntHeader("anotherIntHeader"));
        this.request.setHeader("intHeader", "xyz");
        try {
            this.request.getIntHeader("intHeader");
            MockHttpServletRequestTest.fail();
        }
        catch (NumberFormatException exc) {
            // empty catch block
        }
        this.request.clearHeaders();
        headers = this.request.getHeaderNames();
        MockHttpServletRequestTest.assertFalse((boolean)headers.hasMoreElements());
        MockHttpServletRequestTest.assertFalse((boolean)this.request.getHeaders("doesnotexist").hasMoreElements());
    }

    public void testHeadersCaseInsensitive() {
        this.request.addHeader("testHeader", "xyz");
        this.request.addHeader("TESTHeader", "abc");
        Enumeration headers = this.request.getHeaders("testHeader");
        ArrayList list = new ArrayList();
        list.add(headers.nextElement());
        list.add(headers.nextElement());
        MockHttpServletRequestTest.assertFalse((boolean)headers.hasMoreElements());
        MockHttpServletRequestTest.assertTrue((boolean)list.contains("xyz"));
        MockHttpServletRequestTest.assertTrue((boolean)list.contains("abc"));
        this.request.addHeader("MYHEADER1", "xyz");
        this.request.addHeader("myHeader2", "abc");
        MockHttpServletRequestTest.assertEquals((String)"xyz", (String)this.request.getHeader("myheader1"));
        MockHttpServletRequestTest.assertEquals((String)"abc", (String)this.request.getHeader("MYHEADER2"));
        headers = this.request.getHeaderNames();
        ArrayList headerNames = new ArrayList();
        while (headers.hasMoreElements()) {
            headerNames.add(headers.nextElement());
        }
        MockHttpServletRequestTest.assertEquals((int)3, (int)headerNames.size());
        MockHttpServletRequestTest.assertTrue((boolean)headerNames.contains("testHeader"));
        MockHttpServletRequestTest.assertTrue((boolean)headerNames.contains("MYHEADER1"));
        MockHttpServletRequestTest.assertTrue((boolean)headerNames.contains("myHeader2"));
    }

    public void testCookies() {
        MockHttpServletRequestTest.assertNull((Object)this.request.getCookies());
        this.request.addCookie(new Cookie("name1", "value1"));
        this.request.addCookie(new Cookie("name2", "value2"));
        this.request.addCookie(new Cookie("name3", "value3"));
        Cookie[] cookies = this.request.getCookies();
        MockHttpServletRequestTest.assertTrue((cookies.length == 3 ? 1 : 0) != 0);
        MockHttpServletRequestTest.assertEquals((String)"name1", (String)cookies[0].getName());
        MockHttpServletRequestTest.assertEquals((String)"value1", (String)cookies[0].getValue());
        MockHttpServletRequestTest.assertEquals((String)"name2", (String)cookies[1].getName());
        MockHttpServletRequestTest.assertEquals((String)"value2", (String)cookies[1].getValue());
        MockHttpServletRequestTest.assertEquals((String)"name3", (String)cookies[2].getName());
        MockHttpServletRequestTest.assertEquals((String)"value3", (String)cookies[2].getValue());
    }

    public void testBodyContent() throws Exception {
        this.request.setBodyContent("test\nanothertest???");
        BufferedReader reader = this.request.getReader();
        MockHttpServletRequestTest.assertEquals((String)"test", (String)reader.readLine());
        MockHttpServletRequestTest.assertEquals((String)"anothertest???", (String)reader.readLine());
        MockHttpServletRequestTest.assertEquals((int)-1, (int)reader.read());
        this.request.setBodyContent(new byte[]{0, -128, 3, 127, 55});
        ServletInputStream stream = this.request.getInputStream();
        MockHttpServletRequestTest.assertEquals((int)0, (int)stream.read());
        MockHttpServletRequestTest.assertEquals((int)-128, (int)((byte)stream.read()));
        MockHttpServletRequestTest.assertEquals((int)3, (int)stream.read());
        MockHttpServletRequestTest.assertEquals((int)127, (int)stream.read());
        MockHttpServletRequestTest.assertEquals((int)55, (int)stream.read());
    }

    public void testRequestDispatcher() throws Exception {
        String rdPath1 = "rdPathOne";
        String rdPath2 = "rdPathTwo";
        String rdPath3 = "rdPathThree";
        MockHttpServletRequestTest.assertEquals((int)0, (int)this.request.getRequestDispatcherMap().size());
        MockRequestDispatcher rd1 = (MockRequestDispatcher)this.request.getRequestDispatcher("rdPathOne");
        MockHttpServletRequestTest.assertEquals((String)"rdPathOne", (String)rd1.getPath());
        MockHttpServletRequestTest.assertNull((Object)rd1.getForwardedRequest());
        MockHttpServletRequestTest.assertNull((Object)rd1.getIncludedRequest());
        MockHttpServletRequestTest.assertEquals((int)1, (int)this.request.getRequestDispatcherMap().size());
        MockHttpServletRequestTest.assertTrue((boolean)this.request.getRequestDispatcherMap().containsKey("rdPathOne"));
        MockHttpServletRequestTest.assertSame((Object)rd1, this.request.getRequestDispatcherMap().get("rdPathOne"));
        MockRequestDispatcher actualRd2 = new MockRequestDispatcher();
        this.request.setRequestDispatcher("rdPathTwo", actualRd2);
        MockRequestDispatcher rd2 = (MockRequestDispatcher)this.request.getRequestDispatcher("rdPathTwo");
        MockHttpServletRequestTest.assertEquals((String)"rdPathTwo", (String)rd2.getPath());
        MockHttpServletRequestTest.assertSame((Object)actualRd2, (Object)rd2);
        MockHttpServletRequestTest.assertNull((Object)rd1.getForwardedRequest());
        MockHttpServletRequestTest.assertNull((Object)rd1.getIncludedRequest());
        MockHttpServletRequestTest.assertEquals((int)2, (int)this.request.getRequestDispatcherMap().size());
        MockHttpServletRequestTest.assertTrue((boolean)this.request.getRequestDispatcherMap().containsKey("rdPathTwo"));
        MockHttpServletRequestTest.assertSame((Object)rd2, this.request.getRequestDispatcherMap().get("rdPathTwo"));
        TestRequestDispatcher actualRd3 = new TestRequestDispatcher();
        this.request.setRequestDispatcher("rdPathThree", actualRd3);
        RequestDispatcher rd3 = this.request.getRequestDispatcher("rdPathThree");
        MockHttpServletRequestTest.assertSame((Object)actualRd3, (Object)rd3);
        MockHttpServletRequestTest.assertEquals((int)3, (int)this.request.getRequestDispatcherMap().size());
        MockHttpServletRequestTest.assertTrue((boolean)this.request.getRequestDispatcherMap().containsKey("rdPathThree"));
        MockHttpServletRequestTest.assertSame((Object)rd3, this.request.getRequestDispatcherMap().get("rdPathThree"));
        this.request.clearRequestDispatcherMap();
        MockHttpServletRequestTest.assertEquals((int)0, (int)this.request.getRequestDispatcherMap().size());
    }

    public void testSessionCreation() throws Exception {
        this.request.setSession(null);
        MockHttpServletRequestTest.assertNull((Object)this.request.getSession(false));
        MockHttpServletRequestTest.assertNull((Object)this.request.getSession(true));
        MockHttpServletRequestTest.assertNull((Object)this.request.getSession());
        this.request = new MockHttpServletRequest();
        MockHttpSession session = new MockHttpSession();
        this.request.setSession(session);
        MockHttpServletRequestTest.assertNull((Object)this.request.getSession(false));
        MockHttpServletRequestTest.assertNotNull((Object)this.request.getSession());
        MockHttpServletRequestTest.assertNotNull((Object)this.request.getSession(false));
        MockHttpServletRequestTest.assertSame((Object)session, (Object)this.request.getSession(false));
        MockHttpServletRequestTest.assertNotNull((Object)this.request.getSession(true));
        MockHttpServletRequestTest.assertSame((Object)session, (Object)this.request.getSession(true));
        this.request = new MockHttpServletRequest();
        this.request.setSession(new MockHttpSession());
        MockHttpServletRequestTest.assertNotNull((Object)this.request.getSession(true));
        MockHttpServletRequestTest.assertNotNull((Object)this.request.getSession(false));
    }

    public void testSessionInvalidate() throws Exception {
        this.request.setSession(new MockHttpSession());
        this.request.getSession().invalidate();
        MockHttpServletRequestTest.assertFalse((boolean)((MockHttpSession)this.request.getSession(false)).isValid());
        MockHttpServletRequestTest.assertTrue((boolean)((MockHttpSession)this.request.getSession(true)).isValid());
    }

    public void testIsUserInRole() {
        this.request.setUserInRole("role1", true);
        this.request.setUserInRole("role2", false);
        MockHttpServletRequestTest.assertTrue((boolean)this.request.isUserInRole("role1"));
        MockHttpServletRequestTest.assertFalse((boolean)this.request.isUserInRole("role2"));
        MockHttpServletRequestTest.assertFalse((boolean)this.request.isUserInRole("role3"));
    }

    private class TestRequestDispatcher
    implements RequestDispatcher {
        private TestRequestDispatcher() {
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }
    }

    private class TestAttributeOrderListener
    implements ServletRequestAttributeListener {
        private String addedEventKey;
        private Object addedEventValue;
        private String replacedEventKey;
        private Object replacedEventValue;
        private String removedEventKey;
        private Object removedEventValue;

        private TestAttributeOrderListener() {
        }

        public void attributeAdded(ServletRequestAttributeEvent event) {
            this.addedEventKey = event.getName();
            this.addedEventValue = event.getValue();
        }

        public void attributeRemoved(ServletRequestAttributeEvent event) {
            this.removedEventKey = event.getName();
            this.removedEventValue = event.getValue();
        }

        public void attributeReplaced(ServletRequestAttributeEvent event) {
            this.replacedEventKey = event.getName();
            this.replacedEventValue = event.getValue();
        }

        public String getAddedEventKey() {
            return this.addedEventKey;
        }

        public Object getAddedEventValue() {
            return this.addedEventValue;
        }

        public String getRemovedEventKey() {
            return this.removedEventKey;
        }

        public Object getRemovedEventValue() {
            return this.removedEventValue;
        }

        public String getReplacedEventKey() {
            return this.replacedEventKey;
        }

        public Object getReplacedEventValue() {
            return this.replacedEventValue;
        }
    }

    private class TestAttributeListener
    implements ServletRequestAttributeListener {
        private boolean wasAttributeAddedCalled = false;
        private boolean wasAttributeReplacedCalled = false;
        private boolean wasAttributeRemovedCalled = false;

        private TestAttributeListener() {
        }

        public void attributeAdded(ServletRequestAttributeEvent event) {
            this.wasAttributeAddedCalled = true;
        }

        public void attributeRemoved(ServletRequestAttributeEvent event) {
            this.wasAttributeRemovedCalled = true;
        }

        public void attributeReplaced(ServletRequestAttributeEvent event) {
            this.wasAttributeReplacedCalled = true;
        }

        public void reset() {
            this.wasAttributeAddedCalled = false;
            this.wasAttributeReplacedCalled = false;
            this.wasAttributeRemovedCalled = false;
        }

        public boolean wasAttributeAddedCalled() {
            return this.wasAttributeAddedCalled;
        }

        public boolean wasAttributeRemovedCalled() {
            return this.wasAttributeRemovedCalled;
        }

        public boolean wasAttributeReplacedCalled() {
            return this.wasAttributeReplacedCalled;
        }
    }
}

