/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockHttpSession;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import junit.framework.TestCase;

public class MockHttpSessionTest
extends TestCase {
    private MockHttpSession session;

    protected void setUp() {
        this.session = new MockHttpSession();
    }

    protected void tearDown() {
        this.session = null;
    }

    public void testResetAll() throws Exception {
        this.session.setAttribute("key", "value");
        this.session.setMaxInactiveInterval(3);
        this.session.resetAll();
        MockHttpSessionTest.assertNull((Object)this.session.getAttribute("key"));
        MockHttpSessionTest.assertEquals((int)-1, (int)this.session.getMaxInactiveInterval());
    }

    public void testBindingListenerInvalidate() {
        TestSessionListener listener1 = new TestSessionListener();
        TestSessionListener listener2 = new TestSessionListener();
        this.session.setAttribute("key1", listener1);
        this.session.setAttribute("key2", listener2);
        MockHttpSessionTest.assertTrue((boolean)listener1.wasValueBoundCalled());
        MockHttpSessionTest.assertTrue((boolean)listener2.wasValueBoundCalled());
        MockHttpSessionTest.assertFalse((boolean)listener1.wasValueUnboundCalled());
        MockHttpSessionTest.assertFalse((boolean)listener2.wasValueUnboundCalled());
        this.session.removeAttribute("key2");
        MockHttpSessionTest.assertTrue((boolean)listener2.wasValueUnboundCalled());
        InvalidateAttributeListener listener = new InvalidateAttributeListener();
        this.session.addAttributeListener(listener);
        this.session.invalidate();
        MockHttpSessionTest.assertTrue((boolean)listener1.wasValueUnboundCalled());
        MockHttpSessionTest.assertTrue((boolean)listener.getDidThrowIllegalStateException());
        try {
            this.session.invalidate();
            MockHttpSessionTest.fail();
        }
        catch (IllegalStateException exc) {
            // empty catch block
        }
    }

    public void testBindingListenerOverwriteAttribute() {
        TestSessionListener listener1 = new TestSessionListener();
        TestSessionListener listener2 = new TestSessionListener();
        this.session.setAttribute("key", listener1);
        this.session.setAttribute("key", listener2);
        MockHttpSessionTest.assertTrue((boolean)listener1.wasValueUnboundCalled());
        MockHttpSessionTest.assertTrue((boolean)listener2.wasValueBoundCalled());
        MockHttpSessionTest.assertFalse((boolean)listener2.wasValueUnboundCalled());
    }

    public void testBindingListenerOverwriteSameAttribute() {
        TestSessionListener listener = new TestSessionListener();
        this.session.setAttribute("key", listener);
        listener.reset();
        this.session.setAttribute("key", listener);
        MockHttpSessionTest.assertTrue((boolean)listener.wasValueUnboundCalled());
        MockHttpSessionTest.assertTrue((boolean)listener.wasValueBoundCalled());
        MockHttpSessionTest.assertTrue((boolean)listener.wasValueUnboundBeforeBoundCalled());
    }

    public void testBindingListenerCorrectOrder() {
        this.session.setAttribute("key", "test");
        TestSessionOrderListener listener = new TestSessionOrderListener();
        this.session.setAttribute("key", listener);
        MockHttpSessionTest.assertEquals((String)"key", (String)listener.getBoundEventKey());
        MockHttpSessionTest.assertEquals((Object)listener, (Object)listener.getBoundEventValue());
        MockHttpSessionTest.assertEquals((Object)listener, (Object)listener.getBoundSessionValue());
        this.session.setAttribute("key", "xyz");
        MockHttpSessionTest.assertEquals((String)"key", (String)listener.getUnboundEventKey());
        MockHttpSessionTest.assertEquals((Object)listener, (Object)listener.getUnboundEventValue());
        MockHttpSessionTest.assertEquals((Object)"xyz", (Object)listener.getUnboundSessionValue());
        this.session = new MockHttpSession();
        listener = new TestSessionOrderListener();
        this.session.setAttribute("key", "abc");
        this.session.setAttribute("key", listener);
        this.session.removeAttribute("key");
        MockHttpSessionTest.assertEquals((String)"key", (String)listener.getUnboundEventKey());
        MockHttpSessionTest.assertEquals((Object)listener, (Object)listener.getUnboundEventValue());
        MockHttpSessionTest.assertEquals(null, (Object)listener.getUnboundSessionValue());
    }

    public void testAttributeListenerCalled() {
        TestAttributeListener listener1 = new TestAttributeListener();
        TestAttributeListener listener2 = new TestAttributeListener();
        TestAttributeListener listener3 = new TestAttributeListener();
        this.session.addAttributeListener(listener1);
        this.session.addAttributeListener(listener2);
        this.session.addAttributeListener(listener3);
        this.session.setAttribute("key", "value");
        MockHttpSessionTest.assertTrue((boolean)listener1.wasAttributeAddedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener2.wasAttributeAddedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener3.wasAttributeAddedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener1.wasAttributeReplacedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener2.wasAttributeReplacedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener3.wasAttributeReplacedCalled());
        listener1.reset();
        listener2.reset();
        listener3.reset();
        this.session.setAttribute("key", "value1");
        MockHttpSessionTest.assertFalse((boolean)listener1.wasAttributeAddedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener2.wasAttributeAddedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener3.wasAttributeAddedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener1.wasAttributeReplacedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener2.wasAttributeReplacedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener3.wasAttributeReplacedCalled());
        this.session.removeAttribute("key");
        MockHttpSessionTest.assertTrue((boolean)listener1.wasAttributeRemovedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener2.wasAttributeRemovedCalled());
        MockHttpSessionTest.assertTrue((boolean)listener3.wasAttributeRemovedCalled());
    }

    public void testAttributeListenerOrder() {
        TestAttributeOrderListener listener = new TestAttributeOrderListener();
        this.session.addAttributeListener(listener);
        this.session.setAttribute("key", "value");
        MockHttpSessionTest.assertEquals((String)"key", (String)listener.getAddedEventKey());
        MockHttpSessionTest.assertEquals((Object)"value", (Object)listener.getAddedEventValue());
        MockHttpSessionTest.assertEquals((Object)"value", (Object)listener.getAddedSessionValue());
        this.session.setAttribute("key", "anotherValue");
        MockHttpSessionTest.assertEquals((String)"key", (String)listener.getReplacedEventKey());
        MockHttpSessionTest.assertEquals((Object)"value", (Object)listener.getReplacedEventValue());
        MockHttpSessionTest.assertEquals((Object)"anotherValue", (Object)listener.getReplacedSessionValue());
        this.session.removeAttribute("key");
        MockHttpSessionTest.assertEquals((String)"key", (String)listener.getRemovedEventKey());
        MockHttpSessionTest.assertEquals((Object)"anotherValue", (Object)listener.getRemovedEventValue());
        MockHttpSessionTest.assertNull((String)"", (Object)listener.getRemovedSessionValue());
    }

    public void testAttributeListenerNullValue() {
        TestAttributeListener listener = new TestAttributeListener();
        this.session.addAttributeListener(listener);
        this.session.setAttribute("key", null);
        MockHttpSessionTest.assertFalse((boolean)listener.wasAttributeAddedCalled());
        this.session.setAttribute("key", "xyz");
        MockHttpSessionTest.assertTrue((boolean)listener.wasAttributeAddedCalled());
        this.session.setAttribute("key", null);
        MockHttpSessionTest.assertTrue((boolean)listener.wasAttributeRemovedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener.wasAttributeReplacedCalled());
        listener.reset();
        this.session.setAttribute("key", "xyz");
        MockHttpSessionTest.assertTrue((boolean)listener.wasAttributeAddedCalled());
        MockHttpSessionTest.assertFalse((boolean)listener.wasAttributeReplacedCalled());
        this.session.removeAttribute("myKey");
        MockHttpSessionTest.assertFalse((boolean)listener.wasAttributeRemovedCalled());
    }

    public void testGetAttributeNames() {
        Enumeration enumeration = this.session.getAttributeNames();
        MockHttpSessionTest.assertFalse((boolean)enumeration.hasMoreElements());
        this.session.setAttribute("key", null);
        enumeration = this.session.getAttributeNames();
        MockHttpSessionTest.assertFalse((boolean)enumeration.hasMoreElements());
        this.session.setAttribute("key1", "value1");
        this.session.setAttribute("key2", "value2");
        MockHttpSessionTest.assertEquals((Object)"value1", (Object)this.session.getAttribute("key1"));
        MockHttpSessionTest.assertEquals((Object)"value2", (Object)this.session.getAttribute("key2"));
        enumeration = this.session.getAttributeNames();
        ArrayList testList = new ArrayList();
        testList.add(enumeration.nextElement());
        testList.add(enumeration.nextElement());
        MockHttpSessionTest.assertFalse((boolean)enumeration.hasMoreElements());
        MockHttpSessionTest.assertTrue((boolean)testList.contains("key1"));
        MockHttpSessionTest.assertTrue((boolean)testList.contains("key2"));
        this.session.setAttribute("key2", null);
        MockHttpSessionTest.assertNull((Object)this.session.getAttribute("key2"));
        enumeration = this.session.getAttributeNames();
        testList = new ArrayList();
        testList.add(enumeration.nextElement());
        MockHttpSessionTest.assertFalse((boolean)enumeration.hasMoreElements());
        MockHttpSessionTest.assertTrue((boolean)testList.contains("key1"));
        this.session.setAttribute("key1", null);
        MockHttpSessionTest.assertNull((Object)this.session.getAttribute("key1"));
        enumeration = this.session.getAttributeNames();
        MockHttpSessionTest.assertFalse((boolean)enumeration.hasMoreElements());
    }

    private static class TestAttributeOrderListener
    implements HttpSessionAttributeListener {
        private String addedEventKey;
        private Object addedEventValue;
        private Object addedSessionValue;
        private String replacedEventKey;
        private Object replacedEventValue;
        private Object replacedSessionValue;
        private String removedEventKey;
        private Object removedEventValue;
        private Object removedSessionValue;

        private TestAttributeOrderListener() {
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
            this.addedEventKey = event.getName();
            this.addedEventValue = event.getValue();
            this.addedSessionValue = event.getSession().getAttribute(this.addedEventKey);
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            this.removedEventKey = event.getName();
            this.removedEventValue = event.getValue();
            this.removedSessionValue = event.getSession().getAttribute(this.removedEventKey);
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
            this.replacedEventKey = event.getName();
            this.replacedEventValue = event.getValue();
            this.replacedSessionValue = event.getSession().getAttribute(this.replacedEventKey);
        }

        public String getAddedEventKey() {
            return this.addedEventKey;
        }

        public Object getAddedEventValue() {
            return this.addedEventValue;
        }

        public Object getAddedSessionValue() {
            return this.addedSessionValue;
        }

        public String getRemovedEventKey() {
            return this.removedEventKey;
        }

        public Object getRemovedEventValue() {
            return this.removedEventValue;
        }

        public Object getRemovedSessionValue() {
            return this.removedSessionValue;
        }

        public String getReplacedEventKey() {
            return this.replacedEventKey;
        }

        public Object getReplacedEventValue() {
            return this.replacedEventValue;
        }

        public Object getReplacedSessionValue() {
            return this.replacedSessionValue;
        }
    }

    private static class TestAttributeListener
    implements HttpSessionAttributeListener {
        private boolean wasAttributeAddedCalled = false;
        private boolean wasAttributeReplacedCalled = false;
        private boolean wasAttributeRemovedCalled = false;

        private TestAttributeListener() {
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
            this.wasAttributeAddedCalled = true;
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            this.wasAttributeRemovedCalled = true;
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
            this.wasAttributeReplacedCalled = true;
        }

        public void reset() {
            this.wasAttributeAddedCalled = false;
            this.wasAttributeReplacedCalled = false;
            this.wasAttributeRemovedCalled = false;
        }

        public boolean wasAttributeAddedCalled() {
            return this.wasAttributeAddedCalled;
        }

        public boolean wasAttributeRemovedCalled() {
            return this.wasAttributeRemovedCalled;
        }

        public boolean wasAttributeReplacedCalled() {
            return this.wasAttributeReplacedCalled;
        }
    }

    private static class InvalidateAttributeListener
    implements HttpSessionAttributeListener {
        private boolean didThrowIllegalStateException = false;

        private InvalidateAttributeListener() {
        }

        public void attributeAdded(HttpSessionBindingEvent event) {
        }

        public void attributeRemoved(HttpSessionBindingEvent event) {
            HttpSession session = event.getSession();
            this.didThrowIllegalStateException = false;
            try {
                session.getAttribute(event.getName());
            }
            catch (IllegalStateException exc) {
                this.didThrowIllegalStateException = true;
            }
        }

        public void attributeReplaced(HttpSessionBindingEvent event) {
        }

        public boolean getDidThrowIllegalStateException() {
            return this.didThrowIllegalStateException;
        }
    }

    private static class TestSessionOrderListener
    implements HttpSessionBindingListener {
        private String boundEventKey;
        private Object boundEventValue;
        private Object boundSessionValue;
        private String unboundEventKey;
        private Object unboundEventValue;
        private Object unboundSessionValue;

        private TestSessionOrderListener() {
        }

        public void valueBound(HttpSessionBindingEvent event) {
            this.boundEventKey = event.getName();
            this.boundEventValue = event.getValue();
            this.boundSessionValue = event.getSession().getAttribute(this.boundEventKey);
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.unboundEventKey = event.getName();
            this.unboundEventValue = event.getValue();
            this.unboundSessionValue = event.getSession().getAttribute(this.unboundEventKey);
        }

        public String getBoundEventKey() {
            return this.boundEventKey;
        }

        public Object getBoundEventValue() {
            return this.boundEventValue;
        }

        public Object getBoundSessionValue() {
            return this.boundSessionValue;
        }

        public String getUnboundEventKey() {
            return this.unboundEventKey;
        }

        public Object getUnboundEventValue() {
            return this.unboundEventValue;
        }

        public Object getUnboundSessionValue() {
            return this.unboundSessionValue;
        }
    }

    private static class TestSessionListener
    implements HttpSessionBindingListener {
        private boolean valueBoundCalled = false;
        private boolean valueUnboundCalled = false;
        private boolean valueUnboundBeforeBoundCalled = false;

        private TestSessionListener() {
        }

        public void reset() {
            this.valueBoundCalled = false;
            this.valueUnboundCalled = false;
            this.valueUnboundBeforeBoundCalled = false;
        }

        public void valueBound(HttpSessionBindingEvent event) {
            this.valueBoundCalled = true;
        }

        public void valueUnbound(HttpSessionBindingEvent event) {
            this.valueUnboundCalled = true;
            if (!this.valueBoundCalled) {
                this.valueUnboundBeforeBoundCalled = true;
            }
        }

        public boolean wasValueBoundCalled() {
            return this.valueBoundCalled;
        }

        public boolean wasValueUnboundCalled() {
            return this.valueUnboundCalled;
        }

        public boolean wasValueUnboundBeforeBoundCalled() {
            return this.valueUnboundBeforeBoundCalled;
        }
    }
}

