/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.web;

import com.mockrunner.mock.web.MockRequestDispatcher;
import com.mockrunner.mock.web.MockServletContext;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.TestCase;

public class MockServletContextTest
extends TestCase {
    private MockServletContext context;

    protected void setUp() {
        this.context = new MockServletContext();
    }

    protected void tearDown() {
        this.context = null;
    }

    public void testResetAll() throws Exception {
        this.context.setAttribute("key", "value");
        this.context.addResourcePaths("path", new ArrayList());
        this.context.setResource("path", new URL("file://test"));
        this.context.resetAll();
        MockServletContextTest.assertNull((Object)this.context.getAttribute("key"));
        MockServletContextTest.assertNull((Object)this.context.getResourcePaths("path"));
        MockServletContextTest.assertNull((Object)this.context.getResource("path"));
    }

    public void testResources() throws Exception {
        this.context.setResource("testPath", new URL("http://test"));
        MockServletContextTest.assertEquals((Object)new URL("http://test"), (Object)this.context.getResource("testPath"));
        this.context.addResourcePath("testPath", "path1");
        ArrayList<String> list = new ArrayList<String>();
        list.add("path2");
        list.add("path3");
        this.context.addResourcePaths("testPath", list);
        Set paths = this.context.getResourcePaths("testPath");
        MockServletContextTest.assertTrue((paths.size() == 3 ? 1 : 0) != 0);
        MockServletContextTest.assertTrue((boolean)paths.contains("path1"));
        MockServletContextTest.assertTrue((boolean)paths.contains("path2"));
        MockServletContextTest.assertTrue((boolean)paths.contains("path3"));
        MockServletContextTest.assertNull((Object)this.context.getResourcePaths("anotherTestPath"));
        byte[] data = new byte[]{1, 2, 3};
        this.context.setResourceAsStream("testPath", data);
        InputStream stream = this.context.getResourceAsStream("testPath");
        MockServletContextTest.assertEquals((int)1, (int)stream.read());
        MockServletContextTest.assertEquals((int)2, (int)stream.read());
        MockServletContextTest.assertEquals((int)3, (int)stream.read());
        MockServletContextTest.assertEquals((int)-1, (int)stream.read());
        data[0] = 5;
        stream = this.context.getResourceAsStream("testPath");
        MockServletContextTest.assertEquals((int)1, (int)stream.read());
        MockServletContextTest.assertEquals((int)2, (int)stream.read());
        MockServletContextTest.assertEquals((int)3, (int)stream.read());
        MockServletContextTest.assertEquals((int)-1, (int)stream.read());
    }

    public void testAttributeListenerCalled() {
        TestAttributeListener listener1 = new TestAttributeListener();
        TestAttributeListener listener2 = new TestAttributeListener();
        TestAttributeListener listener3 = new TestAttributeListener();
        this.context.addAttributeListener(listener1);
        this.context.addAttributeListener(listener2);
        this.context.addAttributeListener(listener3);
        this.context.setAttribute("key", "value");
        MockServletContextTest.assertTrue((boolean)listener1.wasAttributeAddedCalled());
        MockServletContextTest.assertTrue((boolean)listener2.wasAttributeAddedCalled());
        MockServletContextTest.assertTrue((boolean)listener3.wasAttributeAddedCalled());
        MockServletContextTest.assertFalse((boolean)listener1.wasAttributeReplacedCalled());
        MockServletContextTest.assertFalse((boolean)listener2.wasAttributeReplacedCalled());
        MockServletContextTest.assertFalse((boolean)listener3.wasAttributeReplacedCalled());
        listener1.reset();
        listener2.reset();
        listener3.reset();
        this.context.setAttribute("key", "value1");
        MockServletContextTest.assertFalse((boolean)listener1.wasAttributeAddedCalled());
        MockServletContextTest.assertFalse((boolean)listener2.wasAttributeAddedCalled());
        MockServletContextTest.assertFalse((boolean)listener3.wasAttributeAddedCalled());
        MockServletContextTest.assertTrue((boolean)listener1.wasAttributeReplacedCalled());
        MockServletContextTest.assertTrue((boolean)listener2.wasAttributeReplacedCalled());
        MockServletContextTest.assertTrue((boolean)listener3.wasAttributeReplacedCalled());
        this.context.removeAttribute("key");
        MockServletContextTest.assertTrue((boolean)listener1.wasAttributeRemovedCalled());
        MockServletContextTest.assertTrue((boolean)listener2.wasAttributeRemovedCalled());
        MockServletContextTest.assertTrue((boolean)listener3.wasAttributeRemovedCalled());
    }

    public void testAttributeListenerValues() {
        TestAttributeOrderListener listener = new TestAttributeOrderListener();
        this.context.addAttributeListener(listener);
        this.context.setAttribute("key", "value");
        MockServletContextTest.assertEquals((String)"key", (String)listener.getAddedEventKey());
        MockServletContextTest.assertEquals((Object)"value", (Object)listener.getAddedEventValue());
        this.context.setAttribute("key", "anotherValue");
        MockServletContextTest.assertEquals((String)"key", (String)listener.getReplacedEventKey());
        MockServletContextTest.assertEquals((Object)"value", (Object)listener.getReplacedEventValue());
        this.context.removeAttribute("key");
        MockServletContextTest.assertEquals((String)"key", (String)listener.getRemovedEventKey());
        MockServletContextTest.assertEquals((Object)"anotherValue", (Object)listener.getRemovedEventValue());
    }

    public void testAttributeListenerNullValue() {
        TestAttributeListener listener = new TestAttributeListener();
        this.context.addAttributeListener(listener);
        this.context.setAttribute("key", null);
        MockServletContextTest.assertFalse((boolean)listener.wasAttributeAddedCalled());
        this.context.setAttribute("key", "xyz");
        MockServletContextTest.assertTrue((boolean)listener.wasAttributeAddedCalled());
        this.context.setAttribute("key", null);
        MockServletContextTest.assertTrue((boolean)listener.wasAttributeRemovedCalled());
        MockServletContextTest.assertFalse((boolean)listener.wasAttributeReplacedCalled());
        listener.reset();
        this.context.setAttribute("key", "xyz");
        MockServletContextTest.assertTrue((boolean)listener.wasAttributeAddedCalled());
        MockServletContextTest.assertFalse((boolean)listener.wasAttributeReplacedCalled());
        this.context.removeAttribute("myKey");
        MockServletContextTest.assertFalse((boolean)listener.wasAttributeRemovedCalled());
    }

    public void testGetAttributeNames() {
        Enumeration enumeration = this.context.getAttributeNames();
        MockServletContextTest.assertFalse((boolean)enumeration.hasMoreElements());
        this.context.setAttribute("key", null);
        enumeration = this.context.getAttributeNames();
        MockServletContextTest.assertFalse((boolean)enumeration.hasMoreElements());
        this.context.setAttribute("key1", "value1");
        this.context.setAttribute("key2", "value2");
        MockServletContextTest.assertEquals((Object)"value1", (Object)this.context.getAttribute("key1"));
        MockServletContextTest.assertEquals((Object)"value2", (Object)this.context.getAttribute("key2"));
        enumeration = this.context.getAttributeNames();
        ArrayList testList = new ArrayList();
        testList.add(enumeration.nextElement());
        testList.add(enumeration.nextElement());
        MockServletContextTest.assertFalse((boolean)enumeration.hasMoreElements());
        MockServletContextTest.assertTrue((boolean)testList.contains("key1"));
        MockServletContextTest.assertTrue((boolean)testList.contains("key2"));
        this.context.setAttribute("key2", null);
        MockServletContextTest.assertNull((Object)this.context.getAttribute("key2"));
        enumeration = this.context.getAttributeNames();
        testList = new ArrayList();
        testList.add(enumeration.nextElement());
        MockServletContextTest.assertFalse((boolean)enumeration.hasMoreElements());
        MockServletContextTest.assertTrue((boolean)testList.contains("key1"));
        this.context.setAttribute("key1", null);
        MockServletContextTest.assertNull((Object)this.context.getAttribute("key1"));
        enumeration = this.context.getAttributeNames();
        MockServletContextTest.assertFalse((boolean)enumeration.hasMoreElements());
    }

    public void testRequestDispatcher() throws Exception {
        String rdPath1 = "rdPathOne";
        String rdPath2 = "rdPathTwo";
        String rdPath3 = "rdPathThree";
        MockServletContextTest.assertEquals((int)0, (int)this.context.getRequestDispatcherMap().size());
        MockRequestDispatcher rd1 = (MockRequestDispatcher)this.context.getRequestDispatcher("rdPathOne");
        MockServletContextTest.assertEquals((String)"rdPathOne", (String)rd1.getPath());
        MockServletContextTest.assertNull((Object)rd1.getForwardedRequest());
        MockServletContextTest.assertNull((Object)rd1.getIncludedRequest());
        MockServletContextTest.assertEquals((int)1, (int)this.context.getRequestDispatcherMap().size());
        MockServletContextTest.assertTrue((boolean)this.context.getRequestDispatcherMap().containsKey("rdPathOne"));
        MockServletContextTest.assertSame((Object)rd1, this.context.getRequestDispatcherMap().get("rdPathOne"));
        MockRequestDispatcher actualRd2 = new MockRequestDispatcher();
        this.context.setRequestDispatcher("rdPathTwo", actualRd2);
        MockRequestDispatcher rd2 = (MockRequestDispatcher)this.context.getRequestDispatcher("rdPathTwo");
        MockServletContextTest.assertEquals((String)"rdPathTwo", (String)rd2.getPath());
        MockServletContextTest.assertSame((Object)actualRd2, (Object)rd2);
        MockServletContextTest.assertNull((Object)rd1.getForwardedRequest());
        MockServletContextTest.assertNull((Object)rd1.getIncludedRequest());
        rd2 = (MockRequestDispatcher)this.context.getNamedDispatcher("rdPathTwo");
        MockServletContextTest.assertEquals((String)"rdPathTwo", (String)rd2.getPath());
        MockServletContextTest.assertSame((Object)actualRd2, (Object)rd2);
        MockServletContextTest.assertEquals((int)2, (int)this.context.getRequestDispatcherMap().size());
        MockServletContextTest.assertTrue((boolean)this.context.getRequestDispatcherMap().containsKey("rdPathTwo"));
        MockServletContextTest.assertSame((Object)rd2, this.context.getRequestDispatcherMap().get("rdPathTwo"));
        TestRequestDispatcher actualRd3 = new TestRequestDispatcher();
        this.context.setRequestDispatcher("rdPathThree", actualRd3);
        RequestDispatcher rd3 = this.context.getRequestDispatcher("rdPathThree");
        MockServletContextTest.assertSame((Object)actualRd3, (Object)rd3);
        rd3 = this.context.getNamedDispatcher("rdPathThree");
        MockServletContextTest.assertSame((Object)actualRd3, (Object)rd3);
        MockServletContextTest.assertEquals((int)3, (int)this.context.getRequestDispatcherMap().size());
        MockServletContextTest.assertTrue((boolean)this.context.getRequestDispatcherMap().containsKey("rdPathThree"));
        MockServletContextTest.assertSame((Object)rd3, this.context.getRequestDispatcherMap().get("rdPathThree"));
        this.context.clearRequestDispatcherMap();
        MockServletContextTest.assertEquals((int)0, (int)this.context.getRequestDispatcherMap().size());
    }

    public void testSetResourceAsStream() throws Exception {
        byte[] input = new byte[]{1, 2, 3, 4};
        this.context.setResourceAsStream("testpath1", input);
        InputStream result = this.context.getResourceAsStream("testpath1");
        MockServletContextTest.assertTrue((boolean)Arrays.equals(input, StreamUtil.getStreamAsByteArray(result)));
        this.context.setResourceAsStream("testpath2", new ByteArrayInputStream(input));
        result = this.context.getResourceAsStream("testpath2");
        MockServletContextTest.assertTrue((boolean)StreamUtil.compareStreams(new ByteArrayInputStream(input), result));
    }

    public void testGetContext() throws Exception {
        MockServletContextTest.assertNull((Object)this.context.getContext("abc"));
        this.context.setContext("abc", this.context);
        MockServletContextTest.assertSame((Object)this.context, (Object)this.context.getContext("abc"));
        MockServletContext anotherContext = new MockServletContext();
        this.context.setContext("xyz", anotherContext);
        MockServletContextTest.assertSame((Object)anotherContext, (Object)this.context.getContext("xyz"));
    }

    public void testInitParameters() {
        this.context.setInitParameter("key1", "value1");
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key2", "value2");
        parameters.put("key3", "value3");
        this.context.setInitParameters(parameters);
        MockServletContextTest.assertEquals((String)"value1", (String)this.context.getInitParameter("key1"));
        MockServletContextTest.assertEquals((String)"value2", (String)this.context.getInitParameter("key2"));
        MockServletContextTest.assertEquals((String)"value3", (String)this.context.getInitParameter("key3"));
        Enumeration params = this.context.getInitParameterNames();
        ArrayList list = new ArrayList();
        list.add(params.nextElement());
        list.add(params.nextElement());
        list.add(params.nextElement());
        MockServletContextTest.assertFalse((boolean)params.hasMoreElements());
        MockServletContextTest.assertTrue((boolean)list.contains("key1"));
        MockServletContextTest.assertTrue((boolean)list.contains("key2"));
        MockServletContextTest.assertTrue((boolean)list.contains("key3"));
        this.context.clearInitParameters();
        MockServletContextTest.assertNull((Object)this.context.getInitParameter("key1"));
        params = this.context.getInitParameterNames();
        MockServletContextTest.assertFalse((boolean)params.hasMoreElements());
    }

    public void testInitParametersOverwrite() {
        MockServletContextTest.assertTrue((boolean)this.context.setInitParameter("key1", "value1"));
        MockServletContextTest.assertEquals((String)"value1", (String)this.context.getInitParameter("key1"));
        MockServletContextTest.assertFalse((boolean)this.context.setInitParameter("key1", "value2"));
        MockServletContextTest.assertEquals((String)"value1", (String)this.context.getInitParameter("key1"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("key1", "value2");
        this.context.setInitParameters(parameters);
        MockServletContextTest.assertEquals((String)"value2", (String)this.context.getInitParameter("key1"));
    }

    public void testVersion() {
        this.context.setMajorVersion(5);
        this.context.setMinorVersion(1);
        MockServletContextTest.assertEquals((int)5, (int)this.context.getMajorVersion());
        MockServletContextTest.assertEquals((int)1, (int)this.context.getMinorVersion());
    }

    private class TestRequestDispatcher
    implements RequestDispatcher {
        private TestRequestDispatcher() {
        }

        public void forward(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }

        public void include(ServletRequest request, ServletResponse response) throws ServletException, IOException {
        }
    }

    private class TestAttributeOrderListener
    implements ServletContextAttributeListener {
        private String addedEventKey;
        private Object addedEventValue;
        private String replacedEventKey;
        private Object replacedEventValue;
        private String removedEventKey;
        private Object removedEventValue;

        private TestAttributeOrderListener() {
        }

        public void attributeAdded(ServletContextAttributeEvent event) {
            this.addedEventKey = event.getName();
            this.addedEventValue = event.getValue();
        }

        public void attributeRemoved(ServletContextAttributeEvent event) {
            this.removedEventKey = event.getName();
            this.removedEventValue = event.getValue();
        }

        public void attributeReplaced(ServletContextAttributeEvent event) {
            this.replacedEventKey = event.getName();
            this.replacedEventValue = event.getValue();
        }

        public String getAddedEventKey() {
            return this.addedEventKey;
        }

        public Object getAddedEventValue() {
            return this.addedEventValue;
        }

        public String getRemovedEventKey() {
            return this.removedEventKey;
        }

        public Object getRemovedEventValue() {
            return this.removedEventValue;
        }

        public String getReplacedEventKey() {
            return this.replacedEventKey;
        }

        public Object getReplacedEventValue() {
            return this.replacedEventValue;
        }
    }

    private class TestAttributeListener
    implements ServletContextAttributeListener {
        private boolean wasAttributeAddedCalled = false;
        private boolean wasAttributeReplacedCalled = false;
        private boolean wasAttributeRemovedCalled = false;

        private TestAttributeListener() {
        }

        public void attributeAdded(ServletContextAttributeEvent event) {
            this.wasAttributeAddedCalled = true;
        }

        public void attributeRemoved(ServletContextAttributeEvent event) {
            this.wasAttributeRemovedCalled = true;
        }

        public void attributeReplaced(ServletContextAttributeEvent event) {
            this.wasAttributeReplacedCalled = true;
        }

        public void reset() {
            this.wasAttributeAddedCalled = false;
            this.wasAttributeReplacedCalled = false;
            this.wasAttributeRemovedCalled = false;
        }

        public boolean wasAttributeAddedCalled() {
            return this.wasAttributeAddedCalled;
        }

        public boolean wasAttributeRemovedCalled() {
            return this.wasAttributeRemovedCalled;
        }

        public boolean wasAttributeReplacedCalled() {
            return this.wasAttributeReplacedCalled;
        }
    }
}

