/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.base;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultiThreadTestSuite
extends TestSuite {
    private static final Log log = LogFactory.getLog(MultiThreadTestSuite.class);
    private int numberThreads;
    private boolean doClone;

    public MultiThreadTestSuite(Class theClass, String name) {
        this(theClass, name, 5, true);
    }

    public MultiThreadTestSuite(Class theClass) {
        this(theClass, 5, true);
    }

    public MultiThreadTestSuite(Class theClass, String name, int numberThreads, boolean doClone) {
        super(theClass, name);
        this.numberThreads = numberThreads;
        this.doClone = doClone;
    }

    public MultiThreadTestSuite(Class theClass, int numberThreads, boolean doClone) {
        super(theClass);
        this.numberThreads = numberThreads;
        this.doClone = doClone;
    }

    public void run(TestResult result) {
        Enumeration tests = this.tests();
        while (tests.hasMoreElements()) {
            if (result.shouldStop()) {
                return;
            }
            TestCase currentTest = (TestCase)tests.nextElement();
            List threads = this.createThreadListForTest(currentTest, result);
            this.runAllThreadsForTest(threads);
        }
    }

    private Test createNewTestInstanceBasedOn(TestCase test) {
        TestCase newTest = null;
        try {
            Constructor constructor = MultiThreadTestSuite.getTestConstructor(test.getClass());
            if (constructor.getParameterTypes().length == 0) {
                newTest = (TestCase)constructor.newInstance(new Object[0]);
                newTest.setName(test.getName());
            } else {
                newTest = (TestCase)constructor.newInstance(test.getName());
            }
        }
        catch (Exception exc) {
            log.error((Object)exc.getMessage(), (Throwable)exc);
        }
        return newTest;
    }

    private List createThreadListForTest(TestCase currentTest, TestResult result) {
        ArrayList<TestThread> threads = new ArrayList<TestThread>(this.numberThreads);
        for (int ii = 0; ii < this.numberThreads; ++ii) {
            TestCase newTest = currentTest;
            if (this.doClone) {
                newTest = this.createNewTestInstanceBasedOn(currentTest);
            }
            TestThread thread = new TestThread("TestThread " + ii, (Test)newTest, result);
            threads.add(thread);
        }
        return threads;
    }

    private void runAllThreadsForTest(List threads) {
        Thread thread;
        int ii;
        for (ii = 0; ii < threads.size(); ++ii) {
            thread = (Thread)threads.get(ii);
            thread.start();
        }
        for (ii = 0; ii < threads.size(); ++ii) {
            thread = (Thread)threads.get(ii);
            try {
                thread.join();
                continue;
            }
            catch (InterruptedException exc) {
                log.error((Object)"Interrupted", (Throwable)exc);
            }
        }
    }

    private static class TestThread
    extends Thread {
        private Test test;
        private TestResult result;

        public TestThread(String name, Test test, TestResult result) {
            super(name);
            this.test = test;
            this.result = result;
        }

        @Override
        public void run() {
            this.test.run(this.result);
        }
    }
}

