/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.util.common.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SQLStatementMatcher {
    private boolean caseSensitive = false;
    private boolean exactMatch = false;
    private boolean useRegularExpressions = false;

    public SQLStatementMatcher(boolean caseSensitive, boolean exactMatch) {
        this(caseSensitive, exactMatch, false);
    }

    public SQLStatementMatcher(boolean caseSensitive, boolean exactMatch, boolean useRegularExpressions) {
        this.caseSensitive = caseSensitive;
        this.exactMatch = exactMatch;
        this.useRegularExpressions = useRegularExpressions;
    }

    public List getMatchingObjects(Map dataMap, String query, boolean resolveCollection, boolean queryContainsMapData) {
        if (null == query) {
            query = "";
        }
        Iterator iterator = dataMap.keySet().iterator();
        ArrayList resultList = new ArrayList();
        while (iterator.hasNext()) {
            String currentQuery;
            String source;
            String nextKey = (String)iterator.next();
            if (queryContainsMapData) {
                source = query;
                currentQuery = nextKey;
            } else {
                source = nextKey;
                currentQuery = query;
            }
            if (!this.doStringsMatch(source, currentQuery)) continue;
            Object matchingObject = dataMap.get(nextKey);
            if (resolveCollection && matchingObject instanceof Collection) {
                resultList.addAll((Collection)matchingObject);
                continue;
            }
            resultList.add(dataMap.get(nextKey));
        }
        return resultList;
    }

    public boolean contains(Collection col, String query, boolean queryContainsData) {
        for (String nextKey : col) {
            String currentQuery;
            String source;
            if (queryContainsData) {
                source = query;
                currentQuery = nextKey;
            } else {
                source = nextKey;
                currentQuery = query;
            }
            if (!this.doStringsMatch(source, currentQuery)) continue;
            return true;
        }
        return false;
    }

    public boolean doStringsMatch(String source, String query) {
        if (null == source) {
            source = "";
        }
        if (null == query) {
            query = "";
        }
        if (this.useRegularExpressions && !this.exactMatch) {
            return this.doPerl5Match(source, query);
        }
        return this.doSimpleMatch(source, query);
    }

    private boolean doSimpleMatch(String source, String query) {
        if (this.exactMatch) {
            return StringUtil.matchesExact((String)source, (String)query, (boolean)this.caseSensitive);
        }
        return StringUtil.matchesContains((String)source, (String)query, (boolean)this.caseSensitive);
    }

    private boolean doPerl5Match(String source, String query) {
        return StringUtil.matchesPerl5((String)source, (String)query, (boolean)this.caseSensitive);
    }
}

