/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.jdbc.AbstractOutParameterResultSetHandler;
import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockNClob;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockRef;
import com.mockrunner.mock.jdbc.MockRowId;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MockCallableStatement
extends MockPreparedStatement
implements CallableStatement {
    private AbstractOutParameterResultSetHandler resultSetHandler;
    private Map paramObjects = new HashMap();
    private Set registeredOutParameterSetIndexed = new HashSet();
    private Set registeredOutParameterSetNamed = new HashSet();
    private List batchParameters = new ArrayList();
    private Map lastOutParameters = null;
    private boolean wasNull = false;

    public MockCallableStatement(Connection connection, String sql) {
        super(connection, sql);
    }

    public MockCallableStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency) {
        super(connection, sql, resultSetType, resultSetConcurrency);
    }

    public MockCallableStatement(Connection connection, String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) {
        super(connection, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
    }

    public void setCallableStatementResultSetHandler(AbstractOutParameterResultSetHandler resultSetHandler) {
        super.setPreparedStatementResultSetHandler(resultSetHandler);
        this.resultSetHandler = resultSetHandler;
    }

    public Map getNamedParameterMap() {
        return Collections.unmodifiableMap(this.paramObjects);
    }

    public Map getParameterMap() {
        HashMap parameterMap = new HashMap(this.getIndexedParameterMap());
        parameterMap.putAll(this.getNamedParameterMap());
        return Collections.unmodifiableMap(parameterMap);
    }

    public Object getParameter(String name) {
        return this.paramObjects.get(name);
    }

    public void clearParameters() throws SQLException {
        super.clearParameters();
        this.paramObjects.clear();
    }

    public Set getNamedRegisteredOutParameterSet() {
        return Collections.unmodifiableSet(this.registeredOutParameterSetNamed);
    }

    public boolean isOutParameterRegistered(int index) {
        return this.registeredOutParameterSetIndexed.contains(new Integer(index));
    }

    public Set getIndexedRegisteredOutParameterSet() {
        return Collections.unmodifiableSet(this.registeredOutParameterSetIndexed);
    }

    public boolean isOutParameterRegistered(String parameterName) {
        return this.registeredOutParameterSetNamed.contains(parameterName);
    }

    public void clearRegisteredOutParameter() {
        this.registeredOutParameterSetIndexed.clear();
        this.registeredOutParameterSetNamed.clear();
    }

    public ResultSet executeQuery() throws SQLException {
        ResultSet resultSet = this.executeQuery(this.getParameterMap());
        this.lastOutParameters = this.getOutParameterMap();
        return resultSet;
    }

    public int executeUpdate() throws SQLException {
        int updateCount = this.executeUpdate(this.getParameterMap());
        this.lastOutParameters = this.getOutParameterMap();
        return updateCount;
    }

    public void addBatch() throws SQLException {
        this.batchParameters.add(new HashMap(this.getParameterMap()));
    }

    public int[] executeBatch() throws SQLException {
        return this.executeBatch(this.batchParameters);
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this.registeredOutParameterSetIndexed.add(new Integer(parameterIndex));
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this.registeredOutParameterSetNamed.add(parameterName);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this.registerOutParameter(parameterName, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this.registerOutParameter(parameterName, sqlType);
    }

    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    public Object getObject(int parameterIndex) throws SQLException {
        this.wasNull = false;
        Object returnValue = null;
        if (null != this.lastOutParameters) {
            returnValue = this.lastOutParameters.get(new Integer(parameterIndex));
        }
        if (null == returnValue) {
            this.wasNull = true;
        }
        return returnValue;
    }

    public Object getObject(int parameterIndex, Map map) throws SQLException {
        return this.getObject(parameterIndex);
    }

    public Object getObject(int parameterIndex, Class type) throws SQLException {
        return this.getObject(parameterIndex);
    }

    public Object getObject(String parameterName, Class type) throws SQLException {
        return this.getObject(parameterName);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return new Byte(value.toString());
        }
        return 0;
    }

    public double getDouble(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return new Double(value.toString());
        }
        return 0.0;
    }

    public float getFloat(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            return new Float(value.toString()).floatValue();
        }
        return 0.0f;
    }

    public int getInt(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return new Integer(value.toString());
        }
        return 0;
    }

    public long getLong(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return new Long(value.toString());
        }
        return 0L;
    }

    public short getShort(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return new Short(value.toString());
        }
        return 0;
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return new Boolean(value.toString());
        }
        return false;
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            try {
                return value.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    public String getString(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    public String getNString(int parameterIndex) throws SQLException {
        return this.getString(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return null;
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        BigDecimal value = this.getBigDecimal(parameterIndex);
        if (null != value) {
            return value.setScale(scale);
        }
        return null;
    }

    public URL getURL(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof URL) {
                return (URL)value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Array getArray(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Array) {
                return (Array)value;
            }
            return new MockArray(value);
        }
        return null;
    }

    public Blob getBlob(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Blob) {
                return (Blob)value;
            }
            return new MockBlob(this.getBytes(parameterIndex));
        }
        return null;
    }

    public Clob getClob(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Clob) {
                return (Clob)value;
            }
            return new MockClob(this.getString(parameterIndex));
        }
        return null;
    }

    public NClob getNClob(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof NClob) {
                return (NClob)value;
            }
            if (value instanceof Clob) {
                return this.getNClobFromClob((Clob)value);
            }
            return new MockNClob(this.getString(parameterIndex));
        }
        return null;
    }

    public SQLXML getSQLXML(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof SQLXML) {
                return (SQLXML)value;
            }
            return new MockSQLXML(this.getString(parameterIndex));
        }
        return null;
    }

    public Reader getCharacterStream(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Reader) {
                return (Reader)value;
            }
            return new StringReader(this.getString(parameterIndex));
        }
        return null;
    }

    public Reader getNCharacterStream(int parameterIndex) throws SQLException {
        return this.getCharacterStream(parameterIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            return Date.valueOf(value.toString());
        }
        return null;
    }

    public Date getDate(int parameterIndex, Calendar calendar) throws SQLException {
        return this.getDate(parameterIndex);
    }

    public Ref getRef(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Ref) {
                return (Ref)value;
            }
            return new MockRef(value);
        }
        return null;
    }

    public Time getTime(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Time) {
                return (Time)value;
            }
            return Time.valueOf(value.toString());
        }
        return null;
    }

    public Time getTime(int parameterIndex, Calendar calendar) throws SQLException {
        return this.getTime(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar calendar) throws SQLException {
        return this.getTimestamp(parameterIndex);
    }

    public RowId getRowId(int parameterIndex) throws SQLException {
        Object value = this.getObject(parameterIndex);
        if (null != value) {
            if (value instanceof RowId) {
                return (RowId)value;
            }
            return new MockRowId(this.getBytes(parameterIndex));
        }
        return null;
    }

    public Object getObject(String parameterName) throws SQLException {
        this.wasNull = false;
        Object returnValue = null;
        if (null != this.lastOutParameters) {
            returnValue = this.lastOutParameters.get(parameterName);
        }
        if (null == returnValue) {
            this.wasNull = true;
        }
        return returnValue;
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this.getObject(parameterName);
    }

    public byte getByte(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            return new Byte(value.toString());
        }
        return 0;
    }

    public double getDouble(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            return new Double(value.toString());
        }
        return 0.0;
    }

    public float getFloat(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            return new Float(value.toString()).floatValue();
        }
        return 0.0f;
    }

    public int getInt(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            return new Integer(value.toString());
        }
        return 0;
    }

    public long getLong(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            return new Long(value.toString());
        }
        return 0L;
    }

    public short getShort(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            return new Short(value.toString());
        }
        return 0;
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return new Boolean(value.toString());
        }
        return false;
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof byte[]) {
                return (byte[])value;
            }
            try {
                return value.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        return null;
    }

    public String getString(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            return value.toString();
        }
        return null;
    }

    public String getNString(String parameterName) throws SQLException {
        return this.getString(parameterName);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof BigDecimal) {
                return (BigDecimal)value;
            }
            if (value instanceof Number) {
                return new BigDecimal(((Number)value).doubleValue());
            }
            return new BigDecimal(value.toString());
        }
        return null;
    }

    public URL getURL(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof URL) {
                return (URL)value;
            }
            try {
                return new URL(value.toString());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    public Array getArray(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Array) {
                return (Array)value;
            }
            return new MockArray(value);
        }
        return null;
    }

    public Blob getBlob(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Blob) {
                return (Blob)value;
            }
            return new MockBlob(this.getBytes(parameterName));
        }
        return null;
    }

    public Clob getClob(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Clob) {
                return (Clob)value;
            }
            return new MockClob(this.getString(parameterName));
        }
        return null;
    }

    public NClob getNClob(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof NClob) {
                return (NClob)value;
            }
            if (value instanceof Clob) {
                return this.getNClobFromClob((Clob)value);
            }
            return new MockNClob(this.getString(parameterName));
        }
        return null;
    }

    public SQLXML getSQLXML(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof SQLXML) {
                return (SQLXML)value;
            }
            return new MockSQLXML(this.getString(parameterName));
        }
        return null;
    }

    public Reader getCharacterStream(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Reader) {
                return (Reader)value;
            }
            return new StringReader(this.getString(parameterName));
        }
        return null;
    }

    public Reader getNCharacterStream(String parameterName) throws SQLException {
        return this.getCharacterStream(parameterName);
    }

    public Date getDate(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Date) {
                return (Date)value;
            }
            return Date.valueOf(value.toString());
        }
        return null;
    }

    public Date getDate(String parameterName, Calendar calendar) throws SQLException {
        return this.getDate(parameterName);
    }

    public Ref getRef(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Ref) {
                return (Ref)value;
            }
            return new MockRef(value);
        }
        return null;
    }

    public Time getTime(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Time) {
                return (Time)value;
            }
            return Time.valueOf(value.toString());
        }
        return null;
    }

    public Time getTime(String parameterName, Calendar calendar) throws SQLException {
        return this.getTime(parameterName);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            return Timestamp.valueOf(value.toString());
        }
        return null;
    }

    public Timestamp getTimestamp(String parameterName, Calendar calendar) throws SQLException {
        return this.getTimestamp(parameterName);
    }

    public RowId getRowId(String parameterName) throws SQLException {
        Object value = this.getObject(parameterName);
        if (null != value) {
            if (value instanceof RowId) {
                return (RowId)value;
            }
            return new MockRowId(this.getBytes(parameterName));
        }
        return null;
    }

    public void setByte(String parameterName, byte byteValue) throws SQLException {
        this.setObject(parameterName, (Object)new Byte(byteValue));
    }

    public void setDouble(String parameterName, double doubleValue) throws SQLException {
        this.setObject(parameterName, (Object)new Double(doubleValue));
    }

    public void setFloat(String parameterName, float floatValue) throws SQLException {
        this.setObject(parameterName, (Object)new Float(floatValue));
    }

    public void setInt(String parameterName, int intValue) throws SQLException {
        this.setObject(parameterName, (Object)new Integer(intValue));
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this.setObject(parameterName, null);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this.setNull(parameterName, sqlType);
    }

    public void setLong(String parameterName, long longValue) throws SQLException {
        this.setObject(parameterName, (Object)new Long(longValue));
    }

    public void setShort(String parameterName, short shortValue) throws SQLException {
        this.setObject(parameterName, (Object)new Short(shortValue));
    }

    public void setBoolean(String parameterName, boolean booleanValue) throws SQLException {
        this.setObject(parameterName, (Object)new Boolean(booleanValue));
    }

    public void setBytes(String parameterName, byte[] byteArray) throws SQLException {
        this.setObject(parameterName, (Object)byteArray);
    }

    public void setAsciiStream(String parameterName, InputStream stream) throws SQLException {
        this.setBinaryStream(parameterName, stream);
    }

    public void setAsciiStream(String parameterName, InputStream stream, int length) throws SQLException {
        this.setBinaryStream(parameterName, stream, length);
    }

    public void setAsciiStream(String parameterName, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterName, stream, length);
    }

    public void setBinaryStream(String parameterName, InputStream stream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream);
        this.setObject(parameterName, (Object)new ByteArrayInputStream(data));
    }

    public void setBinaryStream(String parameterName, InputStream stream, int length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)stream, (int)length);
        this.setObject(parameterName, (Object)new ByteArrayInputStream(data));
    }

    public void setBinaryStream(String parameterName, InputStream stream, long length) throws SQLException {
        this.setBinaryStream(parameterName, stream, (int)length);
    }

    public void setCharacterStream(String parameterName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setObject(parameterName, (Object)new StringReader(data));
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)length);
        this.setObject(parameterName, (Object)new StringReader(data));
    }

    public void setCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterName, reader, (int)length);
    }

    public void setNCharacterStream(String parameterName, Reader reader) throws SQLException {
        this.setCharacterStream(parameterName, reader);
    }

    public void setNCharacterStream(String parameterName, Reader reader, long length) throws SQLException {
        this.setCharacterStream(parameterName, reader, length);
    }

    public void setBlob(String parameterName, Blob blob) throws SQLException {
        this.setObject(parameterName, (Object)blob);
    }

    public void setBlob(String parameterName, InputStream inputStream) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream);
        this.setBlob(parameterName, (Blob)new MockBlob(data));
    }

    public void setBlob(String parameterName, InputStream inputStream, long length) throws SQLException {
        byte[] data = StreamUtil.getStreamAsByteArray((InputStream)inputStream, (int)((int)length));
        this.setBlob(parameterName, (Blob)new MockBlob(data));
    }

    public void setClob(String parameterName, Clob clob) throws SQLException {
        this.setObject(parameterName, (Object)clob);
    }

    public void setClob(String parameterName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setClob(parameterName, (Clob)new MockClob(data));
    }

    public void setClob(String parameterName, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setClob(parameterName, (Clob)new MockClob(data));
    }

    public void setNClob(String parameterName, NClob nClob) throws SQLException {
        this.setObject(parameterName, (Object)nClob);
    }

    public void setNClob(String parameterName, Reader reader) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader);
        this.setNClob(parameterName, (NClob)new MockNClob(data));
    }

    public void setNClob(String parameterName, Reader reader, long length) throws SQLException {
        String data = StreamUtil.getReaderAsString((Reader)reader, (int)((int)length));
        this.setNClob(parameterName, (NClob)new MockNClob(data));
    }

    public void setSQLXML(String parameterName, SQLXML xmlObject) throws SQLException {
        this.setObject(parameterName, (Object)xmlObject);
    }

    public void setString(String parameterName, String string) throws SQLException {
        this.setObject(parameterName, (Object)string);
    }

    public void setNString(String parameterName, String string) throws SQLException {
        this.setObject(parameterName, (Object)string);
    }

    public void setBigDecimal(String parameterName, BigDecimal bigDecimal) throws SQLException {
        this.setObject(parameterName, (Object)bigDecimal);
    }

    public void setURL(String parameterName, URL url) throws SQLException {
        this.setObject(parameterName, (Object)url);
    }

    public void setDate(String parameterName, Date date) throws SQLException {
        this.setObject(parameterName, (Object)date);
    }

    public void setTime(String parameterName, Time time) throws SQLException {
        this.setObject(parameterName, (Object)time);
    }

    public void setTimestamp(String parameterName, Timestamp timestamp) throws SQLException {
        this.setObject(parameterName, (Object)timestamp);
    }

    public void setDate(String parameterName, Date date, Calendar calendar) throws SQLException {
        this.setDate(parameterName, date);
    }

    public void setTime(String parameterName, Time time, Calendar calendar) throws SQLException {
        this.setTime(parameterName, time);
    }

    public void setTimestamp(String parameterName, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(parameterName, timestamp);
    }

    public void setRowId(String parameterName, RowId rowId) throws SQLException {
        this.setObject(parameterName, (Object)rowId);
    }

    public void setObject(String parameterName, Object object) throws SQLException {
        this.paramObjects.put(parameterName, object);
    }

    public void setObject(String parameterName, Object object, int targetSqlType) throws SQLException {
        this.setObject(parameterName, object);
    }

    public void setObject(String parameterName, Object object, int targetSqlType, int scale) throws SQLException {
        this.setObject(parameterName, object);
    }

    private Map getOutParameterMap() {
        Map outParameter = this.resultSetHandler.getOutParameter(this.getSQL(), this.getParameterMap());
        if (null == outParameter) {
            outParameter = this.resultSetHandler.getOutParameter(this.getSQL());
        }
        if (null == outParameter) {
            outParameter = this.resultSetHandler.getGlobalOutParameter();
        }
        if (this.resultSetHandler.getMustRegisterOutParameters()) {
            return this.filterNotRegisteredParameters(outParameter);
        }
        return outParameter;
    }

    private Map filterNotRegisteredParameters(Map outParameter) {
        HashMap filteredMap = new HashMap();
        for (Object nextKey : outParameter.keySet()) {
            if (!this.registeredOutParameterSetIndexed.contains(nextKey) && !this.registeredOutParameterSetNamed.contains(nextKey)) continue;
            filteredMap.put(nextKey, outParameter.get(nextKey));
        }
        return Collections.unmodifiableMap(filteredMap);
    }

    private NClob getNClobFromClob(Clob clobValue) throws SQLException {
        return new MockNClob(clobValue.getSubString(1L, (int)clobValue.length()));
    }
}

