/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.input.SAXHandler;
import org.jdom.output.DOMOutputter;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;

public class MockSQLXML
implements SQLXML,
Cloneable {
    private DocumentBuilder domParser;
    private SAXParser saxParser;
    private XMLOutputFactory outputFactory;
    private XMLInputFactory inputFactory;
    private SAXBuilder jdomParser;
    private DOMBuilder jdomDOMBuilder;
    private XMLOutputter xmlPrintOutputter;
    private DOMOutputter domOutputter;
    private XMLOutputter xmlCompareOutputter;
    private Object content;
    private boolean wasFreeCalled;
    private boolean wasWriteMethodCalled;
    private boolean wasReadMethodCalled;

    public MockSQLXML() {
        this.createXMLObjects();
        this.content = null;
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(String stringContent) {
        this.createXMLObjects();
        this.content = stringContent;
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(Reader readerContent) {
        this.createXMLObjects();
        this.content = StreamUtil.getReaderAsString((Reader)readerContent);
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(InputStream inputStreamContent) {
        this.createXMLObjects();
        this.content = StreamUtil.getStreamAsByteArray((InputStream)inputStreamContent);
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    public MockSQLXML(org.w3c.dom.Document documentContent) {
        this.createXMLObjects();
        this.content = documentContent;
        this.wasFreeCalled = false;
        this.wasWriteMethodCalled = false;
        this.wasReadMethodCalled = false;
    }

    protected DocumentBuilder createDocumentBuilder() {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    protected SAXParser createSAXParser() {
        try {
            return SAXParserFactory.newInstance().newSAXParser();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    protected XMLOutputFactory createXMLOutputFactory() {
        return XMLOutputFactory.newInstance();
    }

    protected XMLInputFactory createXMLInputFactory() {
        return XMLInputFactory.newInstance();
    }

    protected SAXBuilder createJDOMSAXBuilder() {
        SAXBuilder builder = new SAXBuilder();
        builder.setValidation(false);
        return builder;
    }

    protected DOMBuilder createJDOMDOMBuilder() {
        return new DOMBuilder();
    }

    protected XMLOutputter createJDOMXMLPrintOutputter() {
        return new XMLOutputter(Format.getPrettyFormat());
    }

    protected XMLOutputter createJDOMXMLCompareOutputter() {
        Format format = Format.getCompactFormat();
        format.setOmitDeclaration(true);
        format.setOmitEncoding(true);
        return new XMLOutputter(format);
    }

    protected DOMOutputter createJDOMDOMOutputter() {
        return new DOMOutputter();
    }

    public String getContentAsString() {
        try {
            return this.contentToString();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public InputStream getContentAsInputStream() throws SQLException {
        try {
            return this.contentToInputStream();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public Reader getContentAsReader() throws SQLException {
        try {
            return this.contentToReader();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public org.w3c.dom.Document getContentAsW3CDocument() {
        try {
            return this.contentToW3CDocument();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public InputStream getBinaryStream() throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            return this.contentToInputStream();
        }
        catch (Exception exc) {
            throw new SQLException(exc);
        }
    }

    public Reader getCharacterStream() throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            return this.contentToReader();
        }
        catch (Exception exc) {
            throw new SQLException(exc);
        }
    }

    public Source getSource(Class sourceClass) throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            if (null == sourceClass || StreamSource.class.equals((Object)sourceClass)) {
                return new StreamSource(this.contentToInputStream());
            }
            if (DOMSource.class.equals((Object)sourceClass)) {
                return new DOMSource(this.contentToW3CDocument());
            }
            if (SAXSource.class.equals((Object)sourceClass)) {
                return new SAXSource(this.saxParser.getXMLReader(), new InputSource(this.contentToInputStream()));
            }
            if (StAXSource.class.equals((Object)sourceClass)) {
                return new StAXSource(this.contentToXMLStreamReader());
            }
        }
        catch (Exception exc) {
            throw new SQLException(exc);
        }
        throw new SQLException(sourceClass.getName() + " not supported as Source");
    }

    public String getString() throws SQLException {
        this.verifyRead();
        this.wasReadMethodCalled = true;
        try {
            return this.contentToString();
        }
        catch (Exception exc) {
            throw new SQLException(exc);
        }
    }

    public OutputStream setBinaryStream() throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        this.content = new ByteArrayOutputStream();
        return (OutputStream)this.content;
    }

    public Writer setCharacterStream() throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        this.content = new StringWriter();
        return (Writer)this.content;
    }

    public Result setResult(Class resultClass) throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        if (null == resultClass || StreamResult.class.equals((Object)resultClass)) {
            this.content = new ByteArrayOutputStream();
            return new StreamResult((OutputStream)this.content);
        }
        if (DOMResult.class.equals((Object)resultClass)) {
            org.w3c.dom.Document document = this.domParser.newDocument();
            this.content = new DOMResult(document);
            return (DOMResult)this.content;
        }
        if (SAXResult.class.equals((Object)resultClass)) {
            this.content = new SAXHandler();
            return new SAXResult((ContentHandler)((SAXHandler)this.content));
        }
        if (StAXResult.class.equals((Object)resultClass)) {
            XMLStreamWriter xmlWriter;
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            try {
                xmlWriter = this.outputFactory.createXMLStreamWriter(outStream);
            }
            catch (XMLStreamException exc) {
                throw new SQLException(exc);
            }
            this.content = new StreamWriterOutputStreamMapping(xmlWriter, outStream);
            return new StAXResult(xmlWriter);
        }
        throw new SQLException(resultClass.getName() + " not supported as Result");
    }

    public void setString(String value) throws SQLException {
        this.verifyWrite();
        this.wasWriteMethodCalled = true;
        this.content = value;
    }

    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean isReadable() {
        return !this.wasFreeCalled && !this.wasReadMethodCalled;
    }

    public boolean isWriteable() {
        return !this.wasFreeCalled && !this.wasWriteMethodCalled;
    }

    public boolean equals(Object otherObject) {
        if (null == otherObject) {
            return false;
        }
        if (this == otherObject) {
            return true;
        }
        if (!otherObject.getClass().equals(this.getClass())) {
            return false;
        }
        MockSQLXML otherSQLXML = (MockSQLXML)otherObject;
        if (this.wasFreeCalled != otherSQLXML.wasFreeCalled()) {
            return false;
        }
        if (null == this.content && null == otherSQLXML.content) {
            return true;
        }
        if (null == this.content || null == otherSQLXML.content) {
            return false;
        }
        try {
            Document thisContent = this.contentToJDOMDocument();
            Document otherContent = otherSQLXML.contentToJDOMDocument();
            if (null == thisContent || null == otherContent) {
                return false;
            }
            String thisContentAsString = this.xmlCompareOutputter.outputString(thisContent);
            String otherContentAsString = this.xmlCompareOutputter.outputString(otherContent);
            return thisContentAsString.equals(otherContentAsString);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public int hashCode() {
        int hashCode = 17;
        if (null != this.content) {
            try {
                Document document = this.contentToJDOMDocument();
                if (null == document) {
                    return hashCode;
                }
                String documentAsString = this.xmlCompareOutputter.outputString(document);
                if (null != documentAsString) {
                    hashCode = 31 * hashCode + documentAsString.hashCode();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        hashCode = 31 * hashCode + (this.wasFreeCalled ? 31 : 62);
        return hashCode;
    }

    public Object clone() {
        try {
            MockSQLXML other = (MockSQLXML)super.clone();
            other.domParser = this.createDocumentBuilder();
            other.saxParser = this.createSAXParser();
            other.outputFactory = this.createXMLOutputFactory();
            other.inputFactory = this.createXMLInputFactory();
            other.jdomParser = this.createJDOMSAXBuilder();
            other.jdomDOMBuilder = this.createJDOMDOMBuilder();
            other.xmlPrintOutputter = this.createJDOMXMLPrintOutputter();
            other.domOutputter = this.createJDOMDOMOutputter();
            other.xmlCompareOutputter = this.createJDOMXMLCompareOutputter();
            if (null != this.content) {
                try {
                    Document document = this.contentToJDOMDocument();
                    other.content = document.clone();
                }
                catch (Exception exc) {
                    other.content = null;
                }
            }
            return other;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("XML data:\n");
        if (null == this.content) {
            buffer.append("null");
        } else {
            try {
                Document document = this.contentToJDOMDocument();
                if (null != document) {
                    buffer.append(document.toString());
                }
            }
            catch (Exception exc) {
                buffer.append(exc.getMessage());
            }
        }
        return buffer.toString();
    }

    private void createXMLObjects() {
        this.domParser = this.createDocumentBuilder();
        this.saxParser = this.createSAXParser();
        this.outputFactory = this.createXMLOutputFactory();
        this.inputFactory = this.createXMLInputFactory();
        this.jdomParser = this.createJDOMSAXBuilder();
        this.jdomDOMBuilder = this.createJDOMDOMBuilder();
        this.xmlPrintOutputter = this.createJDOMXMLPrintOutputter();
        this.domOutputter = this.createJDOMDOMOutputter();
        this.xmlCompareOutputter = this.createJDOMXMLCompareOutputter();
    }

    private void verifyWrite() throws SQLException {
        if (!this.isWriteable()) {
            throw new SQLException("not writeable");
        }
    }

    private void verifyRead() throws SQLException {
        if (!this.isReadable()) {
            throw new SQLException("not readable");
        }
        if (null == this.content) {
            throw new SQLException("no content");
        }
    }

    private Document contentToJDOMDocument() throws Exception {
        Document jdomDocument = null;
        if (this.content instanceof Document) {
            jdomDocument = (Document)this.content;
        } else if (this.content instanceof String) {
            jdomDocument = this.jdomParser.build((Reader)new StringReader((String)this.content));
        } else if (this.content instanceof StringWriter) {
            jdomDocument = this.jdomParser.build((Reader)new StringReader(((StringWriter)this.content).toString()));
        } else if (this.content instanceof ByteArrayOutputStream) {
            jdomDocument = this.jdomParser.build((InputStream)new ByteArrayInputStream(((ByteArrayOutputStream)this.content).toByteArray()));
        } else if (this.content instanceof byte[]) {
            jdomDocument = this.jdomParser.build((InputStream)new ByteArrayInputStream((byte[])this.content));
        } else if (this.content instanceof org.w3c.dom.Document) {
            jdomDocument = this.jdomDOMBuilder.build((org.w3c.dom.Document)this.content);
        } else if (this.content instanceof DOMResult) {
            Node node = ((DOMResult)this.content).getNode();
            org.w3c.dom.Document document = null;
            if (node instanceof org.w3c.dom.Document) {
                document = (org.w3c.dom.Document)node;
            } else {
                document = this.domParser.newDocument();
                document.appendChild(document.importNode(node, true));
            }
            jdomDocument = this.jdomDOMBuilder.build(document);
        } else if (this.content instanceof SAXHandler) {
            jdomDocument = ((SAXHandler)this.content).getDocument();
        } else if (this.content instanceof StreamWriterOutputStreamMapping) {
            XMLStreamWriter xmlWriter = ((StreamWriterOutputStreamMapping)this.content).getStreamWriter();
            xmlWriter.flush();
            xmlWriter.close();
            ByteArrayOutputStream outStream = ((StreamWriterOutputStreamMapping)this.content).getOutputStream();
            jdomDocument = this.jdomParser.build((InputStream)new ByteArrayInputStream(outStream.toByteArray()));
        }
        return jdomDocument;
    }

    private String contentToString() throws Exception {
        Document jdomDocument = this.contentToJDOMDocument();
        if (null != jdomDocument) {
            return this.xmlPrintOutputter.outputString(jdomDocument);
        }
        return null;
    }

    private Reader contentToReader() throws Exception {
        Document jdomDocument = this.contentToJDOMDocument();
        if (null != jdomDocument) {
            return new StringReader(this.xmlPrintOutputter.outputString(jdomDocument));
        }
        return null;
    }

    private InputStream contentToInputStream() throws Exception {
        Document jdomDocument = this.contentToJDOMDocument();
        if (null != jdomDocument) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.xmlPrintOutputter.output(jdomDocument, (OutputStream)outStream);
            outStream.flush();
            return new ByteArrayInputStream(outStream.toByteArray());
        }
        return null;
    }

    private org.w3c.dom.Document contentToW3CDocument() throws Exception {
        Document jdomDocument = this.contentToJDOMDocument();
        if (null != jdomDocument) {
            return this.domOutputter.output(jdomDocument);
        }
        return null;
    }

    private XMLStreamReader contentToXMLStreamReader() throws Exception {
        Document jdomDocument = this.contentToJDOMDocument();
        if (null != jdomDocument) {
            ByteArrayOutputStream outStream = new ByteArrayOutputStream();
            this.xmlPrintOutputter.output(jdomDocument, (OutputStream)outStream);
            outStream.flush();
            ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
            return this.inputFactory.createXMLStreamReader(inStream);
        }
        return null;
    }

    private class StreamWriterOutputStreamMapping {
        private XMLStreamWriter streamWriter;
        private ByteArrayOutputStream outputStream;

        public StreamWriterOutputStreamMapping(XMLStreamWriter streamWriter, ByteArrayOutputStream outputStream) {
            this.streamWriter = streamWriter;
            this.outputStream = outputStream;
        }

        public XMLStreamWriter getStreamWriter() {
            return this.streamWriter;
        }

        public ByteArrayOutputStream getOutputStream() {
            return this.outputStream;
        }
    }
}

