/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockArray;
import com.mockrunner.mock.jdbc.MockBlob;
import com.mockrunner.mock.jdbc.MockClob;
import com.mockrunner.mock.jdbc.MockConnection;
import com.mockrunner.mock.jdbc.MockDatabaseMetaData;
import com.mockrunner.mock.jdbc.MockPreparedStatement;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.mock.jdbc.MockStruct;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.TestCase;

public class MockConnectionTest
extends TestCase {
    private MockConnection connection;

    protected void setUp() throws Exception {
        super.setUp();
        this.connection = new MockConnection();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.connection = null;
    }

    public void testDatabaseMetaData() throws SQLException {
        MockConnectionTest.assertNotNull((Object)this.connection.getMetaData());
        MockConnectionTest.assertTrue((boolean)(this.connection.getMetaData() instanceof MockDatabaseMetaData));
        MockConnectionTest.assertSame((Object)this.connection, (Object)this.connection.getMetaData().getConnection());
        this.connection.setMetaData(null);
        MockConnectionTest.assertNull((Object)this.connection.getMetaData());
        this.connection.setMetaData(new MockDatabaseMetaData());
        MockConnectionTest.assertNotNull((Object)this.connection.getMetaData());
        MockConnectionTest.assertTrue((boolean)(this.connection.getMetaData() instanceof MockDatabaseMetaData));
        MockConnectionTest.assertSame((Object)this.connection, (Object)this.connection.getMetaData().getConnection());
    }

    public void testPrepareStatementAutoGeneratedKeys() throws SQLException {
        MockResultSet resultSet = new MockResultSet("testid");
        try {
            this.connection.prepareStatement("select", 50000);
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockPreparedStatement statement = (MockPreparedStatement)this.connection.prepareStatement("select", 1);
        this.connection.getPreparedStatementResultSetHandler().prepareGeneratedKeys("select", resultSet);
        statement.execute();
        MockConnectionTest.assertEquals((String)"testid", (String)((MockResultSet)statement.getGeneratedKeys()).getId());
        statement = (MockPreparedStatement)this.connection.prepareStatement("select", 2);
        statement.execute();
        MockConnectionTest.assertTrue((((MockResultSet)statement.getGeneratedKeys()).getId().indexOf("testid") < 0 ? 1 : 0) != 0);
    }

    public void testClientInfo() throws SQLException {
        MockConnectionTest.assertNull((Object)this.connection.getClientInfo("name"));
        MockConnectionTest.assertTrue((boolean)this.connection.getClientInfo().isEmpty());
        this.connection.getClientInfo().setProperty("name", "value");
        MockConnectionTest.assertNull((Object)this.connection.getClientInfo("name"));
        MockConnectionTest.assertTrue((boolean)this.connection.getClientInfo().isEmpty());
        this.connection.setClientInfo("name", "value");
        MockConnectionTest.assertEquals((String)"value", (String)this.connection.getClientInfo("name"));
        MockConnectionTest.assertEquals((String)"value", (String)this.connection.getClientInfo().getProperty("name"));
        this.connection.setClientInfo(new Properties());
        MockConnectionTest.assertNull((Object)this.connection.getClientInfo("name"));
        MockConnectionTest.assertTrue((boolean)this.connection.getClientInfo().isEmpty());
        Properties properties = new Properties();
        properties.setProperty("name", "value");
        this.connection.setClientInfo(properties);
        MockConnectionTest.assertEquals((int)1, (int)this.connection.getClientInfo().size());
        MockConnectionTest.assertEquals((String)"value", (String)this.connection.getClientInfo().getProperty("name"));
        MockConnectionTest.assertEquals((String)"value", (String)this.connection.getClientInfo("name"));
    }

    public void testCreateTypes() throws SQLException {
        MockBlob blob = (MockBlob)this.connection.createBlob();
        MockConnectionTest.assertEquals((long)0L, (long)blob.length());
        MockClob clob = (MockClob)this.connection.createClob();
        MockConnectionTest.assertEquals((long)0L, (long)clob.length());
        MockArray array = (MockArray)this.connection.createArrayOf("aName", new Object[]{"1", "2", "3"});
        MockConnectionTest.assertEquals((String)"aName", (String)array.getBaseTypeName());
        MockConnectionTest.assertTrue((boolean)Arrays.equals(new Object[]{"1", "2", "3"}, (Object[])array.getArray()));
        MockStruct struct = (MockStruct)this.connection.createStruct("aName", new Object[]{"1", "2", "3"});
        MockConnectionTest.assertEquals((String)"aName", (String)struct.getSQLTypeName());
        Object[] attributes = struct.getAttributes();
        MockConnectionTest.assertEquals((Object)"1", (Object)attributes[0]);
        MockConnectionTest.assertEquals((Object)"2", (Object)attributes[1]);
        MockConnectionTest.assertEquals((Object)"3", (Object)attributes[2]);
        MockSQLXML sqlXML = (MockSQLXML)this.connection.createSQLXML();
        MockConnectionTest.assertNull((Object)sqlXML.getContentAsString());
    }

    public void testDisconnect() throws SQLException {
        MockConnectionTest.assertFalse((boolean)this.connection.isClosed());
        MockConnectionTest.assertTrue((boolean)this.connection.isValid(5));
        this.connection.close();
        MockConnectionTest.assertFalse((boolean)this.connection.isValid(5));
        MockConnectionTest.assertTrue((boolean)this.connection.isClosed());
    }
}

