/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.mock.jdbc.MockSQLXML;
import com.mockrunner.util.common.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.sql.SQLException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stax.StAXResult;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import junit.framework.TestCase;
import org.jdom.Document;
import org.jdom.input.DOMBuilder;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class MockSQLXMLTest
extends TestCase {
    private MockSQLXML stringSQLXML;
    private MockSQLXML readerSQLXML;
    private MockSQLXML inputStreamSQLXML;
    private MockSQLXML w3cDocumentSQLXML;

    private void prepareTestSQLXMLObjects() throws Exception {
        this.stringSQLXML = new MockSQLXML(this.getFirstTestXMLAsString());
        this.readerSQLXML = new MockSQLXML(this.getTestXMLAsReader(this.getFirstTestXMLAsString()));
        this.inputStreamSQLXML = new MockSQLXML(this.getTestXMLAsInputStream(this.getFirstTestXMLAsString()));
        this.w3cDocumentSQLXML = new MockSQLXML(this.getTestXMLAsW3CDocument(this.getFirstTestXMLAsString()));
    }

    private Reader getTestXMLAsReader(String xml) throws Exception {
        return new StringReader(xml);
    }

    private InputStream getTestXMLAsInputStream(String xml) throws Exception {
        return new ByteArrayInputStream(xml.getBytes("UTF-8"));
    }

    private org.w3c.dom.Document getTestXMLAsW3CDocument(String xml) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return builder.parse(new ByteArrayInputStream(xml.getBytes("ISO-8859-1")));
    }

    private void prepareSecondTestXMLForSAX(SAXResult saxResult) throws Exception {
        ContentHandler contentHandler = saxResult.getHandler();
        contentHandler.startDocument();
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", "att1", "att1", "CDATA", "1");
        attributes.addAttribute("", "att2", "att2", "CDATA", "2");
        contentHandler.startElement("", "xyz", "xyz", attributes);
        contentHandler.characters("Hello World".toCharArray(), 0, "Hello World".toCharArray().length);
        contentHandler.endElement("", "xyz", "xyz");
        contentHandler.endDocument();
    }

    private void prepareSecondTestXMLForStAX(StAXResult staxResult) throws Exception {
        XMLStreamWriter streamWriter = staxResult.getXMLStreamWriter();
        streamWriter.writeStartDocument();
        streamWriter.writeStartElement("xyz");
        streamWriter.writeAttribute("att1", "1");
        streamWriter.writeAttribute("att2", "2");
        streamWriter.writeCharacters("Hello World");
        streamWriter.writeEndElement();
        streamWriter.writeEndDocument();
    }

    private String getFirstTestXMLAsString() {
        return "<test><subelement att=\"1\">text</subelement></test>";
    }

    private String getSecondTestXMLAsString() {
        return "<xyz att1=\"1\" att2=\"2\">Hello World</xyz>";
    }

    private XMLOutputter getCompareOutputter() {
        Format format = Format.getCompactFormat();
        format.setOmitDeclaration(true);
        format.setOmitEncoding(true);
        XMLOutputter outputter = new XMLOutputter(format);
        return outputter;
    }

    private void assertXMLEqualsTestXML(String xml, String testXML) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document expected = builder.build((Reader)new StringReader(testXML));
        Document testee = builder.build((Reader)new StringReader(xml));
        XMLOutputter outputter = this.getCompareOutputter();
        String expectedString = outputter.outputString(expected);
        String testeeString = outputter.outputString(testee);
        MockSQLXMLTest.assertEquals((String)expectedString, (String)testeeString);
    }

    private void assertXMLEqualsTestXML(org.w3c.dom.Document xml, String testXML) throws Exception {
        SAXBuilder saxBuilder = new SAXBuilder();
        Document expected = saxBuilder.build((Reader)new StringReader(testXML));
        DOMBuilder domBuilder = new DOMBuilder();
        Document testee = domBuilder.build(xml);
        XMLOutputter outputter = this.getCompareOutputter();
        String expectedString = outputter.outputString(expected);
        String testeeString = outputter.outputString(testee);
        MockSQLXMLTest.assertEquals((String)expectedString, (String)testeeString);
    }

    private void assertXMLEqualsFirstTestXML(XMLStreamReader xml) throws Exception {
        xml.nextTag();
        MockSQLXMLTest.assertEquals((String)"test", (String)xml.getLocalName());
        MockSQLXMLTest.assertEquals((int)1, (int)xml.getEventType());
        MockSQLXMLTest.assertEquals((int)0, (int)xml.getAttributeCount());
        xml.nextTag();
        MockSQLXMLTest.assertEquals((String)"subelement", (String)xml.getLocalName());
        MockSQLXMLTest.assertEquals((int)1, (int)xml.getEventType());
        MockSQLXMLTest.assertEquals((int)1, (int)xml.getAttributeCount());
        MockSQLXMLTest.assertEquals((String)"1", (String)xml.getAttributeValue(null, "att"));
        xml.next();
        MockSQLXMLTest.assertEquals((String)"text", (String)xml.getText());
        MockSQLXMLTest.assertEquals((int)4, (int)xml.getEventType());
        xml.nextTag();
        MockSQLXMLTest.assertEquals((String)"subelement", (String)xml.getLocalName());
        MockSQLXMLTest.assertEquals((int)2, (int)xml.getEventType());
        xml.nextTag();
        MockSQLXMLTest.assertEquals((String)"test", (String)xml.getLocalName());
        MockSQLXMLTest.assertEquals((int)2, (int)xml.getEventType());
    }

    private void assertXMLEqualsSecondTestXML(XMLStreamReader xml) throws Exception {
        xml.nextTag();
        MockSQLXMLTest.assertEquals((String)"xyz", (String)xml.getLocalName());
        MockSQLXMLTest.assertEquals((int)1, (int)xml.getEventType());
        MockSQLXMLTest.assertEquals((int)2, (int)xml.getAttributeCount());
        MockSQLXMLTest.assertEquals((String)"1", (String)xml.getAttributeValue(null, "att1"));
        MockSQLXMLTest.assertEquals((String)"2", (String)xml.getAttributeValue(null, "att2"));
        xml.next();
        MockSQLXMLTest.assertEquals((String)"Hello World", (String)xml.getText());
        MockSQLXMLTest.assertEquals((int)4, (int)xml.getEventType());
        xml.nextTag();
        MockSQLXMLTest.assertEquals((String)"xyz", (String)xml.getLocalName());
        MockSQLXMLTest.assertEquals((int)2, (int)xml.getEventType());
    }

    public void testGetMethods() throws Exception {
        this.prepareTestSQLXMLObjects();
        this.doTestGetString(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetString(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetString(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetString(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetCharacterStream(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetCharacterStream(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetCharacterStream(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetCharacterStream(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetBinaryStream(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetBinaryStream(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetBinaryStream(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetBinaryStream(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetContentAsDocument(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetContentAsDocument(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetContentAsDocument(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetContentAsDocument(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetStreamSource(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetStreamSource(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetStreamSource(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetStreamSource(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetDOMSource(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetDOMSource(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetDOMSource(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetDOMSource(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetSAXSource(this.stringSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetSAXSource(this.readerSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetSAXSource(this.inputStreamSQLXML, this.getFirstTestXMLAsString());
        this.doTestGetSAXSource(this.w3cDocumentSQLXML, this.getFirstTestXMLAsString());
        this.prepareTestSQLXMLObjects();
        this.doTestGetStAXSource(this.stringSQLXML, true);
        this.doTestGetStAXSource(this.readerSQLXML, true);
        this.doTestGetStAXSource(this.inputStreamSQLXML, true);
        this.doTestGetStAXSource(this.w3cDocumentSQLXML, true);
    }

    public void testSetString() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        this.stringSQLXML.setString(this.getSecondTestXMLAsString());
        this.readerSQLXML.setString(this.getSecondTestXMLAsString());
        this.inputStreamSQLXML.setString(this.getSecondTestXMLAsString());
        this.w3cDocumentSQLXML.setString(this.getSecondTestXMLAsString());
        this.doTestGetString(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetString(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetString(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetString(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetBinaryStream() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        OutputStream stringStream = this.stringSQLXML.setBinaryStream();
        OutputStream readerStream = this.readerSQLXML.setBinaryStream();
        OutputStream inputStreamStream = this.inputStreamSQLXML.setBinaryStream();
        OutputStream w3cDocumentStream = this.w3cDocumentSQLXML.setBinaryStream();
        stringStream.write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        readerStream.write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        inputStreamStream.write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        w3cDocumentStream.write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        this.doTestGetDOMSource(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetDOMSource(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetDOMSource(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetDOMSource(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetCharacterStream() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        Writer stringWriter = this.stringSQLXML.setCharacterStream();
        Writer readerWriter = this.readerSQLXML.setCharacterStream();
        Writer inputStreamWriter = this.inputStreamSQLXML.setCharacterStream();
        Writer w3cDocumentWriter = this.w3cDocumentSQLXML.setCharacterStream();
        stringWriter.write(this.getSecondTestXMLAsString());
        readerWriter.write(this.getSecondTestXMLAsString());
        inputStreamWriter.write(this.getSecondTestXMLAsString());
        w3cDocumentWriter.write(this.getSecondTestXMLAsString());
        this.doTestGetBinaryStream(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetBinaryStream(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetBinaryStream(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetBinaryStream(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetStreamResult() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        StreamResult stringResult = (StreamResult)this.stringSQLXML.setResult(StreamResult.class);
        StreamResult readerResult = (StreamResult)this.readerSQLXML.setResult(StreamResult.class);
        StreamResult inputStreamResult = (StreamResult)this.inputStreamSQLXML.setResult(StreamResult.class);
        StreamResult w3cDocumentResult = (StreamResult)this.w3cDocumentSQLXML.setResult(StreamResult.class);
        stringResult.getOutputStream().write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        readerResult.getOutputStream().write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        inputStreamResult.getOutputStream().write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        w3cDocumentResult.getOutputStream().write(this.getSecondTestXMLAsString().getBytes("UTF-8"));
        this.doTestGetSAXSource(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetSAXSource(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetSAXSource(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetSAXSource(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetDOMResultSetNode() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        DOMResult stringResult = (DOMResult)this.stringSQLXML.setResult(DOMResult.class);
        DOMResult readerResult = (DOMResult)this.readerSQLXML.setResult(DOMResult.class);
        DOMResult inputStreamResult = (DOMResult)this.inputStreamSQLXML.setResult(DOMResult.class);
        DOMResult w3cDocumentResult = (DOMResult)this.w3cDocumentSQLXML.setResult(DOMResult.class);
        stringResult.setNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()));
        readerResult.setNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()).getFirstChild());
        inputStreamResult.setNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()));
        w3cDocumentResult.setNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()).getFirstChild());
        this.doTestGetStreamSource(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetStreamSource(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetStreamSource(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetStreamSource(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetDOMResultGetNode() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        DOMResult stringResult = (DOMResult)this.stringSQLXML.setResult(DOMResult.class);
        DOMResult readerResult = (DOMResult)this.readerSQLXML.setResult(DOMResult.class);
        DOMResult inputStreamResult = (DOMResult)this.inputStreamSQLXML.setResult(DOMResult.class);
        DOMResult w3cDocumentResult = (DOMResult)this.w3cDocumentSQLXML.setResult(DOMResult.class);
        org.w3c.dom.Document stringDocument = (org.w3c.dom.Document)stringResult.getNode();
        org.w3c.dom.Document readerDocument = (org.w3c.dom.Document)readerResult.getNode();
        org.w3c.dom.Document inputStreamDocument = (org.w3c.dom.Document)inputStreamResult.getNode();
        org.w3c.dom.Document w3cDocumentDocument = (org.w3c.dom.Document)w3cDocumentResult.getNode();
        stringDocument.appendChild(stringDocument.importNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()).getFirstChild(), true));
        readerDocument.appendChild(readerDocument.importNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()).getFirstChild(), true));
        inputStreamDocument.appendChild(inputStreamDocument.importNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()).getFirstChild(), true));
        w3cDocumentDocument.appendChild(w3cDocumentDocument.importNode(this.getTestXMLAsW3CDocument(this.getSecondTestXMLAsString()).getFirstChild(), true));
        this.doTestGetStAXSource(this.stringSQLXML, false);
        this.doTestGetStAXSource(this.readerSQLXML, false);
        this.doTestGetStAXSource(this.inputStreamSQLXML, false);
        this.doTestGetStAXSource(this.w3cDocumentSQLXML, false);
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetSAXResult() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        SAXResult stringResult = (SAXResult)this.stringSQLXML.setResult(SAXResult.class);
        SAXResult readerResult = (SAXResult)this.readerSQLXML.setResult(SAXResult.class);
        SAXResult inputStreamResult = (SAXResult)this.inputStreamSQLXML.setResult(SAXResult.class);
        SAXResult w3cDocumentResult = (SAXResult)this.w3cDocumentSQLXML.setResult(SAXResult.class);
        this.prepareSecondTestXMLForSAX(stringResult);
        this.prepareSecondTestXMLForSAX(readerResult);
        this.prepareSecondTestXMLForSAX(inputStreamResult);
        this.prepareSecondTestXMLForSAX(w3cDocumentResult);
        this.doTestGetCharacterStream(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetCharacterStream(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetCharacterStream(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetCharacterStream(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testSetStAXResult() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.isWriteable());
        StAXResult stringResult = (StAXResult)this.stringSQLXML.setResult(StAXResult.class);
        StAXResult readerResult = (StAXResult)this.readerSQLXML.setResult(StAXResult.class);
        StAXResult inputStreamResult = (StAXResult)this.inputStreamSQLXML.setResult(StAXResult.class);
        StAXResult w3cDocumentResult = (StAXResult)this.w3cDocumentSQLXML.setResult(StAXResult.class);
        this.prepareSecondTestXMLForStAX(stringResult);
        this.prepareSecondTestXMLForStAX(readerResult);
        this.prepareSecondTestXMLForStAX(inputStreamResult);
        this.prepareSecondTestXMLForStAX(w3cDocumentResult);
        this.doTestGetContentAsDocument(this.stringSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetContentAsDocument(this.readerSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetContentAsDocument(this.inputStreamSQLXML, this.getSecondTestXMLAsString());
        this.doTestGetContentAsDocument(this.w3cDocumentSQLXML, this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.readerSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
    }

    public void testEquals() throws Exception {
        this.prepareTestSQLXMLObjects();
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.equals(null));
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.equals(this.stringSQLXML));
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.equals(this.w3cDocumentSQLXML));
        MockSQLXMLTest.assertEquals((int)this.stringSQLXML.hashCode(), (int)this.w3cDocumentSQLXML.hashCode());
        MockSQLXMLTest.assertTrue((boolean)this.readerSQLXML.equals(this.inputStreamSQLXML));
        MockSQLXMLTest.assertEquals((int)this.readerSQLXML.hashCode(), (int)this.inputStreamSQLXML.hashCode());
        this.stringSQLXML.setString(this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.equals(this.inputStreamSQLXML));
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.equals(this.stringSQLXML));
        Writer writer = this.inputStreamSQLXML.setCharacterStream();
        writer.write(this.getSecondTestXMLAsString());
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.equals(this.inputStreamSQLXML));
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.equals(this.stringSQLXML));
        MockSQLXMLTest.assertEquals((int)this.stringSQLXML.hashCode(), (int)this.inputStreamSQLXML.hashCode());
        this.stringSQLXML.getString();
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.isReadable());
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.isReadable());
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.equals(this.inputStreamSQLXML));
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.equals(this.stringSQLXML));
        MockSQLXMLTest.assertEquals((int)this.stringSQLXML.hashCode(), (int)this.inputStreamSQLXML.hashCode());
        this.stringSQLXML.free();
        MockSQLXMLTest.assertFalse((boolean)this.stringSQLXML.equals(this.inputStreamSQLXML));
        MockSQLXMLTest.assertFalse((boolean)this.inputStreamSQLXML.equals(this.stringSQLXML));
        this.inputStreamSQLXML.free();
        MockSQLXMLTest.assertTrue((boolean)this.stringSQLXML.equals(this.inputStreamSQLXML));
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.equals(this.stringSQLXML));
        MockSQLXMLTest.assertEquals((int)this.stringSQLXML.hashCode(), (int)this.inputStreamSQLXML.hashCode());
    }

    public void testClone() throws Exception {
        this.prepareTestSQLXMLObjects();
        this.inputStreamSQLXML.getString();
        MockSQLXML clone = (MockSQLXML)this.inputStreamSQLXML.clone();
        MockSQLXMLTest.assertFalse((boolean)clone.isReadable());
        MockSQLXMLTest.assertTrue((boolean)clone.isWriteable());
        MockSQLXMLTest.assertFalse((boolean)clone.wasFreeCalled());
        MockSQLXMLTest.assertNotSame((Object)this.inputStreamSQLXML, (Object)clone);
        MockSQLXMLTest.assertTrue((boolean)this.inputStreamSQLXML.equals(clone));
    }

    public void testFree() throws Exception {
        this.prepareTestSQLXMLObjects();
        this.w3cDocumentSQLXML.free();
        try {
            this.w3cDocumentSQLXML.getString();
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        try {
            this.w3cDocumentSQLXML.setString(this.getSecondTestXMLAsString());
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isReadable());
        MockSQLXMLTest.assertFalse((boolean)this.w3cDocumentSQLXML.isWriteable());
        MockSQLXMLTest.assertTrue((boolean)this.w3cDocumentSQLXML.wasFreeCalled());
        this.assertXMLEqualsTestXML(this.w3cDocumentSQLXML.getContentAsString(), this.getFirstTestXMLAsString());
        String xml = new String(StreamUtil.getStreamAsByteArray((InputStream)this.w3cDocumentSQLXML.getContentAsInputStream()), "UTF-8");
        this.assertXMLEqualsTestXML(xml, this.getFirstTestXMLAsString());
        xml = StreamUtil.getReaderAsString((Reader)this.w3cDocumentSQLXML.getContentAsReader());
        this.assertXMLEqualsTestXML(xml, this.getFirstTestXMLAsString());
        this.assertXMLEqualsTestXML(this.w3cDocumentSQLXML.getContentAsW3CDocument(), this.getFirstTestXMLAsString());
    }

    public void testNoContent() throws Exception {
        MockSQLXML emptySQLXML = new MockSQLXML();
        MockSQLXMLTest.assertNull((Object)emptySQLXML.getContentAsString());
        MockSQLXMLTest.assertNull((Object)emptySQLXML.getContentAsW3CDocument());
        MockSQLXMLTest.assertNull((Object)emptySQLXML.getContentAsInputStream());
        MockSQLXMLTest.assertNull((Object)emptySQLXML.getContentAsReader());
        try {
            emptySQLXML.getString();
            MockSQLXMLTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        emptySQLXML.setString(this.getFirstTestXMLAsString());
        this.assertXMLEqualsTestXML(emptySQLXML.getString(), this.getFirstTestXMLAsString());
    }

    private void doTestGetString(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        this.assertXMLEqualsTestXML(sqlXML.getContentAsString(), testXML);
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        this.assertXMLEqualsTestXML(sqlXML.getString(), testXML);
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        this.assertXMLEqualsTestXML(sqlXML.getContentAsString(), testXML);
        try {
            sqlXML.getString();
            MockSQLXMLTest.fail();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void doTestGetCharacterStream(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        String xml = StreamUtil.getReaderAsString((Reader)sqlXML.getContentAsReader());
        this.assertXMLEqualsTestXML(xml, testXML);
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        xml = StreamUtil.getReaderAsString((Reader)sqlXML.getCharacterStream());
        this.assertXMLEqualsTestXML(xml, testXML);
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        xml = StreamUtil.getReaderAsString((Reader)sqlXML.getContentAsReader());
        this.assertXMLEqualsTestXML(xml, testXML);
        try {
            sqlXML.getCharacterStream();
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }

    private void doTestGetBinaryStream(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        String xml = new String(StreamUtil.getStreamAsByteArray((InputStream)sqlXML.getContentAsInputStream()), "UTF-8");
        this.assertXMLEqualsTestXML(xml, testXML);
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        xml = new String(StreamUtil.getStreamAsByteArray((InputStream)sqlXML.getBinaryStream()), "UTF-8");
        this.assertXMLEqualsTestXML(xml, testXML);
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        xml = new String(StreamUtil.getStreamAsByteArray((InputStream)sqlXML.getContentAsInputStream()), "UTF-8");
        this.assertXMLEqualsTestXML(xml, testXML);
        try {
            sqlXML.getBinaryStream();
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }

    private void doTestGetContentAsDocument(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        this.assertXMLEqualsTestXML(sqlXML.getContentAsW3CDocument(), testXML);
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
    }

    private void doTestGetStreamSource(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        StreamSource source = (StreamSource)sqlXML.getSource(StreamSource.class);
        String xml = new String(StreamUtil.getStreamAsByteArray((InputStream)source.getInputStream()), "UTF-8");
        this.assertXMLEqualsTestXML(xml, testXML);
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        try {
            sqlXML.getSource(StreamSource.class);
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }

    private void doTestGetDOMSource(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        DOMSource source = (DOMSource)sqlXML.getSource(DOMSource.class);
        this.assertXMLEqualsTestXML((org.w3c.dom.Document)source.getNode(), testXML);
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        try {
            sqlXML.getSource(DOMSource.class);
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }

    private void doTestGetSAXSource(MockSQLXML sqlXML, String testXML) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        SAXSource source = (SAXSource)sqlXML.getSource(SAXSource.class);
        InputStream stream = source.getInputSource().getByteStream();
        String xml = new String(StreamUtil.getStreamAsByteArray((InputStream)stream), "UTF-8");
        this.assertXMLEqualsTestXML(xml, testXML);
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        try {
            sqlXML.getSource(SAXSource.class);
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }

    private void doTestGetStAXSource(MockSQLXML sqlXML, boolean testFirst) throws Exception {
        MockSQLXMLTest.assertTrue((boolean)sqlXML.isReadable());
        StAXSource source = (StAXSource)sqlXML.getSource(StAXSource.class);
        if (testFirst) {
            this.assertXMLEqualsFirstTestXML(source.getXMLStreamReader());
        } else {
            this.assertXMLEqualsSecondTestXML(source.getXMLStreamReader());
        }
        MockSQLXMLTest.assertFalse((boolean)sqlXML.isReadable());
        try {
            sqlXML.getSource(StAXSource.class);
            MockSQLXMLTest.fail();
        }
        catch (SQLException exc) {
            // empty catch block
        }
    }
}

