/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.test.jdbc;

import com.mockrunner.jdbc.XMLResultSetFactory;
import com.mockrunner.mock.jdbc.MockResultSet;
import java.io.File;
import junit.framework.TestCase;

public class XMLResultSetFactoryTest
extends TestCase {
    public void testSybaseCreate() {
        XMLResultSetFactory goodSybaseXMLRSF = new XMLResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/xmltestresult.xml");
        MockResultSet goodMRS = goodSybaseXMLRSF.create("Good-ResultSet-ID");
        XMLResultSetFactoryTest.assertNotNull((Object)goodSybaseXMLRSF.getXMLFile());
        this.doTestGoodResultSet(goodSybaseXMLRSF, goodMRS);
        goodSybaseXMLRSF = new XMLResultSetFactory("/com/mockrunner/test/jdbc/xmltestresult.xml");
        goodMRS = goodSybaseXMLRSF.create("Good-ResultSet-ID");
        XMLResultSetFactoryTest.assertNotNull((Object)goodSybaseXMLRSF.getXMLFile());
        this.doTestGoodResultSet(goodSybaseXMLRSF, goodMRS);
    }

    private void doTestGoodResultSet(XMLResultSetFactory goodSybaseXMLRSF, MockResultSet goodMRS) {
        XMLResultSetFactoryTest.assertEquals((String)"Dialects should be equal!", (int)0, (int)goodSybaseXMLRSF.getDialect());
        XMLResultSetFactoryTest.assertEquals((String)"There should be 2 columns!", (int)2, (int)goodMRS.getColumnCount());
        XMLResultSetFactoryTest.assertEquals((String)"There should be 3 rows!", (int)3, (int)goodMRS.getRowCount());
    }

    public void testSquirrelCreate() {
        XMLResultSetFactory goodSquirrelXMLRSF = new XMLResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/squirrelxmltestresult.xml");
        goodSquirrelXMLRSF.setDialect(1);
        MockResultSet goodMRS = goodSquirrelXMLRSF.create("Good-ResultSet-ID");
        XMLResultSetFactoryTest.assertNotNull((Object)goodSquirrelXMLRSF.getXMLFile());
        this.doTestGoodSquirrelResultSet(goodSquirrelXMLRSF, goodMRS);
    }

    private void doTestGoodSquirrelResultSet(XMLResultSetFactory goodSquirrelXMLRSF, MockResultSet goodMRS) {
        XMLResultSetFactoryTest.assertEquals((String)"Dialects should be equal!", (int)1, (int)goodSquirrelXMLRSF.getDialect());
        XMLResultSetFactoryTest.assertEquals((String)"There should be 2 columns!", (int)2, (int)goodMRS.getColumnCount());
        XMLResultSetFactoryTest.assertEquals((String)"There should be 3 rows!", (int)3, (int)goodMRS.getRowCount());
    }

    public void testBadCreate() {
        XMLResultSetFactory badXMLRSF;
        try {
            badXMLRSF = new XMLResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/nonexisting.xml");
            XMLResultSetFactoryTest.assertNull((Object)badXMLRSF.getXMLFile());
            badXMLRSF.create("Bad-ResultSet-ID");
            XMLResultSetFactoryTest.fail();
        }
        catch (RuntimeException exc) {
            // empty catch block
        }
        try {
            badXMLRSF = new XMLResultSetFactory(new File("target/test-classes/com/mockrunner/test/jdbc/nonexisting.xml"));
            XMLResultSetFactoryTest.assertNull((Object)badXMLRSF.getXMLFile());
            badXMLRSF.create("Bad-ResultSet-ID");
            XMLResultSetFactoryTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testGetXMLFile() {
        XMLResultSetFactory factory = new XMLResultSetFactory("target/test-classes/com/mockrunner/test/jdbc/xmltestresult.xml");
        XMLResultSetFactoryTest.assertEquals((Object)new File("target/test-classes/com/mockrunner/test/jdbc/xmltestresult.xml"), (Object)factory.getXMLFile());
        factory = new XMLResultSetFactory(new File("target/test-classes/com/mockrunner/test/jdbc/xmltestresult.xml"));
        XMLResultSetFactoryTest.assertEquals((Object)new File("target/test-classes/com/mockrunner/test/jdbc/xmltestresult.xml"), (Object)factory.getXMLFile());
        factory = new XMLResultSetFactory("badfile");
        try {
            factory.getXMLFile();
            XMLResultSetFactoryTest.fail();
        }
        catch (RuntimeException exc) {
            // empty catch block
        }
        factory = new XMLResultSetFactory(new File("badfile"));
        try {
            factory.getXMLFile();
            XMLResultSetFactoryTest.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

