/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.jdbc;

import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import com.mockrunner.util.common.MethodUtil;
import com.mockrunner.util.common.StreamUtil;
import java.io.InputStream;
import java.io.Reader;

public class ParameterUtil {
    public static Object copyParameter(Object source) {
        if (null == source) {
            return null;
        }
        if (source.getClass().isArray()) {
            return ArrayUtil.copyArray((Object)source);
        }
        if (source instanceof InputStream) {
            return StreamUtil.copyStream((InputStream)((InputStream)source));
        }
        if (source instanceof Reader) {
            return StreamUtil.copyReader((Reader)((Reader)source));
        }
        if (source instanceof Cloneable) {
            try {
                return MethodUtil.invoke((Object)source, (String)"clone");
            }
            catch (Exception exc) {
                return source;
            }
        }
        return source;
    }

    public static boolean compareParameter(Object source, Object target) {
        if (null == source && null == target) {
            return true;
        }
        if (null == source || null == target) {
            return false;
        }
        if (source instanceof InputStream && target instanceof InputStream) {
            return StreamUtil.compareStreams((InputStream)((InputStream)source), (InputStream)((InputStream)target));
        }
        if (source instanceof Reader && target instanceof Reader) {
            return StreamUtil.compareReaders((Reader)((Reader)source), (Reader)((Reader)target));
        }
        if (source instanceof MockResultSet && target instanceof MockResultSet) {
            return ((MockResultSet)source).isEqual((MockResultSet)target);
        }
        if (source.getClass().isArray() && target.getClass().isArray()) {
            return ArrayUtil.areArraysEqual((Object)source, (Object)target);
        }
        return source.equals(target);
    }
}

