/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.mock.jdbc;

import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.jdbc.MockResultSet;
import com.mockrunner.util.common.ArrayUtil;
import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;

public class MockArray
implements java.sql.Array,
Cloneable {
    private String sqlTypeName = "";
    private int baseType = 0;
    private Object array;
    private boolean wasFreeCalled = false;

    public MockArray(Object array) {
        this.array = ArrayUtil.convertToArray((Object)array);
    }

    public void setBaseType(int baseType) {
        this.baseType = baseType;
    }

    public void setBaseTypeName(String sqlTypeName) {
        this.sqlTypeName = sqlTypeName;
    }

    @Override
    public int getBaseType() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.baseType;
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.sqlTypeName;
    }

    @Override
    public Object getArray() throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        return this.array;
    }

    public Object getArray(Map map) throws SQLException {
        return this.getArray();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        return ArrayUtil.truncateArray((Object)this.getArray(), (int)((int)(index - 1L)), (int)count);
    }

    public Object getArray(long index, int count, Map map) throws SQLException {
        return this.getArray(index, count);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.getResultSet(1L, Array.getLength(this.array));
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        if (this.wasFreeCalled) {
            throw new SQLException("free() was called");
        }
        Object[] firstColumn = new Integer[count];
        for (int ii = 0; ii < count; ++ii) {
            firstColumn[ii] = new Integer(ii + 1);
        }
        Object[] secondColumn = ArrayUtil.convertToObjectArray((Object)this.array);
        secondColumn = (Object[])ArrayUtil.truncateArray((Object)secondColumn, (int)((int)(index - 1L)), (int)count);
        MockResultSet resultSet = new MockResultSet(String.valueOf(this.hashCode()));
        resultSet.setResultSetType(1004);
        resultSet.setResultSetConcurrency(1007);
        resultSet.addColumn(firstColumn);
        resultSet.addColumn(secondColumn);
        return resultSet;
    }

    public ResultSet getResultSet(long index, int count, Map map) throws SQLException {
        return this.getResultSet(index, count);
    }

    public ResultSet getResultSet(Map map) throws SQLException {
        return this.getResultSet();
    }

    @Override
    public void free() throws SQLException {
        this.wasFreeCalled = true;
    }

    public boolean wasFreeCalled() {
        return this.wasFreeCalled;
    }

    public boolean equals(Object obj) {
        if (null == obj) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MockArray other = (MockArray)obj;
        if (this.baseType != other.baseType) {
            return false;
        }
        if (null == this.sqlTypeName && null != other.sqlTypeName) {
            return false;
        }
        if (null != this.sqlTypeName && !this.sqlTypeName.equals(other.sqlTypeName)) {
            return false;
        }
        if (this.wasFreeCalled != other.wasFreeCalled()) {
            return false;
        }
        return ArrayUtil.areArraysEqual((Object)this.array, (Object)other.array);
    }

    public int hashCode() {
        int hashCode = ArrayUtil.computeHashCode((Object)this.array);
        hashCode = 31 * hashCode + this.baseType;
        if (null != this.sqlTypeName) {
            hashCode = 31 * hashCode + this.sqlTypeName.hashCode();
        }
        hashCode = 31 * hashCode + (this.wasFreeCalled ? 31 : 62);
        return hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("Array data: [");
        Object[] arrayData = ArrayUtil.convertToObjectArray((Object)this.array);
        for (int ii = 0; ii < arrayData.length; ++ii) {
            buffer.append(arrayData[ii]);
            if (ii >= arrayData.length - 1) continue;
            buffer.append(", ");
        }
        buffer.append("]");
        return buffer.toString();
    }

    public Object clone() {
        try {
            MockArray copy = (MockArray)super.clone();
            copy.array = ArrayUtil.copyArray((Object)this.array);
            return copy;
        }
        catch (CloneNotSupportedException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }
}

