/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.maven.plugin.license;

import com.mycila.maven.plugin.license.AbstractLicenseMojo;
import com.mycila.maven.plugin.license.Callback;
import com.mycila.maven.plugin.license.document.Document;
import com.mycila.maven.plugin.license.header.Header;
import java.io.File;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="check", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true)
public final class LicenseCheckMojo
extends AbstractLicenseMojo {
    public final Collection<File> missingHeaders = new ConcurrentLinkedQueue<File>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Checking licenses...");
        this.missingHeaders.clear();
        this.execute(new Callback(){

            @Override
            public void onHeaderNotFound(Document document, Header header) {
                LicenseCheckMojo.this.warn("Missing header in: %s", document.getFile());
                LicenseCheckMojo.this.missingHeaders.add(document.getFile());
            }

            @Override
            public void onExistingHeader(Document document, Header header) {
                LicenseCheckMojo.this.debug("Header OK in: %s", document.getFile());
            }
        });
        if (!this.missingHeaders.isEmpty()) {
            if (this.failIfMissing) {
                throw new MojoExecutionException("Some files do not have the expected license header");
            }
            this.getLog().warn((CharSequence)"Some files do not have the expected license header");
        }
    }
}

