/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.junit.matchers;

import groovy.lang.Closure;
import java.util.concurrent.Callable;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public final class ExceptionMatchers {
    private ExceptionMatchers() {
    }

    public static Matcher<Throwable> message(final String message) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable item) {
                return message == null && item.getMessage() == null || message != null && message.equals(item.getMessage());
            }

            public void describeTo(Description description) {
                description.appendText("message ").appendValue((Object)message);
            }
        };
    }

    public static Expression expression(final Closure<?> c) {
        return new Expression(){

            @Override
            public void run() throws Throwable {
                c.call();
            }
        };
    }

    public static Expression expression(final Callable<?> c) {
        return new Expression(){

            @Override
            public void run() throws Throwable {
                c.call();
            }
        };
    }

    public static Thrown thrown(Class<? extends Throwable> exceptionClass) {
        return ExceptionMatchers.thrown((Matcher<Throwable>)Matchers.instanceOf(exceptionClass));
    }

    public static Thrown thrown(Matcher<Throwable> typeMatcher) {
        return new Thrown(typeMatcher);
    }

    public static abstract class Expression {
        Throwable exception;

        abstract void run() throws Throwable;

        final void execute() {
            try {
                this.run();
            }
            catch (Throwable e) {
                this.exception = e;
            }
        }

        public String toString() {
            return this.exception == null ? "working expression" : "expression throwing " + this.exception.getClass().getName() + " with message: " + this.exception.getMessage();
        }
    }

    public static final class Thrown
    extends TypeSafeMatcher<Expression> {
        private final Matcher<Throwable> typeMatcher;
        private Matcher<String> message;

        private Thrown(Matcher<Throwable> typeMatcher) {
            this.typeMatcher = typeMatcher;
        }

        public Thrown withMessage(String msg) {
            return this.withMessage((Matcher<String>)Matchers.equalTo((Object)msg));
        }

        public Thrown withMessage(Matcher<String> message) {
            this.message = message;
            return this;
        }

        protected boolean matchesSafely(Expression item) {
            item.execute();
            return item.exception != null && this.typeMatcher.matches((Object)item.exception) && (this.message == null || this.message.matches((Object)item.exception.getMessage()));
        }

        public void describeTo(Description description) {
            description.appendText("expression throwing ").appendDescriptionOf(this.typeMatcher);
            if (this.message != null) {
                description.appendText(" with message ").appendDescriptionOf(this.message);
            }
        }
    }
}

