/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.maven.apt;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractProcessorMojo
extends AbstractMojo {
    protected MavenProject project;
    protected File outputDirectory;
    protected String[] processors;
    protected String processor;
    protected String sourceEncoding;
    protected Map<String, String> options;
    protected Map<String, String> compilerOptions;
    protected boolean showWarnings = false;

    private String buildCompileClasspath() {
        List pathElements = null;
        try {
            pathElements = this.isForTest() ? this.project.getTestClasspathElements() : this.project.getCompileClasspathElements();
        }
        catch (DependencyResolutionRequiredException e) {
            super.getLog().warn((CharSequence)"exception calling getCompileClasspathElements", (Throwable)e);
            return null;
        }
        if (pathElements.isEmpty()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (i = 0; i < pathElements.size() - 1; ++i) {
            result.append((String)pathElements.get(i)).append(File.pathSeparatorChar);
        }
        result.append((String)pathElements.get(i));
        return result.toString();
    }

    private String buildProcessor() {
        if (this.processors != null) {
            StringBuilder result = new StringBuilder();
            for (String processor : this.processors) {
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(processor);
            }
            return result.toString();
        }
        if (this.processor != null) {
            return this.processor;
        }
        String error = "Either processor or processors need to be given";
        this.getLog().error((CharSequence)error);
        throw new IllegalArgumentException(error);
    }

    public void execute() throws MojoExecutionException {
        if (this.outputDirectory != null && !this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        try {
            JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
            StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
            List files = FileUtils.getFiles((File)this.getSourceDirectory(), (String)"**/*.java", null);
            Iterable<? extends JavaFileObject> compilationUnits1 = fileManager.getJavaFileObjectsFromFiles(files);
            String compileClassPath = this.buildCompileClasspath();
            String processor = this.buildProcessor();
            LinkedHashMap<String, String> compilerOpts = new LinkedHashMap<String, String>();
            compilerOpts.put("cp", compileClassPath);
            if (this.sourceEncoding != null) {
                compilerOpts.put("encoding", this.sourceEncoding);
            }
            compilerOpts.put("proc:only", null);
            compilerOpts.put("processor", processor);
            if (this.options != null) {
                for (Map.Entry<String, String> entry : this.options.entrySet()) {
                    compilerOpts.put("A" + entry.getKey() + "=" + entry.getValue(), null);
                }
            }
            if (this.outputDirectory != null) {
                compilerOpts.put("s", this.outputDirectory.getPath());
            }
            if (!this.showWarnings) {
                compilerOpts.put("nowarn", null);
            }
            compilerOpts.put("sourcepath", this.getSourceDirectory().getCanonicalPath());
            if (this.compilerOptions != null) {
                compilerOpts.putAll(this.compilerOptions);
            }
            ArrayList<String> opts = new ArrayList<String>(compilerOpts.size() * 2);
            for (Map.Entry compilerOption : compilerOpts.entrySet()) {
                opts.add("-" + (String)compilerOption.getKey());
                String value = (String)compilerOption.getValue();
                if (!StringUtils.isNotBlank((String)value)) continue;
                opts.add(value);
            }
            JavaCompiler.CompilationTask task = compiler.getTask(null, fileManager, null, opts, null, compilationUnits1);
            task.call();
            if (this.outputDirectory != null) {
                if (this.isForTest()) {
                    this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
                } else {
                    this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
                }
            }
        }
        catch (Exception e1) {
            super.getLog().error((CharSequence)"execute error", (Throwable)e1);
            throw new MojoExecutionException(e1.getMessage());
        }
    }

    protected abstract File getSourceDirectory();

    protected boolean isForTest() {
        return false;
    }
}

