/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.sql;

import com.mysema.query.QueryFlag;
import com.mysema.query.QueryMetadata;
import com.mysema.query.QueryModifiers;
import com.mysema.query.sql.SQLOps;
import com.mysema.query.sql.SQLSerializer;
import com.mysema.query.sql.SQLTemplates;
import com.mysema.query.support.Expressions;
import com.mysema.query.types.Expression;
import com.mysema.query.types.Ops;

public class SQLServerTemplates
extends SQLTemplates {
    private String topTemplate = "top {0s} ";

    public static SQLTemplates.Builder builder() {
        return new SQLTemplates.Builder(){

            @Override
            protected SQLTemplates build(char escape, boolean quote) {
                return new SQLServerTemplates(escape, quote);
            }
        };
    }

    public SQLServerTemplates() {
        this('\\', false);
    }

    public SQLServerTemplates(boolean quote) {
        this('\\', quote);
    }

    public SQLServerTemplates(char escape, boolean quote) {
        super("\"", escape, quote);
        this.setDummyTable("");
        this.setNullsFirst(null);
        this.setNullsLast(null);
        this.setDefaultValues("\ndefault values");
        this.add(Ops.CONCAT, "{0} + {1}", 13);
        this.add(Ops.CHAR_AT, "cast(substring({0},{1}+1,1) as char)");
        this.add(Ops.INDEX_OF, "charindex({1},{0})-1");
        this.add(Ops.INDEX_OF_2ARGS, "charindex({1},{0},{2})-1");
        this.add(Ops.MATCHES, "{0} like {1}");
        this.add(Ops.STRING_IS_EMPTY, "len({0}) = 0");
        this.add(Ops.STRING_LENGTH, "len({0})");
        this.add(Ops.SUBSTR_1ARG, "substring({0},{1}+1,255)");
        this.add(Ops.SUBSTR_2ARGS, "substring({0},{1}+1,{2s}-{1s})", 1);
        this.add(Ops.TRIM, "ltrim(rtrim({0}))");
        this.add(Ops.StringOps.LOCATE, "charindex({0},{1})");
        this.add(Ops.StringOps.LOCATE2, "charindex({0},{1},{2})");
        this.add(SQLOps.NEXTVAL, "{0s}.nextval");
        this.add(Ops.MOD, "{0} % {1}", 10);
        this.add(Ops.MathOps.COSH, "(exp({0}) + exp({0} * -1)) / 2");
        this.add(Ops.MathOps.COTH, "(exp({0} * 2) + 1) / (exp({0} * 2) - 1)");
        this.add(Ops.MathOps.SINH, "(exp({0}) - exp({0} * -1)) / 2");
        this.add(Ops.MathOps.TANH, "(exp({0} * 2) - 1) / (exp({0} * 2) + 1)");
        this.add(Ops.DateTimeOps.YEAR, "datepart(year, {0})");
        this.add(Ops.DateTimeOps.MONTH, "datepart(month, {0})");
        this.add(Ops.DateTimeOps.WEEK, "datepart(week, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_MONTH, "datepart(day, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_WEEK, "datepart(weekday, {0})");
        this.add(Ops.DateTimeOps.DAY_OF_YEAR, "datepart(dayofyear, {0})");
        this.add(Ops.DateTimeOps.HOUR, "datepart(hour, {0})");
        this.add(Ops.DateTimeOps.MINUTE, "datepart(minute, {0})");
        this.add(Ops.DateTimeOps.SECOND, "datepart(second, {0})");
        this.add(Ops.DateTimeOps.MILLISECOND, "datepart(millisecond, {0})");
        this.add(Ops.DateTimeOps.YEAR_MONTH, "(datepart(year, {0}) * 100 + datepart(month, {0}))");
        this.add(Ops.DateTimeOps.YEAR_WEEK, "(datepart(year, {0}) * 100 + datepart(isowk, {0}))");
        this.add(Ops.DateTimeOps.ADD_YEARS, "dateadd(year, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_MONTHS, "dateadd(month, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_WEEKS, "dateadd(week, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_DAYS, "dateadd(day, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_HOURS, "dateadd(hour, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_MINUTES, "dateadd(minute, {1s}, {0})");
        this.add(Ops.DateTimeOps.ADD_SECONDS, "dateadd(second, {1s}, {0})");
        this.add(Ops.DateTimeOps.DIFF_YEARS, "datediff(year,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_MONTHS, "datediff(month,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_WEEKS, "datediff(week,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_DAYS, "datediff(day,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_HOURS, "datediff(hour,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_MINUTES, "datediff(minute,{0},{1})");
        this.add(Ops.DateTimeOps.DIFF_SECONDS, "datediff(second,{0},{1})");
        this.add(Ops.DateTimeOps.DATE, "cast({0} as date)");
        this.add(Ops.DateTimeOps.CURRENT_DATE, "cast(getdate() as date)");
        this.addTypeNameToCode("decimal", 8, true);
        this.addTypeNameToCode("tinyint identity", -6);
        this.addTypeNameToCode("bigint identity", -5);
        this.addTypeNameToCode("timestamp", -2);
        this.addTypeNameToCode("nchar", 1);
        this.addTypeNameToCode("uniqueidentifier", 1);
        this.addTypeNameToCode("numeric() identity", 2);
        this.addTypeNameToCode("money", 3);
        this.addTypeNameToCode("smallmoney", 3);
        this.addTypeNameToCode("decimal() identity", 3);
        this.addTypeNameToCode("int", 4);
        this.addTypeNameToCode("int identity", 4);
        this.addTypeNameToCode("smallint identity", 5);
        this.addTypeNameToCode("float", 8);
        this.addTypeNameToCode("nvarchar", 12);
        this.addTypeNameToCode("date", 12);
        this.addTypeNameToCode("time", 12);
        this.addTypeNameToCode("datetime2", 12);
        this.addTypeNameToCode("datetimeoffset", 12);
        this.addTypeNameToCode("sysname", 12);
        this.addTypeNameToCode("sql_variant", 12);
        this.addTypeNameToCode("datetime", 93);
        this.addTypeNameToCode("smalldatetime", 93);
        this.addTypeNameToCode("image", 2004);
        this.addTypeNameToCode("ntext", 2005);
        this.addTypeNameToCode("xml", 2005);
        this.addTypeNameToCode("text", 2005);
    }

    @Override
    public String serialize(String literal, int jdbcType) {
        if (jdbcType == 93) {
            return "{ts '" + literal + "'}";
        }
        if (jdbcType == 91) {
            return "{d '" + literal + "'}";
        }
        if (jdbcType == 92) {
            return "{t '" + literal + "'}";
        }
        return super.serialize(literal, jdbcType);
    }

    protected String escapeForLike(String str) {
        StringBuilder rv = new StringBuilder(str.length() + 3);
        for (char ch : str.toCharArray()) {
            if (ch == this.getEscapeChar() || ch == '%' || ch == '_' || ch == '[') {
                rv.append(this.getEscapeChar());
            }
            rv.append(ch);
        }
        return rv.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void serialize(QueryMetadata metadata, boolean forCountRow, SQLSerializer context) {
        if (!forCountRow && metadata.getModifiers().isRestricting() && !metadata.getJoins().isEmpty()) {
            QueryModifiers mod = metadata.getModifiers();
            if (mod.getOffset() != null) throw new IllegalStateException("offset not supported");
            metadata = metadata.clone();
            metadata.addFlag(new QueryFlag(QueryFlag.Position.AFTER_SELECT, (Expression)Expressions.template(Integer.class, (String)this.topTemplate, (Object[])new Object[]{mod.getLimit()})));
            context.serializeForQuery(metadata, forCountRow);
        } else {
            context.serializeForQuery(metadata, forCountRow);
        }
        if (metadata.getFlags().isEmpty()) return;
        context.serialize(QueryFlag.Position.END, metadata.getFlags());
    }

    @Override
    protected void serializeModifiers(QueryMetadata metadata, SQLSerializer context) {
    }
}

