/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.common.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;

public class JsonUtil {
    private static ObjectMapper objectMapper = new ObjectMapper();

    public static <T> String toJson(T object) {
        if (object == null) {
            throw new IllegalArgumentException("Object is null");
        }
        try {
            return objectMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new IllegalArgumentException("Json is null or empty");
        }
        try {
            return (T)objectMapper.readValue(json, clazz);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> typeReference) {
        if (StringUtils.isEmpty((CharSequence)json)) {
            throw new IllegalArgumentException("Json is null or empty");
        }
        try {
            return (T)objectMapper.readValue(json, typeReference);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public static class NullKeySerializer
    extends StdSerializer<Object> {
        private static final long serialVersionUID = -9176767187240330396L;

        public NullKeySerializer() {
            this(null);
        }

        public NullKeySerializer(Class<Object> object) {
            super(object);
        }

        public void serialize(Object value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeFieldName("");
        }
    }
}

