/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.admincenter.endpoint;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.event.PluginEventWapper;
import com.nepxion.discovery.plugin.framework.event.VersionClearedEvent;
import com.nepxion.discovery.plugin.framework.event.VersionUpdatedEvent;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.web.annotation.RestControllerEndpoint;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.jmx.export.annotation.ManagedOperation;
import org.springframework.jmx.export.annotation.ManagedResource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(path={"/version"})
@Api(tags={"\u7248\u672c\u63a5\u53e3"})
@RestControllerEndpoint(id="version")
@ManagedResource(description="Version Endpoint")
public class VersionEndpoint {
    @Autowired
    private PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private PluginEventWapper pluginEventWapper;

    @RequestMapping(path={"/update-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u66f4\u65b0\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    @ManagedOperation
    public ResponseEntity<?> updateAsync(@RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a[dynamicVersion]\u6216\u8005[dynamicVersion];[localVersion]", required=true) String version) {
        return this.update(version, true);
    }

    @RequestMapping(path={"/update-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u66f4\u65b0\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u66f4\u65b0\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    @ManagedOperation
    public ResponseEntity<?> updateSync(@RequestBody @ApiParam(value="\u7248\u672c\u53f7\uff0c\u683c\u5f0f\u4e3a[dynamicVersion]\u6216\u8005[dynamicVersion];[localVersion]", required=true) String version) {
        return this.update(version, false);
    }

    @RequestMapping(path={"/clear-async"}, method={RequestMethod.POST})
    @ApiOperation(value="\u5f02\u6b65\u6e05\u9664\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    @ManagedOperation
    public ResponseEntity<?> clearAsync(@RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.clear(version, true);
    }

    @RequestMapping(path={"/clear-sync"}, method={RequestMethod.POST})
    @ApiOperation(value="\u540c\u6b65\u6e05\u9664\u670d\u52a1\u7684\u52a8\u6001\u7248\u672c", notes="\u6839\u636e\u6307\u5b9a\u7684localVersion\u6e05\u9664\u670d\u52a1\u7684dynamicVersion\u3002\u5982\u679c\u8f93\u5165\u7684localVersion\u4e0d\u5339\u914d\u670d\u52a1\u7684localVersion\uff0c\u5219\u5ffd\u7565\uff1b\u5982\u679c\u5982\u679c\u8f93\u5165\u7684localVersion\u4e3a\u7a7a\uff0c\u5219\u76f4\u63a5\u6e05\u9664\u670d\u52a1\u7684dynamicVersion", response=ResponseEntity.class, httpMethod="POST")
    @ResponseBody
    @ManagedOperation
    public ResponseEntity<?> clearSync(@RequestBody(required=false) @ApiParam(value="\u7248\u672c\u53f7\uff0c\u6307localVersion\uff0c\u53ef\u4ee5\u4e3a\u7a7a") String version) {
        return this.clear(version, false);
    }

    @RequestMapping(path={"/view"}, method={RequestMethod.GET})
    @ApiOperation(value="\u67e5\u770b\u670d\u52a1\u7684\u672c\u5730\u7248\u672c\u548c\u52a8\u6001\u7248\u672c", notes="", response=ResponseEntity.class, httpMethod="GET")
    @ResponseBody
    @ManagedOperation
    public ResponseEntity<List<String>> view() {
        return this.view(false);
    }

    private ResponseEntity<?> update(String version, boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Discovery control is disabled");
        }
        if (StringUtils.isEmpty((CharSequence)version)) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Version can't be null or empty");
        }
        String dynamicVersion = null;
        String localVersion = null;
        String[] versionArray = StringUtils.split((String)version, (String)";");
        if (versionArray.length == 2) {
            dynamicVersion = versionArray[0];
            localVersion = versionArray[1];
        } else if (versionArray.length == 1) {
            dynamicVersion = versionArray[0];
        } else {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Invalid version format, it must be '[dynamicVersion]' or '[dynamicVersion];[localVersion]'");
        }
        this.pluginEventWapper.fireVersionUpdated(new VersionUpdatedEvent(dynamicVersion, localVersion), async);
        return ResponseEntity.ok().body((Object)"OK");
    }

    private ResponseEntity<?> clear(String version, boolean async) {
        Boolean discoveryControlEnabled = this.pluginContextAware.isDiscoveryControlEnabled();
        if (!discoveryControlEnabled.booleanValue()) {
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)"Discovery control is disabled");
        }
        if (StringUtils.isNotEmpty((CharSequence)version) && StringUtils.equals((CharSequence)version.trim(), (CharSequence)"{}")) {
            version = null;
        }
        this.pluginEventWapper.fireVersionCleared(new VersionClearedEvent(version), async);
        return ResponseEntity.ok().body((Object)"OK");
    }

    private ResponseEntity<List<String>> view(boolean async) {
        ArrayList<String> versionList = new ArrayList<String>(2);
        String localVersion = this.pluginAdapter.getLocalVersion();
        String dynamicVersion = this.pluginAdapter.getDynamicVersion();
        versionList.add(StringUtils.isNotEmpty((CharSequence)localVersion) ? localVersion : "");
        versionList.add(StringUtils.isNotEmpty((CharSequence)dynamicVersion) ? dynamicVersion : "");
        return ResponseEntity.ok().body(versionList);
    }
}

