/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.redis.adapter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.redis.operation.RedisOperation;
import com.nepxion.discovery.common.redis.operation.RedisSubscribeCallback;
import com.nepxion.discovery.plugin.configcenter.adapter.ConfigAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.nepxion.discovery.plugin.framework.event.RuleClearedEvent;
import com.nepxion.discovery.plugin.framework.event.RuleUpdatedEvent;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

public class RedisConfigAdapter
extends ConfigAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConfigAdapter.class);
    @Autowired
    protected PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;
    @Autowired
    private RedisOperation redisOperation;
    @Autowired
    private RedisMessageListenerContainer redisMessageListenerContainer;
    @Autowired
    private MessageListenerAdapter partialMessageListenerAdapter;
    @Autowired
    private MessageListenerAdapter globalMessageListenerAdapter;

    public String getConfig() throws Exception {
        String config = this.getConfig(false);
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            return config;
        }
        LOG.info("No {} config is retrieved from {} server", (Object)this.getConfigScope(false), (Object)this.getConfigType());
        config = this.getConfig(true);
        if (StringUtils.isNotEmpty((CharSequence)config)) {
            return config;
        }
        LOG.info("No {} config is retrieved from {} server", (Object)this.getConfigScope(true), (Object)this.getConfigType());
        return null;
    }

    private String getConfig(boolean globalConfig) throws Exception {
        String groupKey = this.pluginContextAware.getGroupKey();
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Get {} config from {} server, {}={}, serviceId={}", new Object[]{this.getConfigScope(globalConfig), this.getConfigType(), groupKey, group, serviceId});
        return this.redisOperation.getConfig(group, globalConfig ? group : serviceId);
    }

    public void subscribePartialConfig(String config) {
        this.subscribeConfig(config, false);
    }

    public void subscribeGlobalConfig(String config) {
        this.subscribeConfig(config, true);
    }

    private void subscribeConfig(String config, final boolean globalConfig) {
        final String groupKey = this.pluginContextAware.getGroupKey();
        final String group = this.pluginAdapter.getGroup();
        final String serviceId = this.pluginAdapter.getServiceId();
        try {
            this.redisOperation.subscribeConfig(config, new RedisSubscribeCallback(){

                public void callback(String config) {
                    if (StringUtils.isNotEmpty((CharSequence)config)) {
                        LOG.info("Get {} config updated event from {} server, {}={}, serviceId={}", new Object[]{RedisConfigAdapter.this.getConfigScope(globalConfig), RedisConfigAdapter.this.getConfigType(), groupKey, group, serviceId});
                        RuleEntity ruleEntity = RedisConfigAdapter.this.pluginAdapter.getRule();
                        String rule = null;
                        if (ruleEntity != null) {
                            rule = ruleEntity.getContent();
                        }
                        if (!StringUtils.equals((CharSequence)rule, (CharSequence)config)) {
                            RedisConfigAdapter.this.fireRuleUpdated(new RuleUpdatedEvent(config), true);
                        } else {
                            LOG.info("Retrieved {} config from {} server is same as current config, ignore to update, {}={}, serviceId={}", new Object[]{RedisConfigAdapter.this.getConfigScope(globalConfig), RedisConfigAdapter.this.getConfigType(), groupKey, group, serviceId});
                        }
                    } else {
                        LOG.info("Get {} config cleared event from {} server, {}={}, serviceId={}", new Object[]{RedisConfigAdapter.this.getConfigScope(globalConfig), RedisConfigAdapter.this.getConfigType(), groupKey, group, serviceId});
                        RedisConfigAdapter.this.fireRuleCleared(new RuleClearedEvent(), true);
                    }
                }
            });
        }
        catch (Exception e) {
            LOG.error("Subscribe {} config from {} server failed, {}={}, serviceId={}", new Object[]{this.getConfigScope(globalConfig), this.getConfigType(), groupKey, group, serviceId, e});
        }
    }

    public void close() {
        this.unsubscribeConfig(this.partialMessageListenerAdapter, false);
        this.unsubscribeConfig(this.globalMessageListenerAdapter, true);
    }

    private void unsubscribeConfig(MessageListenerAdapter messageListenerAdapter, boolean globalConfig) {
        String groupKey = this.pluginContextAware.getGroupKey();
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Unsubscribe {} config from {} server, {}={}, serviceId={}", new Object[]{this.getConfigScope(globalConfig), this.getConfigType(), groupKey, group, serviceId});
        this.redisMessageListenerContainer.removeMessageListener((MessageListener)messageListenerAdapter, (Topic)new PatternTopic(group + "-" + (globalConfig ? group : serviceId)));
    }

    public String getConfigScope(boolean globalConfig) {
        return globalConfig ? "global" : "partial";
    }

    public String getConfigType() {
        return "Redis";
    }
}

