/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.configcenter.redis.configuration;

import com.nepxion.discovery.plugin.configcenter.adapter.ConfigAdapter;
import com.nepxion.discovery.plugin.configcenter.redis.adapter.RedisConfigAdapter;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.Topic;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@Configuration
public class RedisConfigAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConfigAutoConfiguration.class);
    @Autowired
    private RedisConnectionFactory redisConnectionFactory;
    @Autowired
    protected PluginContextAware pluginContextAware;
    @Autowired
    private PluginAdapter pluginAdapter;

    @Bean
    public RedisMessageListenerContainer redisMessageListenerContainer(MessageListenerAdapter partialMessageListenerAdapter, MessageListenerAdapter globalMessageListenerAdapter) {
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        RedisMessageListenerContainer redisMessageListenerContainer = new RedisMessageListenerContainer();
        redisMessageListenerContainer.setConnectionFactory(this.redisConnectionFactory);
        redisMessageListenerContainer.addMessageListener((MessageListener)partialMessageListenerAdapter, (Topic)new PatternTopic(group + "-" + serviceId));
        redisMessageListenerContainer.addMessageListener((MessageListener)globalMessageListenerAdapter, (Topic)new PatternTopic(group + "-" + group));
        return redisMessageListenerContainer;
    }

    @Bean
    public MessageListenerAdapter partialMessageListenerAdapter(RedisConfigAdapter configAdapter) {
        String groupKey = this.pluginContextAware.getGroupKey();
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Subscribe {} config from {} server, {}={}, serviceId={}", new Object[]{configAdapter.getConfigScope(false), configAdapter.getConfigType(), groupKey, group, serviceId});
        return new MessageListenerAdapter((Object)configAdapter, "subscribePartialConfig");
    }

    @Bean
    public MessageListenerAdapter globalMessageListenerAdapter(RedisConfigAdapter configAdapter) {
        String groupKey = this.pluginContextAware.getGroupKey();
        String group = this.pluginAdapter.getGroup();
        String serviceId = this.pluginAdapter.getServiceId();
        LOG.info("Subscribe {} config from {} server, {}={}, serviceId={}", new Object[]{configAdapter.getConfigScope(true), configAdapter.getConfigType(), groupKey, group, serviceId});
        return new MessageListenerAdapter((Object)configAdapter, "subscribeGlobalConfig");
    }

    @Bean
    public ConfigAdapter configAdapter() {
        return new RedisConfigAdapter();
    }

    static {
        String logoShown = System.getProperty("nepxion.logo.shown", "true");
        if (Boolean.valueOf(logoShown).booleanValue()) {
            System.out.println("");
            System.out.println("\u2554\u2550\u2550\u2550\u2557    \u2554\u2557");
            System.out.println("\u2551\u2554\u2550\u2557\u2551    \u2551\u2551");
            System.out.println("\u2551\u255a\u2550\u255d\u2560\u2550\u2550\u2566\u2550\u255d\u2560\u2566\u2550\u2550\u2557");
            System.out.println("\u2551\u2554\u2557\u2554\u2563\u2551\u2550\u2563\u2554\u2557\u2560\u2563\u2550\u2550\u2563");
            System.out.println("\u2551\u2551\u2551\u255a\u2563\u2551\u2550\u2563\u255a\u255d\u2551\u2560\u2550\u2550\u2551");
            System.out.println("\u255a\u255d\u255a\u2550\u2569\u2550\u2550\u2569\u2550\u2550\u2569\u2569\u2550\u2550\u255d");
            System.out.println("Redis Config");
            System.out.println("");
        }
    }
}

