/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.adapter;

import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.cache.PluginCache;
import com.nepxion.discovery.plugin.framework.cache.RuleCache;
import com.nepxion.discovery.plugin.framework.context.PluginContextAware;
import com.netflix.loadbalancer.Server;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.serviceregistry.Registration;

public abstract class AbstractPluginAdapter
implements PluginAdapter {
    @Autowired
    protected Registration registration;
    @Autowired
    protected PluginContextAware pluginContextAware;
    @Autowired
    protected PluginCache pluginCache;
    @Autowired
    protected RuleCache ruleCache;

    @Override
    public String getGroup() {
        String groupKey = this.pluginContextAware.getGroupKey();
        String group = this.getGroup(groupKey);
        if (StringUtils.isEmpty((CharSequence)group)) {
            throw new DiscoveryException("The value is null or empty for metadata key=" + groupKey + ", please check your configuration");
        }
        return group;
    }

    protected String getGroup(String groupKey) {
        return this.getMetadata().get(groupKey);
    }

    @Override
    public String getServiceId() {
        return this.registration.getServiceId().toLowerCase();
    }

    @Override
    public String getHost() {
        return this.registration.getHost();
    }

    @Override
    public int getPort() {
        return this.registration.getPort();
    }

    @Override
    public String getContextPath() {
        return this.getMetadata().get("spring.application.context-path");
    }

    @Override
    public Map<String, String> getMetadata() {
        return this.registration.getMetadata();
    }

    @Override
    public String getVersion() {
        String dynamicVersion = this.getDynamicVersion();
        if (StringUtils.isNotEmpty((CharSequence)dynamicVersion)) {
            return dynamicVersion;
        }
        return this.getLocalVersion();
    }

    @Override
    public String getLocalVersion() {
        return this.getMetadata().get("version");
    }

    @Override
    public String getDynamicVersion() {
        return this.pluginCache.get("dynamicVersion");
    }

    @Override
    public void setDynamicVersion(String version) {
        this.pluginCache.put("dynamicVersion", version);
    }

    @Override
    public void clearDynamicVersion() {
        this.pluginCache.clear("dynamicVersion");
    }

    @Override
    public RuleEntity getRule() {
        RuleEntity dynamicRuleEntity = this.getDynamicRule();
        if (dynamicRuleEntity != null) {
            return dynamicRuleEntity;
        }
        return this.getLocalRule();
    }

    @Override
    public RuleEntity getLocalRule() {
        return this.ruleCache.get("rule");
    }

    @Override
    public void setLocalRule(RuleEntity ruleEntity) {
        this.ruleCache.put("rule", ruleEntity);
    }

    @Override
    public RuleEntity getDynamicRule() {
        return this.ruleCache.get("dynamicRule");
    }

    @Override
    public void setDynamicRule(RuleEntity ruleEntity) {
        this.ruleCache.put("dynamicRule", ruleEntity);
    }

    @Override
    public void clearDynamicRule() {
        this.ruleCache.clear("dynamicRule");
    }

    @Override
    public String getRegion() {
        return this.getMetadata().get("region");
    }

    @Override
    public String getServerVersion(Server server) {
        return this.getServerMetadata(server).get("version");
    }

    @Override
    public String getServerRegion(Server server) {
        return this.getServerMetadata(server).get("region");
    }
}

