/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.context;

import com.nepxion.discovery.plugin.framework.decorator.DiscoveryClientDecorator;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class PluginApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(final ConfigurableApplicationContext applicationContext) {
        applicationContext.getBeanFactory().addBeanPostProcessor((BeanPostProcessor)new InstantiationAwareBeanPostProcessorAdapter(){

            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof DiscoveryClient) {
                    DiscoveryClient discoveryClient = (DiscoveryClient)bean;
                    return new DiscoveryClientDecorator(discoveryClient, applicationContext);
                }
                return PluginApplicationContextInitializer.this.afterInitialization(applicationContext, bean, beanName);
            }
        });
    }

    protected abstract Object afterInitialization(ConfigurableApplicationContext var1, Object var2, String var3) throws BeansException;
}

