/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.decorator;

import com.nepxion.discovery.common.entity.WeightFilterEntity;
import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.framework.loadbalance.WeightRandomLoadBalance;
import com.netflix.loadbalancer.Server;
import com.netflix.loadbalancer.ZoneAvoidanceRule;
import java.util.List;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class ZoneAvoidanceRuleDecorator
extends ZoneAvoidanceRule {
    @Autowired
    private PluginAdapter pluginAdapter;
    private WeightRandomLoadBalance weightRandomLoadBalance;

    @PostConstruct
    private void initialize() {
        this.weightRandomLoadBalance = new WeightRandomLoadBalance();
        this.weightRandomLoadBalance.setPluginAdapter(this.pluginAdapter);
    }

    public Server choose(Object key) {
        WeightFilterEntity weightFilterEntity = this.weightRandomLoadBalance.getWeightFilterEntity();
        if (weightFilterEntity == null) {
            return super.choose(key);
        }
        if (!weightFilterEntity.hasWeight()) {
            return super.choose(key);
        }
        List eligibleServers = this.getPredicate().getEligibleServers(this.getLoadBalancer().getAllServers(), key);
        try {
            return this.weightRandomLoadBalance.choose(eligibleServers, weightFilterEntity);
        }
        catch (Exception e) {
            return super.choose(key);
        }
    }
}

