/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.loadbalance;

import com.nepxion.discovery.common.entity.DiscoveryEntity;
import com.nepxion.discovery.common.entity.FilterType;
import com.nepxion.discovery.common.entity.HostFilterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.plugin.framework.listener.loadbalance.AbstractLoadBalanceListener;
import com.netflix.loadbalancer.Server;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;

public class HostFilterLoadBalanceListener
extends AbstractLoadBalanceListener {
    @Override
    public void onGetServers(String serviceId, List<? extends Server> servers) {
        this.applyHostFilter(serviceId, servers);
    }

    private void applyHostFilter(String providerServiceId, List<? extends Server> servers) {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        DiscoveryEntity discoveryEntity = ruleEntity.getDiscoveryEntity();
        if (discoveryEntity == null) {
            return;
        }
        HostFilterEntity hostFilterEntity = discoveryEntity.getHostFilterEntity();
        if (hostFilterEntity == null) {
            return;
        }
        FilterType filterType = hostFilterEntity.getFilterType();
        List globalFilterValueList = hostFilterEntity.getFilterValueList();
        Map filterMap = hostFilterEntity.getFilterMap();
        List filterValueList = (List)filterMap.get(providerServiceId);
        if (CollectionUtils.isEmpty((Collection)globalFilterValueList) && CollectionUtils.isEmpty((Collection)filterValueList)) {
            return;
        }
        ArrayList<String> allFilterValueList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)globalFilterValueList)) {
            allFilterValueList.addAll(globalFilterValueList);
        }
        if (CollectionUtils.isNotEmpty((Collection)filterValueList)) {
            allFilterValueList.addAll(filterValueList);
        }
        Iterator<? extends Server> iterator = servers.iterator();
        while (iterator.hasNext()) {
            Server server = iterator.next();
            String host = server.getHost();
            switch (filterType) {
                case BLACKLIST: {
                    if (!this.validateBlacklist(allFilterValueList, host)) break;
                    iterator.remove();
                    break;
                }
                case WHITELIST: {
                    if (!this.validateWhitelist(allFilterValueList, host)) break;
                    iterator.remove();
                }
            }
        }
    }

    private boolean validateBlacklist(List<String> allFilterValueList, String host) {
        for (String filterValue : allFilterValueList) {
            if (!host.startsWith(filterValue)) continue;
            return true;
        }
        return false;
    }

    private boolean validateWhitelist(List<String> allFilterValueList, String host) {
        boolean matched = true;
        for (String filterValue : allFilterValueList) {
            if (!host.startsWith(filterValue)) continue;
            matched = false;
            break;
        }
        return matched;
    }

    @Override
    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

