/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.framework.listener.register;

import com.nepxion.discovery.common.entity.FilterType;
import com.nepxion.discovery.common.entity.HostFilterEntity;
import com.nepxion.discovery.common.entity.RegisterEntity;
import com.nepxion.discovery.common.entity.RuleEntity;
import com.nepxion.discovery.common.exception.DiscoveryException;
import com.nepxion.discovery.plugin.framework.event.RegisterFailureEvent;
import com.nepxion.discovery.plugin.framework.listener.register.AbstractRegisterListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.cloud.client.serviceregistry.Registration;

public class HostFilterRegisterListener
extends AbstractRegisterListener {
    @Override
    public void onRegister(Registration registration) {
        String serviceId = registration.getServiceId().toLowerCase();
        String host = registration.getHost();
        int port = registration.getPort();
        this.applyHostFilter(serviceId, host, port);
    }

    private void applyHostFilter(String serviceId, String host, int port) {
        RuleEntity ruleEntity = this.pluginAdapter.getRule();
        if (ruleEntity == null) {
            return;
        }
        RegisterEntity registerEntity = ruleEntity.getRegisterEntity();
        if (registerEntity == null) {
            return;
        }
        HostFilterEntity hostFilterEntity = registerEntity.getHostFilterEntity();
        if (hostFilterEntity == null) {
            return;
        }
        FilterType filterType = hostFilterEntity.getFilterType();
        List globalFilterValueList = hostFilterEntity.getFilterValueList();
        Map filterMap = hostFilterEntity.getFilterMap();
        List filterValueList = (List)filterMap.get(serviceId);
        if (CollectionUtils.isEmpty((Collection)globalFilterValueList) && CollectionUtils.isEmpty((Collection)filterValueList)) {
            return;
        }
        ArrayList<String> allFilterValueList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty((Collection)globalFilterValueList)) {
            allFilterValueList.addAll(globalFilterValueList);
        }
        if (CollectionUtils.isNotEmpty((Collection)filterValueList)) {
            allFilterValueList.addAll(filterValueList);
        }
        switch (filterType) {
            case BLACKLIST: {
                this.validateBlacklist(filterType, allFilterValueList, serviceId, host, port);
                break;
            }
            case WHITELIST: {
                this.validateWhitelist(filterType, allFilterValueList, serviceId, host, port);
            }
        }
    }

    private void validateBlacklist(FilterType filterType, List<String> allFilterValueList, String serviceId, String host, int port) {
        for (String filterValue : allFilterValueList) {
            if (!host.startsWith(filterValue)) continue;
            this.onRegisterFailure(filterType, allFilterValueList, serviceId, host, port);
        }
    }

    private void validateWhitelist(FilterType filterType, List<String> allFilterValueList, String serviceId, String host, int port) {
        boolean matched = true;
        for (String filterValue : allFilterValueList) {
            if (!host.startsWith(filterValue)) continue;
            matched = false;
            break;
        }
        if (matched) {
            this.onRegisterFailure(filterType, allFilterValueList, serviceId, host, port);
        }
    }

    private void onRegisterFailure(FilterType filterType, List<String> allFilterValueList, String serviceId, String host, int port) {
        String description = serviceId + " for " + host + ":" + port + " isn't allowed to register to Register server, not match host " + filterType + "=" + allFilterValueList;
        this.pluginEventWapper.fireRegisterFailure(new RegisterFailureEvent(filterType.toString(), description, serviceId, host, port));
        throw new DiscoveryException(description);
    }

    @Override
    public void onDeregister(Registration registration) {
    }

    @Override
    public void onSetStatus(Registration registration, String status) {
    }

    @Override
    public void onClose() {
    }

    @Override
    public int getOrder() {
        return Integer.MAX_VALUE;
    }
}

