/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.zuul.adapter;

import com.nepxion.discovery.plugin.strategy.adapter.AbstractDiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.zuul.context.ZuulStrategyContextHolder;
import com.netflix.loadbalancer.Server;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DefaultDiscoveryEnabledAdapter
extends AbstractDiscoveryEnabledAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDiscoveryEnabledAdapter.class);
    @Autowired
    private ZuulStrategyContextHolder zuulStrategyContextHolder;

    protected String getVersionValue(Server server) {
        HttpServletRequest request = this.zuulStrategyContextHolder.getRequest();
        if (request == null) {
            String serviceId = server.getMetaInfo().getAppName().toLowerCase();
            LOG.warn("The HttpServletRequest object is null, ignore to do version filter for service={}...", (Object)serviceId);
            return null;
        }
        return request.getHeader("version");
    }

    protected String getRegionValue(Server server) {
        HttpServletRequest request = this.zuulStrategyContextHolder.getRequest();
        if (request == null) {
            String serviceId = server.getMetaInfo().getAppName().toLowerCase();
            LOG.warn("The HttpServletRequest object is null, ignore to do region filter for service={}...", (Object)serviceId);
            return null;
        }
        return request.getHeader("region");
    }

    protected String getAddressValue(Server server) {
        HttpServletRequest request = this.zuulStrategyContextHolder.getRequest();
        if (request == null) {
            String serviceId = server.getMetaInfo().getAppName().toLowerCase();
            LOG.warn("The HttpServletRequest object is null, ignore to do region filter for service={}...", (Object)serviceId);
            return null;
        }
        return request.getHeader("address");
    }
}

