/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.util;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.InstanceProfileCredentialsProvider;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.DisassociateAddressRequest;
import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.shared.Application;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.servo.monitor.Monitors;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EIPManager {
    private static final int HEARTBEAT_RETRY_INTERVAL_MS = 300;
    private static final int NO_HEARTBEAT_RETRIES = 3;
    private static final String US_EAST_1 = "us-east-1";
    private static final Logger logger = LoggerFactory.getLogger(EIPManager.class);
    private EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final EIPManager s_instance = new EIPManager();

    public static EIPManager getInstance() {
        return s_instance;
    }

    private EIPManager() {
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
    }

    public void bindToEIP() {
        String myPublicIP;
        String myZone;
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myInstanceId = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.instanceId);
        String selectedEIP = this.getCandidateEIP(myInstanceId, myZone = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.availabilityZone), myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4));
        if (selectedEIP == null) {
            logger.debug("No need to bind to EIP");
            return;
        }
        try {
            AmazonEC2 ec2Service = this.getEC2Service();
            AssociateAddressRequest request = new AssociateAddressRequest(myInstanceId, selectedEIP);
            ec2Service.associateAddress(request);
            logger.info("\n\n\nAssociated " + myInstanceId + " running in zone: " + myZone + " to elastic IP: " + selectedEIP);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to bind elastic IP: " + selectedEIP + " to " + myInstanceId, t);
        }
    }

    public void unbindEIP() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        String myPublicIP = null;
        if (myInfo != null && myInfo.getDataCenterInfo().getName() == DataCenterInfo.Name.Amazon) {
            myPublicIP = ((AmazonInfo)myInfo.getDataCenterInfo()).get(AmazonInfo.MetaDataKey.publicIpv4);
            try {
                AmazonEC2 ec2Service = this.getEC2Service();
                DisassociateAddressRequest dissociateRequest = new DisassociateAddressRequest().withPublicIp(myPublicIP);
                ec2Service.disassociateAddress(dissociateRequest);
                logger.info("Dissociated the EIP {} from this instance", (Object)myPublicIP);
            }
            catch (Throwable e) {
                throw new RuntimeException("Cannot dissociate address" + myPublicIP + "from this instance", e);
            }
        }
    }

    public String getCandidateEIP(String myInstanceId, String myZone, String myPublicIP) {
        Collection<String> eipCandidates;
        if (myZone == null) {
            myZone = "us-east-1d";
            myPublicIP = "us-east-1d";
        }
        Collection<String> collection = eipCandidates = DiscoveryManager.getInstance().getEurekaClientConfig().shouldUseDnsForFetchingServiceUrls() ? this.getEIPsForZoneFromDNS(myZone) : this.getEIPsForZoneFromConfig(myZone);
        if (eipCandidates == null || eipCandidates.size() == 0) {
            throw new RuntimeException("Could not get any elastic ips from the EIP pool for zone :" + myZone);
        }
        ArrayList<String> availableEIPList = new ArrayList<String>();
        for (String eip : eipCandidates) {
            String eipTrimmed = eip.trim();
            if (myPublicIP.equals(eipTrimmed)) {
                logger.debug("Already bound to an EIP : " + eip);
                return null;
            }
            availableEIPList.add(eipTrimmed);
        }
        InstanceInfo instanceInfo = ApplicationInfoManager.getInstance().getInfo();
        Application app = DiscoveryManager.getInstance().getDiscoveryClient().getApplication(instanceInfo.getAppName());
        ArrayList<String> unreachableEips = new ArrayList<String>();
        if (app != null) {
            for (InstanceInfo i : app.getInstances()) {
                if (!PeerAwareInstanceRegistry.getInstance().isRegisterable(i)) continue;
                AmazonInfo amazonInfo = (AmazonInfo)i.getDataCenterInfo();
                String publicIP = amazonInfo.get(AmazonInfo.MetaDataKey.publicIpv4);
                String instanceId = amazonInfo.get(AmazonInfo.MetaDataKey.instanceId);
                if (instanceId.equals(myInstanceId) && availableEIPList.contains(publicIP)) {
                    logger.warn("The instance id {} is already bound to EIP {}. Hence returning that.", (Object)myInstanceId, (Object)publicIP);
                    return publicIP;
                }
                logger.info("The list of available EIPS in the priority order :" + availableEIPList);
                Iterator it = availableEIPList.iterator();
                while (it.hasNext()) {
                    String eip = (String)it.next();
                    if (!eip.trim().equals(publicIP)) continue;
                    String instanceHostName = i.getHostName();
                    PeerEurekaNode replicaNode = this.getPeerEurekaNode(instanceHostName);
                    if (replicaNode == null) {
                        logger.warn("Cannot get peer eureka node. Is this even a peer? :" + instanceHostName);
                        continue;
                    }
                    boolean isInstanceReachable = false;
                    for (int ctr = 0; ctr < 3; ++ctr) {
                        try {
                            replicaNode.heartbeat(instanceInfo.getAppName(), instanceInfo.getId(), instanceInfo, null, true);
                            isInstanceReachable = true;
                            break;
                        }
                        catch (Throwable e) {
                            logger.warn(String.format("Error while checking whether the EIP %s is used by the instance id %s as reported by eureka peer.", eip, instanceInfo.getId()), e);
                            try {
                                Thread.sleep(300L);
                            }
                            catch (InterruptedException e1) {
                                logger.warn("Interrupted while trying send heartbeat", (Throwable)e1);
                            }
                            continue;
                        }
                    }
                    if (!isInstanceReachable) {
                        logger.info("The instance {} seems unreachable, making EIP: {} available for reuse.", (Object)instanceInfo.getHostName(), (Object)eip);
                        it.remove();
                        unreachableEips.add(eip);
                        continue;
                    }
                    logger.info("Removing the EIP {} as it is already used by instance {}", (Object)eip, (Object)instanceId);
                    it.remove();
                }
            }
        }
        if (availableEIPList == null) {
            throw new RuntimeException("Cannot find a free EIP to bind");
        }
        availableEIPList.addAll(unreachableEips);
        if (!unreachableEips.isEmpty()) {
            logger.info("Added unreachable EIPs {} to the available EIP list. Final EIP list is {}", unreachableEips, availableEIPList);
        }
        if (availableEIPList.isEmpty()) {
            throw new RuntimeException("Cannot find a free EIP to bind");
        }
        return (String)availableEIPList.iterator().next();
    }

    private PeerEurekaNode getPeerEurekaNode(String instanceHostName) {
        PeerEurekaNode replicaNode = null;
        try {
            for (PeerEurekaNode node : PeerAwareInstanceRegistry.getInstance().getReplicaNodes()) {
                if (!new URL(node.getServiceUrl()).getHost().equalsIgnoreCase(instanceHostName)) continue;
                replicaNode = node;
            }
        }
        catch (Throwable e) {
            logger.error("Cannot get peer eureka node instance from instanceHostName for " + instanceHostName, replicaNode);
        }
        return replicaNode;
    }

    private Collection<String> getEIPsForZoneFromConfig(String myZone) {
        List ec2Urls = DiscoveryManager.getInstance().getEurekaClientConfig().getEurekaServerServiceUrls(myZone);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private Collection<String> getEIPsFromServiceUrls(List<String> ec2Urls) {
        ArrayList<String> returnedUrls = new ArrayList<String>();
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        String regionPhrase = "";
        if (!US_EAST_1.equals(region)) {
            regionPhrase = "." + region;
        }
        for (String cname : ec2Urls) {
            int beginIndex = cname.indexOf("ec2-") + 4;
            int endIndex = cname.indexOf(regionPhrase + ".compute");
            String eipStr = cname.substring(beginIndex, endIndex);
            String eip = eipStr.replaceAll("\\-", ".");
            returnedUrls.add(eip);
        }
        return returnedUrls;
    }

    private Collection<String> getEIPsForZoneFromDNS(String myZone) {
        List ec2Urls = DiscoveryManager.getInstance().getDiscoveryClient().getServiceUrlsFromDNS(myZone, true);
        return this.getEIPsFromServiceUrls(ec2Urls);
    }

    private AmazonEC2 getEC2Service() {
        this.eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();
        String aWSAccessId = this.eurekaConfig.getAWSAccessId();
        String aWSSecretKey = this.eurekaConfig.getAWSSecretKey();
        AmazonEC2Client ec2Service = null != aWSAccessId && !"".equals(aWSAccessId) && null != aWSSecretKey && !"".equals(aWSSecretKey) ? new AmazonEC2Client((AWSCredentials)new BasicAWSCredentials(aWSAccessId, aWSSecretKey)) : new AmazonEC2Client((AWSCredentialsProvider)new InstanceProfileCredentialsProvider());
        String region = DiscoveryManager.getInstance().getEurekaClientConfig().getRegion();
        region = region.trim().toLowerCase();
        ec2Service.setEndpoint("ec2." + region + ".amazonaws.com");
        return ec2Service;
    }
}

