/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public interface EurekaServerConfig {
    public String getAWSAccessId();

    public String getAWSSecretKey();

    public int getEIPBindRebindRetries();

    public int getEIPBindingRetryIntervalMs();

    public boolean shouldEnableSelfPreservation();

    public double getRenewalPercentThreshold();

    public int getRenewalThresholdUpdateIntervalMs();

    public int getPeerEurekaNodesUpdateIntervalMs();

    public int getNumberOfReplicationRetries();

    public int getPeerEurekaStatusRefreshTimeIntervalMs();

    public int getWaitTimeInMsWhenSyncEmpty();

    public int getPeerNodeConnectTimeoutMs();

    public int getPeerNodeReadTimeoutMs();

    public int getPeerNodeTotalConnections();

    public int getPeerNodeTotalConnectionsPerHost();

    public int getPeerNodeConnectionIdleTimeoutSeconds();

    public long getRetentionTimeInMSInDeltaQueue();

    public long getDeltaRetentionTimerIntervalInMs();

    public long getEvictionIntervalTimerInMs();

    public int getASGQueryTimeoutMs();

    public long getASGUpdateIntervalMs();

    public long getResponseCacheAutoExpirationInSeconds();

    public long getResponseCacheUpdateIntervalMs();

    public boolean shouldDisableDelta();

    public long getMaxIdleThreadInMinutesAgeForStatusReplication();

    public int getMinThreadsForStatusReplication();

    public int getMaxThreadsForStatusReplication();

    public int getMaxElementsInStatusReplicationPool();

    public boolean shouldSyncWhenTimestampDiffers();

    public int getRegistrySyncRetries();

    public int getMaxElementsInPeerReplicationPool();

    public long getMaxIdleThreadAgeInMinutesForPeerReplication();

    public int getMinThreadsForPeerReplication();

    public int getMaxThreadsForPeerReplication();

    public int getMaxTimeForReplication();

    public boolean shouldPrimeAwsReplicaConnections();

    public boolean shouldDisableDeltaForRemoteRegions();

    public int getRemoteRegionConnectTimeoutMs();

    public int getRemoteRegionReadTimeoutMs();

    public int getRemoteRegionTotalConnections();

    public int getRemoteRegionTotalConnectionsPerHost();

    public int getRemoteRegionConnectionIdleTimeoutSeconds();

    public boolean shouldGZipContentFromRemoteRegion();

    public Map<String, String> getRemoteRegionUrlsWithName();

    public String[] getRemoteRegionUrls();

    @Nullable
    public Set<String> getRemoteRegionAppWhitelist(@Nullable String var1);

    public int getRemoteRegionRegistryFetchInterval();

    public String getRemoteRegionTrustStore();

    public String getRemoteRegionTrustStorePassword();

    public boolean disableTransparentFallbackToOtherRegion();

    public boolean shouldBatchReplication();

    public boolean shouldLogIdentityHeaders();
}

