/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.appinfo.LeaseInfo;
import com.netflix.discovery.DiscoveryClient;
import com.netflix.discovery.DiscoveryManager;
import com.netflix.discovery.EurekaClientConfig;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.LookupService;
import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.InstanceRegistry;
import com.netflix.eureka.RemoteRegionRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.cluster.PeerEurekaNode;
import com.netflix.eureka.resources.ASGResource;
import com.netflix.eureka.util.MeasuredRate;
import com.netflix.servo.DefaultMonitorRegistry;
import com.netflix.servo.annotations.DataSourceType;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerAwareInstanceRegistry
extends InstanceRegistry {
    private static final String US_EAST_1 = "us-east-1";
    private static final int PRIME_PEER_NODES_RETRY_MS = 30000;
    private static final int REGISTRY_SYNC_RETRY_MS = 30000;
    private static final Logger logger = LoggerFactory.getLogger(PeerAwareInstanceRegistry.class);
    private static final EurekaServerConfig EUREKA_SERVER_CONFIG = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final EurekaClientConfig EUREKA_CLIENT_CONFIG = DiscoveryManager.getInstance().getEurekaClientConfig();
    private long startupTime = 0L;
    private boolean peerInstancesTransferEmptyOnStartup = true;
    private static final java.util.Timer timerReplicaNodes = new java.util.Timer("Eureka-PeerNodesUpdater", true);
    private static final Comparator<Application> APP_COMPARATOR = new Comparator<Application>(){

        @Override
        public int compare(Application l, Application r) {
            return l.getName().compareTo(r.getName());
        }
    };
    private final MeasuredRate numberOfReplicationsLastMin = new MeasuredRate(60000L);
    private AtomicReference<List<PeerEurekaNode>> peerEurekaNodes;
    private java.util.Timer timer = new java.util.Timer("ReplicaAwareInstanceRegistry - RenewalThresholdUpdater", true);
    private static final PeerAwareInstanceRegistry instance = new PeerAwareInstanceRegistry();

    PeerAwareInstanceRegistry() {
        this.peerEurekaNodes = new AtomicReference();
        this.peerEurekaNodes.set(new ArrayList());
        try {
            Monitors.registerObject((Object)this);
        }
        catch (Throwable e) {
            logger.warn("Cannot register the JMX monitor for the InstanceRegistry :", e);
        }
        this.init();
    }

    public static PeerAwareInstanceRegistry getInstance() {
        return instance;
    }

    private void init() {
        this.setupPeerEurekaNodes();
        this.scheduleRenewalThresholdUpdateTask();
    }

    private void scheduleRenewalThresholdUpdateTask() {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                PeerAwareInstanceRegistry.this.updateRenewalThreshold();
            }
        }, EUREKA_SERVER_CONFIG.getRenewalThresholdUpdateIntervalMs(), (long)EUREKA_SERVER_CONFIG.getRenewalThresholdUpdateIntervalMs());
    }

    private void setupPeerEurekaNodes() {
        try {
            this.updatePeerEurekaNodes();
            timerReplicaNodes.schedule(new TimerTask(){

                @Override
                public void run() {
                    try {
                        PeerAwareInstanceRegistry.this.updatePeerEurekaNodes();
                    }
                    catch (Throwable e) {
                        logger.error("Cannot update the replica Nodes", e);
                    }
                }
            }, EUREKA_SERVER_CONFIG.getPeerEurekaNodesUpdateIntervalMs(), (long)EUREKA_SERVER_CONFIG.getPeerEurekaNodesUpdateIntervalMs());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void updatePeerEurekaNodes() {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        List replicaUrls = DiscoveryManager.getInstance().getDiscoveryClient().getDiscoveryServiceUrls(DiscoveryClient.getZone((InstanceInfo)myInfo));
        ArrayList<PeerEurekaNode> replicaNodes = new ArrayList<PeerEurekaNode>();
        for (String replicaUrl : replicaUrls) {
            if (this.isThisMe(replicaUrl)) continue;
            logger.info("Adding replica node: " + replicaUrl);
            replicaNodes.add(new PeerEurekaNode(replicaUrl));
        }
        if (replicaNodes.isEmpty()) {
            logger.warn("The replica size seems to be empty. Check the route 53 DNS Registry");
            return;
        }
        List<PeerEurekaNode> existingReplicaNodes = this.peerEurekaNodes.get();
        if (!replicaNodes.equals(existingReplicaNodes)) {
            ArrayList<String> previousServiceUrls = new ArrayList<String>();
            for (PeerEurekaNode node : existingReplicaNodes) {
                previousServiceUrls.add(node.getServiceUrl());
            }
            ArrayList<String> currentServiceUrls = new ArrayList<String>();
            for (PeerEurekaNode node : replicaNodes) {
                currentServiceUrls.add(node.getServiceUrl());
            }
            logger.info("Updating the replica nodes as they seem to have changed from {} to {} ", previousServiceUrls, currentServiceUrls);
            this.peerEurekaNodes.set(replicaNodes);
            for (PeerEurekaNode existingReplicaNode : existingReplicaNodes) {
                existingReplicaNode.destroyResources();
            }
        } else {
            for (PeerEurekaNode replicaNode : replicaNodes) {
                replicaNode.destroyResources();
            }
        }
    }

    public int syncUp() {
        LookupService lookupService = DiscoveryManager.getInstance().getLookupService();
        int count = 0;
        for (int i = 0; i < EUREKA_SERVER_CONFIG.getRegistrySyncRetries() && count == 0; ++i) {
            Applications apps = lookupService.getApplications();
            for (Application app : apps.getRegisteredApplications()) {
                for (InstanceInfo instance : app.getInstances()) {
                    try {
                        if (!this.isRegisterable(instance)) continue;
                        this.register(instance, instance.getLeaseInfo().getDurationInSecs(), true);
                        ++count;
                    }
                    catch (Throwable t) {
                        logger.error("During DS init copy", t);
                    }
                }
            }
            if (count != 0) continue;
            try {
                Thread.sleep(30000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.warn("Interrupted during registry transfer..");
                break;
            }
        }
        return count;
    }

    public void openForTraffic(int count) {
        boolean isAws;
        this.expectedNumberOfRenewsPerMin = count * 2;
        this.numberOfRenewsPerMinThreshold = (int)((double)this.expectedNumberOfRenewsPerMin * EUREKA_SERVER_CONFIG.getRenewalPercentThreshold());
        logger.info("Got " + count + " instances from neighboring DS node");
        logger.info("Renew threshold is: " + this.numberOfRenewsPerMinThreshold);
        this.startupTime = System.currentTimeMillis();
        if (count > 0) {
            this.peerInstancesTransferEmptyOnStartup = false;
        }
        if ((isAws = DataCenterInfo.Name.Amazon.equals((Object)ApplicationInfoManager.getInstance().getInfo().getDataCenterInfo().getName())) && EUREKA_SERVER_CONFIG.shouldPrimeAwsReplicaConnections()) {
            logger.info("Priming AWS connections for all replicas..");
            this.primeAwsReplicas();
        }
        logger.info("Changing status to UP");
        ApplicationInfoManager.getInstance().setInstanceStatus(InstanceInfo.InstanceStatus.UP);
        super.postInit();
    }

    private void primeAwsReplicas() {
        boolean areAllPeerNodesPrimed = false;
        while (!areAllPeerNodesPrimed) {
            String peerHostName = null;
            try {
                Application eurekaApps = this.getApplication(ApplicationInfoManager.getInstance().getInfo().getAppName(), false);
                if (eurekaApps == null) {
                    areAllPeerNodesPrimed = true;
                }
                for (PeerEurekaNode node : this.peerEurekaNodes.get()) {
                    for (InstanceInfo peerInstanceInfo : eurekaApps.getInstances()) {
                        LeaseInfo leaseInfo = peerInstanceInfo.getLeaseInfo();
                        if (System.currentTimeMillis() > leaseInfo.getRenewalTimestamp() + (long)(leaseInfo.getDurationInSecs() * 1000) + 120000L) continue;
                        peerHostName = peerInstanceInfo.getHostName();
                        logger.info("Trying to send heartbeat for the eureka server at {} to make sure the network channels are open", (Object)peerHostName);
                        if (!peerHostName.equalsIgnoreCase(new URI(node.getServiceUrl()).getHost())) continue;
                        node.heartbeat(peerInstanceInfo.getAppName(), peerInstanceInfo.getId(), peerInstanceInfo, null, true);
                    }
                }
                areAllPeerNodesPrimed = true;
            }
            catch (Throwable e) {
                logger.error("Could not contact " + peerHostName, e);
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException e1) {
                    logger.warn("Interrupted while priming : ", (Throwable)e1);
                    areAllPeerNodesPrimed = true;
                }
            }
        }
    }

    public boolean shouldAllowAccess(boolean remoteRegionRequired) {
        if (this.peerInstancesTransferEmptyOnStartup && System.currentTimeMillis() <= this.startupTime + (long)EUREKA_SERVER_CONFIG.getWaitTimeInMsWhenSyncEmpty()) {
            return false;
        }
        if (remoteRegionRequired) {
            for (RemoteRegionRegistry remoteRegionRegistry : this.regionNameVSRemoteRegistry.values()) {
                if (remoteRegionRegistry.isReadyForServingData()) continue;
                return false;
            }
        }
        return true;
    }

    public boolean shouldAllowAccess() {
        return this.shouldAllowAccess(true);
    }

    public List<PeerEurekaNode> getReplicaNodes() {
        return Collections.unmodifiableList(this.peerEurekaNodes.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancel(String appName, String id, boolean isReplication) {
        if (super.cancel(appName, id, isReplication)) {
            this.replicateToPeers(Action.Cancel, appName, id, null, null, isReplication);
            Object object = this.lock;
            synchronized (object) {
                if (this.expectedNumberOfRenewsPerMin > 0) {
                    this.expectedNumberOfRenewsPerMin -= 2;
                    this.numberOfRenewsPerMinThreshold = (int)((double)this.expectedNumberOfRenewsPerMin * EUREKA_SERVER_CONFIG.getRenewalPercentThreshold());
                }
            }
            return true;
        }
        return false;
    }

    public void register(InstanceInfo info, boolean isReplication) {
        int leaseDuration = 90;
        if (info.getLeaseInfo() != null && info.getLeaseInfo().getDurationInSecs() > 0) {
            leaseDuration = info.getLeaseInfo().getDurationInSecs();
        }
        super.register(info, leaseDuration, isReplication);
        this.replicateToPeers(Action.Register, info.getAppName(), info.getId(), info, null, isReplication);
    }

    @Override
    public boolean renew(String appName, String id, boolean isReplication) {
        if (super.renew(appName, id, isReplication)) {
            this.replicateToPeers(Action.Heartbeat, appName, id, null, null, isReplication);
            return true;
        }
        return false;
    }

    @Override
    public boolean statusUpdate(String appName, String id, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        if (super.statusUpdate(appName, id, newStatus, lastDirtyTimestamp, isReplication)) {
            this.replicateToPeers(Action.StatusUpdate, appName, id, null, newStatus, isReplication);
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteStatusOverride(String appName, String id, InstanceInfo.InstanceStatus newStatus, String lastDirtyTimestamp, boolean isReplication) {
        if (super.deleteStatusOverride(appName, id, newStatus, lastDirtyTimestamp, isReplication)) {
            this.replicateToPeers(Action.DeleteStatusOverride, appName, id, null, null, isReplication);
            return true;
        }
        return false;
    }

    public void statusUpdate(String asgName, ASGResource.ASGStatus newStatus, boolean isReplication) {
        if (isReplication) {
            return;
        }
        for (PeerEurekaNode node : this.peerEurekaNodes.get()) {
            this.replicateASGInfoToReplicaNodes(asgName, newStatus, node);
        }
    }

    @Override
    public boolean isLeaseExpirationEnabled() {
        boolean leaseExpirationEnabled = this.numberOfRenewsPerMinThreshold > 0 && this.getNumOfRenewsInLastMin() > (long)this.numberOfRenewsPerMinThreshold;
        boolean isSelfPreservationModeEnabled = this.isSelfPreservationModeEnabled();
        if (!leaseExpirationEnabled && !isSelfPreservationModeEnabled) {
            logger.warn("The self preservation mode is disabled!. Hence allowing the instances to expire.");
            leaseExpirationEnabled = true;
        }
        return leaseExpirationEnabled;
    }

    public boolean isSelfPreservationModeEnabled() {
        return EUREKA_SERVER_CONFIG.shouldEnableSelfPreservation();
    }

    void shutdown() {
        try {
            DefaultMonitorRegistry.getInstance().unregister((Monitor)Monitors.newObjectMonitor((Object)this));
        }
        catch (Throwable t) {
            logger.error("Cannot shutdown monitor registry", t);
        }
        try {
            for (PeerEurekaNode node : this.peerEurekaNodes.get()) {
                node.shutDown();
            }
        }
        catch (Throwable t) {
            logger.error("Cannot shutdown ReplicaAwareInstanceRegistry", t);
        }
    }

    public InstanceInfo getNextServerFromEureka(String virtualHostname, boolean secure) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRenewalThreshold() {
        try {
            LookupService lookupService = DiscoveryManager.getInstance().getLookupService();
            Applications apps = lookupService.getApplications();
            int count = 0;
            for (Application app : apps.getRegisteredApplications()) {
                for (InstanceInfo instance : app.getInstances()) {
                    if (!this.isRegisterable(instance)) continue;
                    ++count;
                }
            }
            Object object = this.lock;
            synchronized (object) {
                if ((double)(count * 2) > EUREKA_SERVER_CONFIG.getRenewalPercentThreshold() * (double)this.numberOfRenewsPerMinThreshold || !this.isSelfPreservationModeEnabled()) {
                    this.expectedNumberOfRenewsPerMin = count * 2;
                    this.numberOfRenewsPerMinThreshold = (int)((double)(count * 2) * EUREKA_SERVER_CONFIG.getRenewalPercentThreshold());
                }
            }
            logger.info("Current renewal threshold is : {}", (Object)this.numberOfRenewsPerMinThreshold);
        }
        catch (Throwable e) {
            logger.error("Cannot update renewal threshold", e);
        }
    }

    public List<Application> getSortedApplications() {
        ArrayList<Application> apps = new ArrayList<Application>(this.getApplications().getRegisteredApplications());
        Collections.sort(apps, APP_COMPARATOR);
        return apps;
    }

    @com.netflix.servo.annotations.Monitor(name="numOfReplicationsInLastMin", description="Number of total replications received in the last minute", type=DataSourceType.GAUGE)
    public long getNumOfReplicationsInLastMin() {
        return this.numberOfReplicationsLastMin.getCount();
    }

    @com.netflix.servo.annotations.Monitor(name="isBelowRenewThreshold", description="0 = false, 1 = true", type=DataSourceType.GAUGE)
    public int isBelowRenewThresold() {
        if (this.getNumOfRenewsInLastMin() < (long)this.numberOfRenewsPerMinThreshold && this.startupTime > 0L && System.currentTimeMillis() > this.startupTime + (long)EUREKA_SERVER_CONFIG.getWaitTimeInMsWhenSyncEmpty()) {
            return 1;
        }
        return 0;
    }

    @com.netflix.servo.annotations.Monitor(name="numOfRenewsPerMinThreshold", type=DataSourceType.GAUGE)
    public int getNumOfRenewsPerMinThreshold() {
        return this.numberOfRenewsPerMinThreshold;
    }

    public boolean isRegisterable(InstanceInfo instanceInfo) {
        DataCenterInfo datacenterInfo = instanceInfo.getDataCenterInfo();
        String serverRegion = EUREKA_CLIENT_CONFIG.getRegion();
        if (AmazonInfo.class.isInstance(datacenterInfo)) {
            AmazonInfo info = (AmazonInfo)AmazonInfo.class.cast(instanceInfo.getDataCenterInfo());
            String availabilityZone = info.get(AmazonInfo.MetaDataKey.availabilityZone);
            if (availabilityZone == null && US_EAST_1.equalsIgnoreCase(serverRegion)) {
                return true;
            }
            if (availabilityZone != null && availabilityZone.contains(serverRegion)) {
                return true;
            }
        }
        return true;
    }

    private boolean isThisMe(String url) {
        InstanceInfo myInfo = ApplicationInfoManager.getInstance().getInfo();
        try {
            URI uri = new URI(url);
            return uri.getHost().equals(myInfo.getHostName());
        }
        catch (URISyntaxException e) {
            logger.error("Error in syntax", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateToPeers(Action action, String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus newStatus, boolean isReplication) {
        Stopwatch tracer = action.getTimer().start();
        try {
            if (isReplication) {
                this.numberOfReplicationsLastMin.increment();
            }
            if (this.peerEurekaNodes == Collections.EMPTY_LIST || isReplication) {
                return;
            }
            for (PeerEurekaNode node : this.peerEurekaNodes.get()) {
                if (this.isThisMe(node.getServiceUrl())) continue;
                this.replicateInstanceActionsToPeers(action, appName, id, info, newStatus, node);
            }
        }
        finally {
            tracer.stop();
        }
    }

    private void replicateInstanceActionsToPeers(Action action, String appName, String id, InstanceInfo info, InstanceInfo.InstanceStatus newStatus, PeerEurekaNode node) {
        try {
            InstanceInfo infoFromRegistry = null;
            CurrentRequestVersion.set(Version.V2);
            switch (action) {
                case Cancel: {
                    node.cancel(appName, id);
                    break;
                }
                case Heartbeat: {
                    InstanceInfo.InstanceStatus overriddenStatus = (InstanceInfo.InstanceStatus)this.overriddenInstanceStatusMap.get(id);
                    infoFromRegistry = this.getInstanceByAppAndId(appName, id, false);
                    node.heartbeat(appName, id, infoFromRegistry, overriddenStatus, false);
                    break;
                }
                case Register: {
                    node.register(info);
                    break;
                }
                case StatusUpdate: {
                    infoFromRegistry = this.getInstanceByAppAndId(appName, id, false);
                    node.statusUpdate(appName, id, newStatus, infoFromRegistry);
                    break;
                }
                case DeleteStatusOverride: {
                    infoFromRegistry = this.getInstanceByAppAndId(appName, id, false);
                    node.deleteStatusOverride(appName, id, infoFromRegistry);
                }
            }
        }
        catch (Throwable t) {
            logger.error("Cannot replicate information to " + node.getServiceUrl() + " for action " + action.name(), t);
        }
    }

    private void replicateASGInfoToReplicaNodes(String asgName, ASGResource.ASGStatus newStatus, PeerEurekaNode node) {
        CurrentRequestVersion.set(Version.V2);
        try {
            node.statusUpdate(asgName, newStatus);
        }
        catch (Throwable e) {
            logger.error("Cannot replicate ASG status information to " + node.getServiceUrl(), e);
        }
    }

    public static enum Action {
        Heartbeat,
        Register,
        Cancel,
        StatusUpdate,
        DeleteStatusOverride;

        private Timer timer = Monitors.newTimer((String)this.name());

        public Timer getTimer() {
            return this.timer;
        }
    }
}

