/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.TimedSupervisorTask;
import com.netflix.discovery.shared.Application;
import com.netflix.discovery.shared.Applications;
import com.netflix.discovery.shared.EurekaJerseyClient;
import com.netflix.discovery.shared.LookupService;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.servo.monitor.Monitors;
import com.netflix.servo.monitor.Stopwatch;
import com.netflix.servo.monitor.Timer;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteRegionRegistry
implements LookupService<String> {
    private static EurekaServerConfig EUREKA_SERVER_CONFIG = EurekaServerConfigurationManager.getInstance().getConfiguration();
    private static final Logger logger = LoggerFactory.getLogger(RemoteRegionRegistry.class);
    private ApacheHttpClient4 discoveryApacheClient;
    private EurekaJerseyClient.JerseyClient discoveryJerseyClient;
    private Timer fetchRegistryTimer;
    private URL remoteRegionURL;
    private final ScheduledExecutorService scheduler;
    private volatile AtomicLong fullRegistryGeneration = new AtomicLong(0L);
    private volatile AtomicLong deltaGeneration = new AtomicLong(0L);
    private volatile AtomicReference<Applications> applications = new AtomicReference();
    private volatile AtomicReference<Applications> applicationsDelta = new AtomicReference();
    private volatile boolean readyForServingData;

    public RemoteRegionRegistry(String regionName, URL remoteRegionURL) {
        this.remoteRegionURL = remoteRegionURL;
        this.fetchRegistryTimer = Monitors.newTimer((String)(this.remoteRegionURL.toString() + "_" + "FetchRegistry"));
        if (remoteRegionURL.getProtocol().equals("http")) {
            String jerseyClientName = "Discovery-RemoteRegionClient-" + regionName;
            this.discoveryJerseyClient = EurekaJerseyClient.createJerseyClient((String)jerseyClientName, (int)EUREKA_SERVER_CONFIG.getRemoteRegionConnectTimeoutMs(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionReadTimeoutMs(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionTotalConnectionsPerHost(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionTotalConnections(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionConnectionIdleTimeoutSeconds());
        } else if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
            String jerseyClientName = "Discovery-RemoteRegionSystemSecureClient-" + regionName;
            this.discoveryJerseyClient = EurekaJerseyClient.createSystemSSLJerseyClient((String)jerseyClientName, (int)EUREKA_SERVER_CONFIG.getRemoteRegionConnectTimeoutMs(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionReadTimeoutMs(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionTotalConnectionsPerHost(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionTotalConnections(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionConnectionIdleTimeoutSeconds());
        } else {
            String jerseyClientName = "Discovery-RemoteRegionSecureClient-" + regionName;
            this.discoveryJerseyClient = EurekaJerseyClient.createSSLJerseyClient((String)jerseyClientName, (int)EUREKA_SERVER_CONFIG.getRemoteRegionConnectTimeoutMs(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionReadTimeoutMs(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionTotalConnectionsPerHost(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionTotalConnections(), (int)EUREKA_SERVER_CONFIG.getRemoteRegionConnectionIdleTimeoutSeconds(), (String)EUREKA_SERVER_CONFIG.getRemoteRegionTrustStore(), (String)EUREKA_SERVER_CONFIG.getRemoteRegionTrustStorePassword());
        }
        this.discoveryApacheClient = this.discoveryJerseyClient.getClient();
        if (EUREKA_SERVER_CONFIG.shouldGZipContentFromRemoteRegion()) {
            this.discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
        }
        String ip = null;
        try {
            ip = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            logger.warn("Cannot find localhost ip", (Throwable)e);
        }
        EurekaServerIdentity identity = new EurekaServerIdentity(ip);
        this.discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
        this.applications.set(new Applications());
        try {
            if (this.fetchRegistry()) {
                this.readyForServingData = true;
            } else {
                logger.warn("Failed to fetch remote registry. This means this eureka server is not ready for serving traffic.");
            }
        }
        catch (Throwable e) {
            logger.error("Problem fetching registry information :", e);
        }
        Runnable remoteRegionFetchTask = new Runnable(){

            @Override
            public void run() {
                try {
                    if (RemoteRegionRegistry.this.fetchRegistry()) {
                        RemoteRegionRegistry.this.readyForServingData = true;
                    } else {
                        logger.warn("Failed to fetch remote registry. This means this eureka server is not ready for serving traffic.");
                    }
                }
                catch (Throwable e) {
                    logger.error("Error getting from remote registry :", e);
                }
            }
        };
        ThreadPoolExecutor remoteRegionFetchExecutor = new ThreadPoolExecutor(1, EUREKA_SERVER_CONFIG.getRemoteRegionFetchThreadPoolSize(), 0L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
        this.scheduler = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setNameFormat("Eureka-RemoteRegionCacheRefresher_" + regionName + "-%d").setDaemon(true).build());
        this.scheduler.schedule((Runnable)new TimedSupervisorTask("RemoteRegionFetch_" + regionName, this.scheduler, remoteRegionFetchExecutor, EUREKA_SERVER_CONFIG.getRemoteRegionRegistryFetchInterval(), TimeUnit.SECONDS, 5, remoteRegionFetchTask), (long)EUREKA_SERVER_CONFIG.getRemoteRegionRegistryFetchInterval(), TimeUnit.SECONDS);
    }

    public boolean isReadyForServingData() {
        return this.readyForServingData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean fetchRegistry() {
        ClientResponse response;
        block16: {
            response = null;
            Stopwatch tracer = this.fetchRegistryTimer.start();
            try {
                if (EUREKA_SERVER_CONFIG.shouldDisableDeltaForRemoteRegions() || this.getApplications() == null || this.getApplications().getRegisteredApplications().size() == 0) {
                    logger.info("Disable delta property : {}", (Object)EUREKA_SERVER_CONFIG.shouldDisableDeltaForRemoteRegions());
                    logger.info("Application is null : {}", (Object)(this.getApplications() == null ? 1 : 0));
                    logger.info("Registered Applications size is zero : {}", (Object)(this.getApplications().getRegisteredApplications().size() == 0 ? 1 : 0));
                    response = this.storeFullRegistry();
                } else {
                    long currDeltaGeneration = this.deltaGeneration.get();
                    Applications delta = null;
                    response = this.fetchRemoteRegistry(true);
                    if (null != response) {
                        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                            delta = (Applications)response.getEntity(Applications.class);
                            if (delta == null) {
                                logger.error("The delta is null for some reason. Not storing this information");
                            } else if (this.deltaGeneration.compareAndSet(currDeltaGeneration, currDeltaGeneration + 1L)) {
                                this.applicationsDelta.set(delta);
                            } else {
                                delta = null;
                                logger.warn("Not updating delta as another thread is updating it already");
                            }
                        }
                        if (delta == null) {
                            logger.warn("The server does not allow the delta revision to be applied because it is not safe. Hence got the full registry.");
                            this.closeResponse(response);
                            response = this.fetchRemoteRegistry(true);
                        } else {
                            this.updateDelta(delta);
                            String reconcileHashCode = this.getApplications().getReconcileHashCode();
                            if (!reconcileHashCode.equals(delta.getAppsHashCode())) {
                                response = this.reconcileAndLogDifference(response, delta, reconcileHashCode);
                            }
                        }
                    }
                }
                this.logTotalInstances();
                logger.debug("Remote Registry Fetch Status : {}", null == response ? null : Integer.valueOf(response.getStatus()));
                if (tracer == null) break block16;
            }
            catch (Throwable e) {
                boolean bl;
                block17: {
                    try {
                        logger.error("Unable to fetch registry information from the remote registry " + this.remoteRegionURL.toString(), e);
                        bl = false;
                        if (tracer == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (tracer != null) {
                            tracer.stop();
                        }
                        this.closeResponse(response);
                        throw throwable;
                    }
                    tracer.stop();
                }
                this.closeResponse(response);
                return bl;
            }
            tracer.stop();
        }
        this.closeResponse(response);
        if (null != response) return true;
        return false;
    }

    private void updateDelta(Applications delta) {
        int deltaCount = 0;
        for (Application app : delta.getRegisteredApplications()) {
            for (InstanceInfo instance : app.getInstances()) {
                Application existingApp;
                ++deltaCount;
                if (InstanceInfo.ActionType.ADDED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Added instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (InstanceInfo.ActionType.MODIFIED.equals((Object)instance.getActionType())) {
                    existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                    if (existingApp == null) {
                        this.getApplications().addApplication(app);
                    }
                    logger.debug("Modified instance {} to the existing apps ", (Object)instance.getId());
                    this.getApplications().getRegisteredApplications(instance.getAppName()).addInstance(instance);
                    continue;
                }
                if (!InstanceInfo.ActionType.DELETED.equals((Object)instance.getActionType())) continue;
                existingApp = this.getApplications().getRegisteredApplications(instance.getAppName());
                if (existingApp == null) {
                    this.getApplications().addApplication(app);
                }
                logger.debug("Deleted instance {} to the existing apps ", (Object)instance.getId());
                this.getApplications().getRegisteredApplications(instance.getAppName()).removeInstance(instance);
            }
        }
        logger.debug("The total number of instances fetched by the delta processor : {}", (Object)deltaCount);
    }

    private void closeResponse(ClientResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (Throwable th) {
                logger.error("Cannot release response resource :", th);
            }
        }
    }

    public ClientResponse storeFullRegistry() {
        long currentUpdateGeneration = this.fullRegistryGeneration.get();
        ClientResponse response = this.fetchRemoteRegistry(false);
        if (response == null) {
            logger.error("The response is null.");
            return null;
        }
        Applications apps = (Applications)response.getEntity(Applications.class);
        if (apps == null) {
            logger.error("The application is null for some reason. Not storing this information");
        } else if (this.fullRegistryGeneration.compareAndSet(currentUpdateGeneration, currentUpdateGeneration + 1L)) {
            this.applications.set(apps);
        } else {
            logger.warn("Not updating applications as another thread is updating it already");
        }
        logger.info("The response status is {}", (Object)response.getStatus());
        return response;
    }

    private ClientResponse fetchRemoteRegistry(boolean delta) {
        logger.info("Getting instance registry info from the eureka server : {} , delta : {}", (Object)this.remoteRegionURL, (Object)delta);
        ClientResponse response = null;
        try {
            String urlPath = delta ? "apps/delta" : "apps/";
            response = (ClientResponse)this.discoveryApacheClient.resource(this.remoteRegionURL.toString() + urlPath).accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(ClientResponse.class);
            int httpStatus = response.getStatus();
            if (httpStatus < 200 || httpStatus >= 300) {
                logger.warn("Cannot get the data from {} : {}", (Object)this.remoteRegionURL.toString(), (Object)httpStatus);
                return null;
            }
            logger.debug("Got the data successfully : {}", (Object)httpStatus);
        }
        catch (Throwable t) {
            logger.error("Can't get a response from " + this.remoteRegionURL, t);
        }
        return response;
    }

    private ClientResponse reconcileAndLogDifference(ClientResponse response, Applications delta, String reconcileHashCode) throws Throwable {
        logger.warn("The Reconcile hashcodes do not match, client : {}, server : {}. Getting the full registry", (Object)reconcileHashCode, (Object)delta.getAppsHashCode());
        this.closeResponse(response);
        response = this.fetchRemoteRegistry(false);
        if (null == response) {
            logger.warn("Response is null while fetching remote registry during reconcile difference.");
            return null;
        }
        Applications serverApps = (Applications)response.getEntity(Applications.class);
        Map reconcileDiffMap = this.getApplications().getReconcileMapDiff(serverApps);
        String reconcileString = "";
        for (Map.Entry mapEntry : reconcileDiffMap.entrySet()) {
            reconcileString = reconcileString + (String)mapEntry.getKey() + ": ";
            for (String displayString : (List)mapEntry.getValue()) {
                reconcileString = reconcileString + displayString;
            }
            reconcileString = reconcileString + "\n";
        }
        logger.warn("The reconcile string is {}", (Object)reconcileString);
        this.applications.set(serverApps);
        this.applicationsDelta.set(serverApps);
        logger.warn("The Reconcile hashcodes after complete sync up, client : {}, server : {}.", (Object)this.getApplications().getReconcileHashCode(), (Object)delta.getAppsHashCode());
        return response;
    }

    private void logTotalInstances() {
        int totInstances = 0;
        for (Application application : this.getApplications().getRegisteredApplications()) {
            totInstances += application.getInstancesAsIsFromEureka().size();
        }
        logger.debug("The total number of all instances in the client now is {}", (Object)totInstances);
    }

    public Applications getApplications() {
        return this.applications.get();
    }

    public InstanceInfo getNextServerFromEureka(String arg0, boolean arg1) {
        return null;
    }

    public Application getApplication(String appName) {
        return this.applications.get().getRegisteredApplications(appName);
    }

    public List<InstanceInfo> getInstancesById(String id) {
        List<InstanceInfo> list = Collections.emptyList();
        for (Application app : this.applications.get().getRegisteredApplications()) {
            InstanceInfo info = app.getByInstanceId(id);
            if (info == null) continue;
            list.add(info);
            return list;
        }
        return list;
    }

    public Applications getApplicationDeltas() {
        return this.applicationsDelta.get();
    }
}

