/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.eureka.CurrentRequestVersion;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerConfigurationManager;
import com.netflix.eureka.PeerAwareInstanceRegistry;
import com.netflix.eureka.Version;
import com.netflix.eureka.resources.ApplicationResource;
import com.netflix.eureka.resources.ResponseCache;
import com.netflix.eureka.util.EurekaMonitors;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="/{version}/apps")
@Produces(value={"application/xml", "application/json"})
public class ApplicationsResource {
    private static final String HEADER_ACCEPT = "Accept";
    private static final String HEADER_ACCEPT_ENCODING = "Accept-Encoding";
    private static final String HEADER_CONTENT_ENCODING = "Content-Encoding";
    private static final String HEADER_GZIP_VALUE = "gzip";
    private static final String HEADER_JSON_VALUE = "json";
    private static final EurekaServerConfig eurekaConfig = EurekaServerConfigurationManager.getInstance().getConfiguration();

    @Path(value="{appId}")
    public ApplicationResource getApplicationResource(@PathParam(value="version") String version, @PathParam(value="appId") String appId) {
        CurrentRequestVersion.set(Version.toEnum(version));
        return new ApplicationResource(appId);
    }

    @GET
    public Response getContainers(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="Accept-Encoding") String acceptEncoding, @Context UriInfo uriInfo) {
        EurekaMonitors.GET_ALL.increment();
        if (!PeerAwareInstanceRegistry.getInstance().shouldAllowAccess()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        CurrentRequestVersion.set(Version.toEnum(version));
        ResponseCache.KeyType keyType = ResponseCache.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains(HEADER_JSON_VALUE)) {
            keyType = ResponseCache.KeyType.XML;
        }
        ResponseCache.Key cacheKey = new ResponseCache.Key("ALL_APPS", keyType, CurrentRequestVersion.get());
        if (acceptEncoding != null && acceptEncoding.contains(HEADER_GZIP_VALUE)) {
            return Response.ok((Object)ResponseCache.getInstance().getGZIP(cacheKey)).header(HEADER_CONTENT_ENCODING, (Object)HEADER_GZIP_VALUE).build();
        }
        return Response.ok((Object)ResponseCache.getInstance().get(cacheKey)).build();
    }

    @Path(value="delta")
    @GET
    public Response getContainerDifferential(@PathParam(value="version") String version, @HeaderParam(value="Accept") String acceptHeader, @HeaderParam(value="Accept-Encoding") String acceptEncoding, @Context UriInfo uriInfo) {
        if (eurekaConfig.shouldDisableDelta() || !PeerAwareInstanceRegistry.getInstance().isLeaseExpirationEnabled() || !PeerAwareInstanceRegistry.getInstance().shouldAllowAccess()) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        EurekaMonitors.GET_ALL_DELTA.increment();
        CurrentRequestVersion.set(Version.toEnum(version));
        ResponseCache.KeyType keyType = ResponseCache.KeyType.JSON;
        if (acceptHeader == null || !acceptHeader.contains(HEADER_JSON_VALUE)) {
            keyType = ResponseCache.KeyType.XML;
        }
        ResponseCache.Key cacheKey = new ResponseCache.Key("ALL_APPS_DELTA", keyType, CurrentRequestVersion.get());
        if (acceptEncoding != null && acceptEncoding.contains(HEADER_GZIP_VALUE)) {
            return Response.ok((Object)ResponseCache.getInstance().getGZIP(cacheKey)).header(HEADER_CONTENT_ENCODING, (Object)HEADER_GZIP_VALUE).build();
        }
        return Response.ok((Object)ResponseCache.getInstance().get(cacheKey)).build();
    }
}

