/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.transport;

import com.netflix.appinfo.AbstractEurekaIdentity;
import com.netflix.discovery.EurekaIdentityHeaderFilter;
import com.netflix.discovery.converters.wrappers.DecoderWrapper;
import com.netflix.discovery.converters.wrappers.EncoderWrapper;
import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import com.netflix.discovery.shared.transport.TransportClientFactory;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClient;
import com.netflix.discovery.shared.transport.jersey.EurekaJerseyClientImpl;
import com.netflix.discovery.shared.transport.jersey.JerseyApplicationClient;
import com.netflix.eureka.EurekaServerConfig;
import com.netflix.eureka.EurekaServerIdentity;
import com.netflix.eureka.resources.ServerCodecs;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.GZIPContentEncodingFilter;
import com.sun.jersey.client.apache4.ApacheHttpClient4;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JerseyRemoteRegionClientFactory
implements TransportClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(JerseyRemoteRegionClientFactory.class);
    private final EurekaServerConfig serverConfig;
    private final ServerCodecs serverCodecs;
    private final String region;
    private volatile EurekaJerseyClient jerseyClient;
    private final Object lock = new Object();

    @Inject
    public JerseyRemoteRegionClientFactory(EurekaServerConfig serverConfig, ServerCodecs serverCodecs, String region) {
        this.serverConfig = serverConfig;
        this.serverCodecs = serverCodecs;
        this.region = region;
    }

    public EurekaHttpClient newClient(EurekaEndpoint endpoint) {
        return new JerseyApplicationClient((Client)this.getOrCreateJerseyClient(this.region, endpoint).getClient(), endpoint.getServiceUrl(), false);
    }

    public void shutdown() {
        if (this.jerseyClient != null) {
            this.jerseyClient.destroyResources();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EurekaJerseyClient getOrCreateJerseyClient(String region, EurekaEndpoint endpoint) {
        if (this.jerseyClient != null) {
            return this.jerseyClient;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.jerseyClient == null) {
                EurekaJerseyClientImpl.EurekaJerseyClientBuilder clientBuilder = new EurekaJerseyClientImpl.EurekaJerseyClientBuilder().withUserAgent("Java-EurekaClient-RemoteRegion").withEncoderWrapper((EncoderWrapper)this.serverCodecs.getFullJsonCodec()).withDecoderWrapper((DecoderWrapper)this.serverCodecs.getFullJsonCodec()).withConnectionTimeout(this.serverConfig.getRemoteRegionConnectTimeoutMs()).withReadTimeout(this.serverConfig.getRemoteRegionReadTimeoutMs()).withMaxConnectionsPerHost(this.serverConfig.getRemoteRegionTotalConnectionsPerHost()).withMaxTotalConnections(this.serverConfig.getRemoteRegionTotalConnections()).withConnectionIdleTimeout(this.serverConfig.getRemoteRegionConnectionIdleTimeoutSeconds());
                if (endpoint.isSecure()) {
                    clientBuilder.withClientName("Discovery-RemoteRegionClient-" + region);
                } else if ("true".equals(System.getProperty("com.netflix.eureka.shouldSSLConnectionsUseSystemSocketFactory"))) {
                    clientBuilder.withClientName("Discovery-RemoteRegionSystemSecureClient-" + region).withSystemSSLConfiguration();
                } else {
                    clientBuilder.withClientName("Discovery-RemoteRegionSecureClient-" + region).withTrustStoreFile(this.serverConfig.getRemoteRegionTrustStore(), this.serverConfig.getRemoteRegionTrustStorePassword());
                }
                this.jerseyClient = clientBuilder.build();
                ApacheHttpClient4 discoveryApacheClient = this.jerseyClient.getClient();
                boolean enableGZIPContentEncodingFilter = this.serverConfig.shouldGZipContentFromRemoteRegion();
                if (enableGZIPContentEncodingFilter) {
                    discoveryApacheClient.addFilter((ClientFilter)new GZIPContentEncodingFilter(false));
                }
                String ip = null;
                try {
                    ip = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    logger.warn("Cannot find localhost ip", (Throwable)e);
                }
                EurekaServerIdentity identity = new EurekaServerIdentity(ip);
                discoveryApacheClient.addFilter((ClientFilter)new EurekaIdentityHeaderFilter((AbstractEurekaIdentity)identity));
            }
        }
        return this.jerseyClient;
    }
}

