/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster.protocol;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.netflix.appinfo.InstanceInfo;

public class ReplicationInstanceResponse {
    private final int statusCode;
    private final InstanceInfo responseEntity;

    @JsonCreator
    public ReplicationInstanceResponse(@JsonProperty(value="statusCode") int statusCode, @JsonProperty(value="responseEntity") InstanceInfo responseEntity) {
        this.statusCode = statusCode;
        this.responseEntity = responseEntity;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InstanceInfo getResponseEntity() {
        return this.responseEntity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicationInstanceResponse that = (ReplicationInstanceResponse)o;
        if (this.statusCode != that.statusCode) {
            return false;
        }
        return !(this.responseEntity != null ? !this.responseEntity.equals((Object)that.responseEntity) : that.responseEntity != null);
    }

    public int hashCode() {
        int result = this.statusCode;
        result = 31 * result + (this.responseEntity != null ? this.responseEntity.hashCode() : 0);
        return result;
    }

    public static final class Builder {
        private int statusCode;
        private InstanceInfo responseEntity;

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setResponseEntity(InstanceInfo entity) {
            this.responseEntity = entity;
            return this;
        }

        public ReplicationInstanceResponse build() {
            return new ReplicationInstanceResponse(this.statusCode, this.responseEntity);
        }
    }
}

