/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.eureka.EurekaServerConfig;
import com.sun.jersey.api.client.AbstractClientRequestAdapter;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientRequestAdapter;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class DynamicGZIPContentEncodingFilter
extends ClientFilter {
    private static final String GZIP_ENCODING = "gzip";
    private final EurekaServerConfig config;

    public DynamicGZIPContentEncodingFilter(EurekaServerConfig config) {
        this.config = config;
    }

    public ClientResponse handle(ClientRequest request) {
        if (!request.getHeaders().containsKey((Object)"Accept-Encoding")) {
            request.getHeaders().add((Object)"Accept-Encoding", (Object)GZIP_ENCODING);
        }
        if (request.getEntity() != null) {
            Object requestEncoding = request.getHeaders().getFirst((Object)"Content-Encoding");
            if (GZIP_ENCODING.equals(requestEncoding)) {
                request.setAdapter((ClientRequestAdapter)new GzipAdapter(request.getAdapter()));
            } else if (this.isCompressionEnabled()) {
                request.getHeaders().add((Object)"Content-Encoding", (Object)GZIP_ENCODING);
                request.setAdapter((ClientRequestAdapter)new GzipAdapter(request.getAdapter()));
            }
        }
        ClientResponse response = this.getNext().handle(request);
        String responseEncoding = (String)response.getHeaders().getFirst((Object)"Content-Encoding");
        if (response.hasEntity() && GZIP_ENCODING.equals(responseEncoding)) {
            response.getHeaders().remove((Object)"Content-Encoding");
            DynamicGZIPContentEncodingFilter.decompressResponse(response);
        }
        return response;
    }

    private boolean isCompressionEnabled() {
        return this.config.shouldEnableReplicatedRequestCompression();
    }

    private static void decompressResponse(ClientResponse response) {
        GZIPInputStream uncompressedIS;
        InputStream entityInputStream = response.getEntityInputStream();
        try {
            uncompressedIS = new GZIPInputStream(entityInputStream);
        }
        catch (IOException ex) {
            try {
                entityInputStream.close();
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw new ClientHandlerException((Throwable)ex);
        }
        response.setEntityInputStream((InputStream)uncompressedIS);
    }

    private static final class GzipAdapter
    extends AbstractClientRequestAdapter {
        GzipAdapter(ClientRequestAdapter cra) {
            super(cra);
        }

        public OutputStream adapt(ClientRequest request, OutputStream out) throws IOException {
            return new GZIPOutputStream(this.getAdapter().adapt(request, out));
        }
    }
}

