/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.cluster;

import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.shared.transport.EurekaHttpResponse;
import com.netflix.eureka.cluster.HttpReplicationClient;
import com.netflix.eureka.cluster.InstanceReplicationTask;
import com.netflix.eureka.cluster.ReplicationTask;
import com.netflix.eureka.cluster.protocol.ReplicationInstance;
import com.netflix.eureka.cluster.protocol.ReplicationInstanceResponse;
import com.netflix.eureka.cluster.protocol.ReplicationList;
import com.netflix.eureka.cluster.protocol.ReplicationListResponse;
import com.netflix.eureka.util.batcher.TaskProcessor;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReplicationTaskProcessor
implements TaskProcessor<ReplicationTask> {
    private static final Logger logger = LoggerFactory.getLogger(ReplicationTaskProcessor.class);
    private final HttpReplicationClient replicationClient;
    private final String peerId;
    private volatile long lastNetworkErrorTime;

    ReplicationTaskProcessor(String peerId, HttpReplicationClient replicationClient) {
        this.replicationClient = replicationClient;
        this.peerId = peerId;
    }

    @Override
    public TaskProcessor.ProcessingResult process(ReplicationTask task) {
        try {
            EurekaHttpResponse<?> httpResponse = task.execute();
            int statusCode = httpResponse.getStatusCode();
            Object entity = httpResponse.getEntity();
            if (logger.isDebugEnabled()) {
                logger.debug("Replication task {} completed with status {}, (includes entity {})", new Object[]{task.getTaskName(), statusCode, entity != null});
            }
            if (!ReplicationTaskProcessor.isSuccess(statusCode)) {
                if (statusCode == 503) {
                    logger.debug("Server busy (503) reply for task {}", (Object)task.getTaskName());
                    return TaskProcessor.ProcessingResult.Congestion;
                }
                task.handleFailure(statusCode, entity);
                return TaskProcessor.ProcessingResult.PermanentError;
            }
            task.handleSuccess();
        }
        catch (Throwable e) {
            if (ReplicationTaskProcessor.isNetworkConnectException(e)) {
                this.logNetworkErrorSample(task, e);
                return TaskProcessor.ProcessingResult.TransientError;
            }
            logger.error("{}: {} Not re-trying this exception because it does not seem to be a network exception", new Object[]{this.peerId, task.getTaskName(), e});
            return TaskProcessor.ProcessingResult.PermanentError;
        }
        return TaskProcessor.ProcessingResult.Success;
    }

    @Override
    public TaskProcessor.ProcessingResult process(List<ReplicationTask> tasks) {
        ReplicationList list = this.createReplicationListOf(tasks);
        try {
            EurekaHttpResponse<ReplicationListResponse> response = this.replicationClient.submitBatchUpdates(list);
            int statusCode = response.getStatusCode();
            if (!ReplicationTaskProcessor.isSuccess(statusCode)) {
                if (statusCode == 503) {
                    logger.warn("Server busy (503) HTTP status code received from the peer {}; rescheduling tasks after delay", (Object)this.peerId);
                    return TaskProcessor.ProcessingResult.Congestion;
                }
                logger.error("Batch update failure with HTTP status code {}; discarding {} replication tasks", (Object)statusCode, (Object)tasks.size());
                return TaskProcessor.ProcessingResult.PermanentError;
            }
            this.handleBatchResponse(tasks, ((ReplicationListResponse)response.getEntity()).getResponseList());
        }
        catch (Throwable e) {
            if (ReplicationTaskProcessor.isNetworkConnectException(e)) {
                this.logNetworkErrorSample(null, e);
                return TaskProcessor.ProcessingResult.TransientError;
            }
            logger.error("Not re-trying this exception because it does not seem to be a network exception", e);
            return TaskProcessor.ProcessingResult.PermanentError;
        }
        return TaskProcessor.ProcessingResult.Success;
    }

    private void logNetworkErrorSample(ReplicationTask task, Throwable e) {
        long now = System.currentTimeMillis();
        if (now - this.lastNetworkErrorTime > 10000L) {
            this.lastNetworkErrorTime = now;
            StringBuilder sb = new StringBuilder();
            sb.append("Network level connection to peer ").append(this.peerId);
            if (task != null) {
                sb.append(" for task ").append(task.getTaskName());
            }
            sb.append("; retrying after delay");
            logger.error(sb.toString(), e);
        }
    }

    private void handleBatchResponse(List<ReplicationTask> tasks, List<ReplicationInstanceResponse> responseList) {
        if (tasks.size() != responseList.size()) {
            logger.error("Batch response size different from submitted task list ({} != {}); skipping response analysis", (Object)responseList.size(), (Object)tasks.size());
            return;
        }
        for (int i = 0; i < tasks.size(); ++i) {
            this.handleBatchResponse(tasks.get(i), responseList.get(i));
        }
    }

    private void handleBatchResponse(ReplicationTask task, ReplicationInstanceResponse response) {
        int statusCode = response.getStatusCode();
        if (ReplicationTaskProcessor.isSuccess(statusCode)) {
            task.handleSuccess();
            return;
        }
        try {
            task.handleFailure(response.getStatusCode(), response.getResponseEntity());
        }
        catch (Throwable e) {
            logger.error("Replication task {} error handler failure", (Object)task.getTaskName(), (Object)e);
        }
    }

    private ReplicationList createReplicationListOf(List<ReplicationTask> tasks) {
        ReplicationList list = new ReplicationList();
        for (ReplicationTask task : tasks) {
            list.addReplicationInstance(ReplicationTaskProcessor.createReplicationInstanceOf((InstanceReplicationTask)task));
        }
        return list;
    }

    private static boolean isSuccess(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    private static boolean isNetworkConnectException(Throwable e) {
        do {
            if (!IOException.class.isInstance(e)) continue;
            return true;
        } while ((e = e.getCause()) != null);
        return false;
    }

    private static ReplicationInstance createReplicationInstanceOf(InstanceReplicationTask task) {
        ReplicationInstance.ReplicationInstanceBuilder instanceBuilder = ReplicationInstance.ReplicationInstanceBuilder.aReplicationInstance();
        instanceBuilder.withAppName(task.getAppName());
        instanceBuilder.withId(task.getId());
        InstanceInfo instanceInfo = task.getInstanceInfo();
        if (instanceInfo != null) {
            String overriddenStatus = task.getOverriddenStatus() == null ? null : task.getOverriddenStatus().name();
            instanceBuilder.withOverriddenStatus(overriddenStatus);
            instanceBuilder.withLastDirtyTimestamp(instanceInfo.getLastDirtyTimestamp());
            if (task.shouldReplicateInstanceInfo()) {
                instanceBuilder.withInstanceInfo(instanceInfo);
            }
            String instanceStatus = instanceInfo.getStatus() == null ? null : instanceInfo.getStatus().name();
            instanceBuilder.withStatus(instanceStatus);
        }
        instanceBuilder.withAction(task.getAction());
        return instanceBuilder.build();
    }
}

