/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.eureka.resources;

import com.netflix.eureka.EurekaServerContext;
import com.netflix.eureka.EurekaServerContextHolder;
import com.netflix.eureka.Version;
import com.netflix.eureka.registry.PeerAwareInstanceRegistry;
import com.netflix.eureka.resources.CurrentRequestVersion;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Produces(value={"application/xml", "application/json"})
@Path(value="/{version}/instances")
public class InstancesResource {
    private static final Logger logger = LoggerFactory.getLogger(InstancesResource.class);
    private final PeerAwareInstanceRegistry registry;

    @Inject
    InstancesResource(EurekaServerContext server) {
        this.registry = server.getRegistry();
    }

    public InstancesResource() {
        this(EurekaServerContextHolder.getInstance().getServerContext());
    }

    @GET
    @Path(value="{id}")
    public Response getById(@PathParam(value="version") String version, @PathParam(value="id") String id) {
        CurrentRequestVersion.set(Version.toEnum(version));
        List list = this.registry.getInstancesById(id);
        if (list != null && !list.isEmpty()) {
            return Response.ok(list.get(0)).build();
        }
        logger.info("Not Found: {}", (Object)id);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

