/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommand;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixExecutableInfo;
import com.netflix.hystrix.HystrixRequestCache;
import com.netflix.hystrix.HystrixRequestLog;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesFactory;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixProperty;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscriber;
import rx.schedulers.Schedulers;
import rx.subjects.ReplaySubject;

abstract class HystrixExecutableBase<R>
implements HystrixExecutable<R>,
HystrixExecutableInfo<R> {
    private static final Logger logger = LoggerFactory.getLogger(HystrixExecutableBase.class);
    protected final HystrixCircuitBreaker circuitBreaker;
    protected final HystrixThreadPool threadPool;
    protected final HystrixThreadPoolKey threadPoolKey;
    protected final HystrixCommandProperties properties;
    protected final HystrixCommandMetrics metrics;
    protected final HystrixCommandKey commandKey;
    protected final HystrixCommandGroupKey commandGroup;
    protected final HystrixEventNotifier eventNotifier;
    protected final HystrixConcurrencyStrategy concurrencyStrategy;
    protected final HystrixCommandExecutionHook executionHook;
    protected final TryableSemaphore fallbackSemaphoreOverride;
    protected static final ConcurrentHashMap<String, TryableSemaphore> fallbackSemaphorePerCircuit = new ConcurrentHashMap();
    protected final TryableSemaphore executionSemaphoreOverride;
    protected static final ConcurrentHashMap<String, TryableSemaphore> executionSemaphorePerCircuit = new ConcurrentHashMap();
    protected final AtomicReference<Reference<HystrixTimer.TimerListener>> timeoutTimer = new AtomicReference();
    protected AtomicBoolean started = new AtomicBoolean();
    protected volatile long invocationStartTime = -1L;
    protected volatile ExecutionResult executionResult = ExecutionResult.access$000();
    protected final AtomicReference<TimedOutStatus> isCommandTimedOut = new AtomicReference<TimedOutStatus>(TimedOutStatus.NOT_EXECUTED);
    protected final AtomicBoolean isExecutionComplete = new AtomicBoolean(false);
    protected final AtomicBoolean isExecutedInThread = new AtomicBoolean(false);
    protected final HystrixRequestCache requestCache;
    protected final HystrixRequestLog currentRequestLog;
    private static ConcurrentHashMap<Class<?>, String> defaultNameCache = new ConcurrentHashMap();

    static String getDefaultNameFromClass(Class<?> cls) {
        String fromCache = defaultNameCache.get(cls);
        if (fromCache != null) {
            return fromCache;
        }
        String name = cls.getSimpleName();
        if (name.equals("")) {
            name = cls.getName();
            name = name.substring(name.lastIndexOf(46) + 1, name.length());
        }
        defaultNameCache.put(cls, name);
        return name;
    }

    protected HystrixExecutableBase(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, TryableSemaphore fallbackSemaphore, TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        if (group == null) {
            throw new IllegalStateException("HystrixCommandGroup can not be NULL");
        }
        this.commandGroup = group;
        if (key == null || key.name().trim().equals("")) {
            String keyName = HystrixExecutableBase.getDefaultNameFromClass(this.getClass());
            this.commandKey = HystrixCommandKey.Factory.asKey(keyName);
        } else {
            this.commandKey = key;
        }
        this.properties = propertiesStrategy == null ? HystrixPropertiesFactory.getCommandProperties(this.commandKey, commandPropertiesDefaults) : propertiesStrategy.getCommandProperties(this.commandKey, commandPropertiesDefaults);
        this.threadPoolKey = this.properties.executionIsolationThreadPoolKeyOverride().get() == null ? (threadPoolKey == null ? HystrixThreadPoolKey.Factory.asKey(this.commandGroup.name()) : threadPoolKey) : HystrixThreadPoolKey.Factory.asKey(this.properties.executionIsolationThreadPoolKeyOverride().get());
        this.eventNotifier = HystrixPlugins.getInstance().getEventNotifier();
        this.concurrencyStrategy = HystrixPlugins.getInstance().getConcurrencyStrategy();
        this.metrics = metrics == null ? HystrixCommandMetrics.getInstance(this.commandKey, this.commandGroup, this.properties) : metrics;
        this.circuitBreaker = this.properties.circuitBreakerEnabled().get().booleanValue() ? (circuitBreaker == null ? HystrixCircuitBreaker.Factory.getInstance(this.commandKey, this.commandGroup, this.properties, this.metrics) : circuitBreaker) : new HystrixCircuitBreaker.NoOpCircuitBreaker();
        HystrixMetricsPublisherFactory.createOrRetrievePublisherForCommand(this.commandKey, this.commandGroup, this.metrics, this.circuitBreaker, this.properties);
        this.executionHook = executionHook == null ? new ExecutionHookDeprecationWrapper(HystrixPlugins.getInstance().getCommandExecutionHook()) : (executionHook instanceof ExecutionHookDeprecationWrapper ? executionHook : new ExecutionHookDeprecationWrapper(executionHook));
        this.threadPool = threadPool == null ? HystrixThreadPool.Factory.getInstance(this.threadPoolKey, threadPoolPropertiesDefaults) : threadPool;
        this.fallbackSemaphoreOverride = fallbackSemaphore;
        this.executionSemaphoreOverride = executionSemaphore;
        this.requestCache = HystrixRequestCache.getInstance(this.commandKey, this.concurrencyStrategy);
        this.currentRequestLog = this.concurrencyStrategy instanceof HystrixConcurrencyStrategyDefault ? (HystrixRequestContext.isCurrentThreadInitialized() ? HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) : null) : (HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) != null ? HystrixRequestLog.getCurrentRequest(this.concurrencyStrategy) : null);
    }

    void markAsCollapsedCommand(int sizeOfBatch) {
        this.getMetrics().markCollapsed(sizeOfBatch);
        this.executionResult = this.executionResult.addEvents(HystrixEventType.COLLAPSED);
    }

    @Override
    public R execute() {
        try {
            return this.queue().get();
        }
        catch (Exception e) {
            throw this.decomposeException(e);
        }
    }

    @Override
    public Future<R> queue() {
        final ObservableCommand<R> o = this.toObservable(Schedulers.immediate(), false);
        final Future f = o.toBlockingObservable().toFuture();
        if (f.isDone()) {
            try {
                f.get();
                return f;
            }
            catch (Exception e) {
                RuntimeException re = this.decomposeException(e);
                if (re instanceof HystrixBadRequestException) {
                    return f;
                }
                if (re instanceof HystrixRuntimeException) {
                    HystrixRuntimeException hre = (HystrixRuntimeException)re;
                    if (hre.getFailureType() == HystrixRuntimeException.FailureType.COMMAND_EXCEPTION || hre.getFailureType() == HystrixRuntimeException.FailureType.TIMEOUT) {
                        return f;
                    }
                    throw hre;
                }
                throw re;
            }
        }
        return new Future<R>(){

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return f.cancel(mayInterruptIfRunning);
            }

            @Override
            public boolean isCancelled() {
                return f.isCancelled();
            }

            @Override
            public boolean isDone() {
                return f.isDone();
            }

            @Override
            public R get() throws InterruptedException, ExecutionException {
                return this.performBlockingGetWithTimeout(o, f);
            }

            protected R performBlockingGetWithTimeout(ObservableCommand<R> o2, Future<R> f2) throws InterruptedException, ExecutionException {
                Reference timer;
                if (f2.isDone()) {
                    return f2.get();
                }
                HystrixExecutableBase originalCommand = o2.getCommand();
                if (originalCommand != null && (timer = (Reference)originalCommand.timeoutTimer.getAndSet(null)) != null) {
                    long timeout;
                    HystrixTimer.TimerListener l = (HystrixTimer.TimerListener)timer.get();
                    timer.clear();
                    long timeRemaining = timeout = (long)originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue();
                    long currTime = System.currentTimeMillis();
                    if (originalCommand.invocationStartTime != -1L) {
                        timeRemaining = originalCommand.invocationStartTime + (long)originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get().intValue() - currTime;
                    }
                    if (timeRemaining > 0L) {
                        try {
                            return f2.get(timeRemaining, TimeUnit.MILLISECONDS);
                        }
                        catch (TimeoutException e) {
                            if (l != null) {
                                l.tick();
                            }
                        }
                    } else if (!f2.isDone() && l != null) {
                        l.tick();
                    }
                }
                return f2.get();
            }

            @Override
            public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.get();
            }
        };
    }

    @Override
    public Observable<R> observe() {
        ReplaySubject subject = ReplaySubject.create();
        this.toObservable().subscribe((Observer)subject);
        return subject;
    }

    public Observable<R> toObservable(Scheduler observeOn) {
        return this.toObservable(observeOn, true);
    }

    public abstract Observable<R> toObservable();

    protected abstract ObservableCommand<R> toObservable(Scheduler var1, boolean var2);

    protected TryableSemaphore getFallbackSemaphore() {
        if (this.fallbackSemaphoreOverride == null) {
            TryableSemaphore _s = fallbackSemaphorePerCircuit.get(this.commandKey.name());
            if (_s == null) {
                fallbackSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphoreActual(this.properties.fallbackIsolationSemaphoreMaxConcurrentRequests()));
                return fallbackSemaphorePerCircuit.get(this.commandKey.name());
            }
            return _s;
        }
        return this.fallbackSemaphoreOverride;
    }

    protected TryableSemaphore getExecutionSemaphore() {
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE)) {
            if (this.executionSemaphoreOverride == null) {
                TryableSemaphore _s = executionSemaphorePerCircuit.get(this.commandKey.name());
                if (_s == null) {
                    executionSemaphorePerCircuit.putIfAbsent(this.commandKey.name(), new TryableSemaphoreActual(this.properties.executionIsolationSemaphoreMaxConcurrentRequests()));
                    return executionSemaphorePerCircuit.get(this.commandKey.name());
                }
                return _s;
            }
            return this.executionSemaphoreOverride;
        }
        return TryableSemaphoreNoOp.DEFAULT;
    }

    @Override
    public HystrixCommandGroupKey getCommandGroup() {
        return this.commandGroup;
    }

    @Override
    public HystrixCommandKey getCommandKey() {
        return this.commandKey;
    }

    @Override
    public HystrixThreadPoolKey getThreadPoolKey() {
        return this.threadPoolKey;
    }

    HystrixCircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    @Override
    public HystrixCommandMetrics getMetrics() {
        return this.metrics;
    }

    @Override
    public HystrixCommandProperties getProperties() {
        return this.properties;
    }

    protected void recordTotalExecutionTime(long startTime) {
        long duration = System.currentTimeMillis() - startTime;
        this.metrics.addUserThreadExecutionTime(duration);
        this.executionResult = this.executionResult.setExecutionTime((int)duration);
    }

    protected void recordExecutedCommand() {
        if (this.properties.requestLogEnabled().get().booleanValue() && this.currentRequestLog != null) {
            this.currentRequestLog.addExecutedCommand(this);
        }
    }

    protected RuntimeException decomposeException(Exception e) {
        if (e instanceof IllegalStateException) {
            return (IllegalStateException)e;
        }
        if (e instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e;
        }
        if (e.getCause() instanceof HystrixBadRequestException) {
            return (HystrixBadRequestException)e.getCause();
        }
        if (e instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e;
        }
        if (e.getCause() instanceof HystrixRuntimeException) {
            return (HystrixRuntimeException)e.getCause();
        }
        String message = this.getLogMessagePrefix() + " failed while executing.";
        logger.debug(message, (Throwable)e);
        return new HystrixRuntimeException(HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, this.getClass(), message, e, null);
    }

    protected String getCacheKey() {
        return null;
    }

    protected boolean isRequestCachingEnabled() {
        return this.properties.requestCacheEnabled().get() != false && this.getCacheKey() != null;
    }

    protected String getLogMessagePrefix() {
        return this.getCommandKey().name();
    }

    @Override
    public boolean isCircuitBreakerOpen() {
        return this.circuitBreaker.isOpen();
    }

    @Override
    public boolean isExecutionComplete() {
        return this.isExecutionComplete.get();
    }

    @Override
    public boolean isExecutedInThread() {
        return this.isExecutedInThread.get();
    }

    @Override
    public boolean isSuccessfulExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.SUCCESS);
    }

    @Override
    public boolean isFailedExecution() {
        return this.executionResult.events.contains((Object)HystrixEventType.FAILURE);
    }

    @Override
    public Throwable getFailedExecutionException() {
        return this.executionResult.getException();
    }

    @Override
    public boolean isResponseFromFallback() {
        return this.executionResult.events.contains((Object)HystrixEventType.FALLBACK_SUCCESS);
    }

    @Override
    public boolean isResponseTimedOut() {
        return this.executionResult.events.contains((Object)HystrixEventType.TIMEOUT);
    }

    @Override
    public boolean isResponseShortCircuited() {
        return this.executionResult.events.contains((Object)HystrixEventType.SHORT_CIRCUITED);
    }

    @Override
    public boolean isResponseFromCache() {
        return this.executionResult.events.contains((Object)HystrixEventType.RESPONSE_FROM_CACHE);
    }

    @Override
    public boolean isResponseRejected() {
        return this.executionResult.events.contains((Object)HystrixEventType.THREAD_POOL_REJECTED) || this.executionResult.events.contains((Object)HystrixEventType.SEMAPHORE_REJECTED);
    }

    @Override
    public List<HystrixEventType> getExecutionEvents() {
        return this.executionResult.events;
    }

    @Override
    public int getExecutionTimeInMilliseconds() {
        return this.executionResult.getExecutionTime();
    }

    protected Exception getExceptionFromThrowable(Throwable t) {
        Exception e = null;
        e = t instanceof Exception ? (Exception)t : new Exception("Throwable caught while executing.", t);
        return e;
    }

    private static class ExecutionHookDeprecationWrapper
    extends HystrixCommandExecutionHook {
        private final HystrixCommandExecutionHook actual;

        ExecutionHookDeprecationWrapper(HystrixCommandExecutionHook actual) {
            this.actual = actual;
        }

        @Override
        @Deprecated
        public <T> void onRunStart(HystrixCommand<T> commandInstance) {
            this.actual.onRunStart(commandInstance);
        }

        @Override
        public <T> void onRunStart(HystrixExecutable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onRunStart(c);
            }
            this.actual.onRunStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onRunSuccess(HystrixCommand<T> commandInstance, T response) {
            return this.actual.onRunSuccess(commandInstance, response);
        }

        @Override
        public <T> T onRunSuccess(HystrixExecutable<T> commandInstance, T response) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                response = this.onRunSuccess(c, response);
            }
            return this.actual.onRunSuccess(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> Exception onRunError(HystrixCommand<T> commandInstance, Exception e) {
            return this.actual.onRunError(commandInstance, e);
        }

        @Override
        public <T> Exception onRunError(HystrixExecutable<T> commandInstance, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onRunError(c, e);
            }
            return this.actual.onRunError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> void onFallbackStart(HystrixCommand<T> commandInstance) {
            this.actual.onFallbackStart(commandInstance);
        }

        @Override
        public <T> void onFallbackStart(HystrixExecutable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onFallbackStart(c);
            }
            this.actual.onFallbackStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onFallbackSuccess(HystrixCommand<T> commandInstance, T fallbackResponse) {
            return this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
        }

        @Override
        public <T> T onFallbackSuccess(HystrixExecutable<T> commandInstance, T fallbackResponse) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                fallbackResponse = this.onFallbackSuccess(c, fallbackResponse);
            }
            return this.actual.onFallbackSuccess(commandInstance, fallbackResponse);
        }

        @Override
        @Deprecated
        public <T> Exception onFallbackError(HystrixCommand<T> commandInstance, Exception e) {
            return this.actual.onFallbackError(commandInstance, e);
        }

        @Override
        public <T> Exception onFallbackError(HystrixExecutable<T> commandInstance, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onFallbackError(c, e);
            }
            return this.actual.onFallbackError(commandInstance, e);
        }

        @Override
        @Deprecated
        public <T> void onStart(HystrixCommand<T> commandInstance) {
            this.actual.onStart(commandInstance);
        }

        @Override
        public <T> void onStart(HystrixExecutable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onStart(c);
            }
            this.actual.onStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> T onComplete(HystrixCommand<T> commandInstance, T response) {
            return this.actual.onComplete(commandInstance, response);
        }

        @Override
        public <T> T onComplete(HystrixExecutable<T> commandInstance, T response) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                response = this.onComplete(c, response);
            }
            return this.actual.onComplete(commandInstance, response);
        }

        @Override
        @Deprecated
        public <T> Exception onError(HystrixCommand<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
            return this.actual.onError(commandInstance, failureType, e);
        }

        @Override
        public <T> Exception onError(HystrixExecutable<T> commandInstance, HystrixRuntimeException.FailureType failureType, Exception e) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                e = this.onError(c, failureType, e);
            }
            return this.actual.onError(commandInstance, failureType, e);
        }

        @Override
        @Deprecated
        public <T> void onThreadStart(HystrixCommand<T> commandInstance) {
            this.actual.onThreadStart(commandInstance);
        }

        @Override
        public <T> void onThreadStart(HystrixExecutable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onThreadStart(c);
            }
            this.actual.onThreadStart(commandInstance);
        }

        @Override
        @Deprecated
        public <T> void onThreadComplete(HystrixCommand<T> commandInstance) {
            this.actual.onThreadComplete(commandInstance);
        }

        @Override
        public <T> void onThreadComplete(HystrixExecutable<T> commandInstance) {
            HystrixCommand<T> c = this.getHystrixCommandFromAbstractIfApplicable(commandInstance);
            if (c != null) {
                this.onThreadComplete(c);
            }
            this.actual.onThreadComplete(commandInstance);
        }

        private <T> HystrixCommand<T> getHystrixCommandFromAbstractIfApplicable(HystrixExecutable<T> commandInstance) {
            if (commandInstance instanceof HystrixCommand.HystrixCommandFromObservableCommand) {
                return ((HystrixCommand.HystrixCommandFromObservableCommand)commandInstance).getOriginal();
            }
            return null;
        }
    }

    protected static class ExecutionResult {
        protected final List<HystrixEventType> events;
        private final int executionTime;
        private final Exception exception;
        private static ExecutionResult EMPTY = new ExecutionResult(new HystrixEventType[0]);

        private ExecutionResult(HystrixEventType ... events) {
            this(Arrays.asList(events), -1, null);
        }

        public ExecutionResult setExecutionTime(int executionTime) {
            return new ExecutionResult(this.events, executionTime, this.exception);
        }

        public ExecutionResult setException(Exception e) {
            return new ExecutionResult(this.events, this.executionTime, e);
        }

        private ExecutionResult(List<HystrixEventType> events, int executionTime, Exception e) {
            this.events = events;
            this.executionTime = executionTime;
            this.exception = e;
        }

        public ExecutionResult addEvents(HystrixEventType ... events) {
            ArrayList<HystrixEventType> newEvents = new ArrayList<HystrixEventType>();
            newEvents.addAll(this.events);
            for (HystrixEventType e : events) {
                newEvents.add(e);
            }
            return new ExecutionResult(Collections.unmodifiableList(newEvents), this.executionTime, this.exception);
        }

        public int getExecutionTime() {
            return this.executionTime;
        }

        public Exception getException() {
            return this.exception;
        }

        static /* synthetic */ ExecutionResult access$000() {
            return EMPTY;
        }
    }

    static interface TryableSemaphore {
        public boolean tryAcquire();

        public void release();

        public int getNumberOfPermitsUsed();
    }

    static class TryableSemaphoreNoOp
    implements TryableSemaphore {
        public static final TryableSemaphore DEFAULT = new TryableSemaphoreNoOp();

        TryableSemaphoreNoOp() {
        }

        @Override
        public boolean tryAcquire() {
            return true;
        }

        @Override
        public void release() {
        }

        @Override
        public int getNumberOfPermitsUsed() {
            return 0;
        }
    }

    static class TryableSemaphoreActual
    implements TryableSemaphore {
        protected final HystrixProperty<Integer> numberOfPermits;
        private final AtomicInteger count = new AtomicInteger(0);

        public TryableSemaphoreActual(HystrixProperty<Integer> numberOfPermits) {
            this.numberOfPermits = numberOfPermits;
        }

        @Override
        public boolean tryAcquire() {
            int currentCount = this.count.incrementAndGet();
            if (currentCount > this.numberOfPermits.get()) {
                this.count.decrementAndGet();
                return false;
            }
            return true;
        }

        @Override
        public void release() {
            this.count.decrementAndGet();
        }

        @Override
        public int getNumberOfPermitsUsed() {
            return this.count.get();
        }
    }

    protected static class CachedObservableResponse<R>
    extends ObservableCommand<R> {
        final CachedObservableOriginal<R> originalObservable;

        CachedObservableResponse(final CachedObservableOriginal<R> originalObservable, final HystrixExecutableBase<R> commandOfDuplicateCall) {
            super(new Observable.OnSubscribe<R>(){

                public void call(final Subscriber<? super R> observer) {
                    originalObservable.subscribe(new Subscriber<R>(){

                        public void onCompleted() {
                            this.completeCommand();
                            observer.onCompleted();
                        }

                        public void onError(Throwable e) {
                            this.completeCommand();
                            observer.onError(e);
                        }

                        public void onNext(R v) {
                            observer.onNext(v);
                        }

                        private void completeCommand() {
                            commandOfDuplicateCall.executionResult = originalObservable.originalCommand.executionResult;
                            commandOfDuplicateCall.executionResult = commandOfDuplicateCall.executionResult.addEvents(HystrixEventType.RESPONSE_FROM_CACHE);
                            commandOfDuplicateCall.executionResult = commandOfDuplicateCall.executionResult.setExecutionTime(-1);
                            commandOfDuplicateCall.recordExecutedCommand();
                        }
                    });
                }
            }, commandOfDuplicateCall);
            this.originalObservable = originalObservable;
        }

        @Override
        public HystrixExecutableBase<R> getCommand() {
            return this.originalObservable.originalCommand;
        }
    }

    protected static class CachedObservableOriginal<R>
    extends ObservableCommand<R> {
        final HystrixExecutableBase<R> originalCommand;

        CachedObservableOriginal(final Observable<R> actual, HystrixExecutableBase<R> command) {
            super(new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> observer) {
                    actual.unsafeSubscribe(observer);
                }
            }, command);
            this.originalCommand = command;
        }
    }

    protected static class ObservableCommand<R>
    extends Observable<R> {
        private final HystrixExecutableBase<R> command;

        ObservableCommand(Observable.OnSubscribe<R> func, HystrixExecutableBase<R> command) {
            super(func);
            this.command = command;
        }

        public HystrixExecutableBase<R> getCommand() {
            return this.command;
        }

        ObservableCommand(final Observable<R> originalObservable, HystrixExecutableBase<R> command) {
            super(new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> observer) {
                    originalObservable.unsafeSubscribe(observer);
                }
            });
            this.command = command;
        }
    }

    protected static enum TimedOutStatus {
        NOT_EXECUTED,
        COMPLETED,
        TIMED_OUT;

    }
}

