/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.Hystrix;
import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixEventType;
import com.netflix.hystrix.HystrixExecutable;
import com.netflix.hystrix.HystrixExecutableBase;
import com.netflix.hystrix.HystrixExecutableInfo;
import com.netflix.hystrix.HystrixThreadPool;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.exception.HystrixBadRequestException;
import com.netflix.hystrix.exception.HystrixRuntimeException;
import com.netflix.hystrix.strategy.concurrency.HystrixContextRunnable;
import com.netflix.hystrix.strategy.concurrency.HystrixContextScheduler;
import com.netflix.hystrix.strategy.concurrency.HystrixRequestContext;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.util.HystrixTimer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.NotThreadSafe;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Notification;
import rx.Observable;
import rx.Scheduler;
import rx.Subscriber;
import rx.Subscription;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Func1;
import rx.schedulers.Schedulers;
import rx.subscriptions.CompositeSubscription;

@ThreadSafe
public abstract class HystrixObservableCommand<R>
extends HystrixExecutableBase<R>
implements HystrixExecutable<R>,
HystrixExecutableInfo<R> {
    private static final Logger logger = LoggerFactory.getLogger(HystrixObservableCommand.class);

    protected HystrixObservableCommand(HystrixCommandGroupKey group) {
        this(new Setter(group));
    }

    protected HystrixObservableCommand(Setter setter) {
        this(setter.groupKey, setter.commandKey, setter.threadPoolKey, null, null, setter.commandPropertiesDefaults, setter.threadPoolPropertiesDefaults, null, null, null, null, null);
    }

    HystrixObservableCommand(HystrixCommandGroupKey group, HystrixCommandKey key, HystrixThreadPoolKey threadPoolKey, HystrixCircuitBreaker circuitBreaker, HystrixThreadPool threadPool, HystrixCommandProperties.Setter commandPropertiesDefaults, HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults, HystrixCommandMetrics metrics, HystrixExecutableBase.TryableSemaphore fallbackSemaphore, HystrixExecutableBase.TryableSemaphore executionSemaphore, HystrixPropertiesStrategy propertiesStrategy, HystrixCommandExecutionHook executionHook) {
        super(group, key, threadPoolKey, circuitBreaker, threadPool, commandPropertiesDefaults, threadPoolPropertiesDefaults, metrics, fallbackSemaphore, executionSemaphore, propertiesStrategy, executionHook);
    }

    protected abstract Observable<R> run();

    protected Observable<R> getFallback() {
        return Observable.error((Throwable)new UnsupportedOperationException("No fallback available."));
    }

    @Override
    public Observable<R> toObservable() {
        return this.toObservable(Schedulers.immediate());
    }

    @Override
    protected HystrixExecutableBase.ObservableCommand<R> toObservable(final Scheduler observeOn, boolean performAsyncTimeout) {
        Observable fromCache;
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("This instance can only be executed once. Please instantiate a new instance.");
        }
        if (this.isRequestCachingEnabled() && (fromCache = this.requestCache.get(this.getCacheKey())) != null) {
            this.metrics.markResponseFromCache();
            return new HystrixExecutableBase.CachedObservableResponse((HystrixExecutableBase.CachedObservableOriginal)fromCache, this);
        }
        final HystrixObservableCommand _this = this;
        final AtomicReference endCurrentThreadExecutingCommand = new AtomicReference();
        HystrixExecutableBase.ObservableCommand o = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

            public void call(Subscriber<? super R> observer) {
                HystrixObservableCommand.this.recordExecutedCommand();
                HystrixObservableCommand.this.executionHook.onStart(_this);
                if (HystrixObservableCommand.this.circuitBreaker.allowRequest()) {
                    final HystrixExecutableBase.TryableSemaphore executionSemaphore = HystrixObservableCommand.this.getExecutionSemaphore();
                    if (executionSemaphore.tryAcquire()) {
                        try {
                            HystrixObservableCommand.this.invocationStartTime = System.currentTimeMillis();
                            endCurrentThreadExecutingCommand.set(Hystrix.startCurrentThreadExecutingCommand(HystrixObservableCommand.this.getCommandKey()));
                            HystrixObservableCommand.this.getRunObservableDecoratedForMetricsAndErrorHandling(observeOn).doOnTerminate(new Action0(){

                                public void call() {
                                    executionSemaphore.release();
                                }
                            }).unsafeSubscribe(observer);
                        }
                        catch (RuntimeException e) {
                            observer.onError((Throwable)e);
                        }
                    } else {
                        HystrixObservableCommand.this.metrics.markSemaphoreRejection();
                        logger.debug("HystrixCommand Execution Rejection by Semaphore.");
                        HystrixObservableCommand.this.getFallbackOrThrowException(HystrixEventType.SEMAPHORE_REJECTED, HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_EXECUTION, "could not acquire a semaphore for execution").unsafeSubscribe(observer);
                    }
                } else {
                    HystrixObservableCommand.this.metrics.markShortCircuited();
                    try {
                        HystrixObservableCommand.this.getFallbackOrThrowException(HystrixEventType.SHORT_CIRCUITED, HystrixRuntimeException.FailureType.SHORTCIRCUIT, "short-circuited").unsafeSubscribe(observer);
                    }
                    catch (Exception e) {
                        observer.onError((Throwable)e);
                    }
                }
            }
        });
        o = o.lift(new HystrixObservableTimeoutOperator(_this, performAsyncTimeout));
        o = o.onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

            public Observable<R> call(Throwable t) {
                HystrixObservableCommand.this.metrics.markExceptionThrown();
                return Observable.error((Throwable)t);
            }
        });
        o = o.doOnTerminate(new Action0(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void call() {
                Reference tl = (Reference)HystrixObservableCommand.this.timeoutTimer.get();
                if (tl != null) {
                    tl.clear();
                }
                try {
                    if (HystrixObservableCommand.this.invocationStartTime > 0L && !HystrixObservableCommand.this.isResponseRejected()) {
                        HystrixObservableCommand.this.recordTotalExecutionTime(HystrixObservableCommand.this.invocationStartTime);
                    }
                    if (endCurrentThreadExecutingCommand.get() != null) {
                        ((Action0)endCurrentThreadExecutingCommand.get()).call();
                    }
                }
                finally {
                    HystrixObservableCommand.this.metrics.decrementConcurrentExecutionCount();
                    HystrixObservableCommand.this.isExecutionComplete.set(true);
                }
            }
        });
        if (this.isRequestCachingEnabled()) {
            o = new HystrixExecutableBase.CachedObservableOriginal(o.cache(), this);
            Observable fromCache2 = this.requestCache.putIfAbsent(this.getCacheKey(), o);
            if (fromCache2 != null) {
                o = new HystrixExecutableBase.CachedObservableResponse((HystrixExecutableBase.CachedObservableOriginal)fromCache2, this);
            }
            return o;
        }
        return new HystrixExecutableBase.ObservableCommand(o, this);
    }

    private Observable<R> getRunObservableDecoratedForMetricsAndErrorHandling(Scheduler observeOn) {
        final HystrixObservableCommand _cmd = this;
        final HystrixObservableCommand _self = this;
        this.metrics.incrementConcurrentExecutionCount();
        final HystrixRequestContext currentRequestContext = HystrixRequestContext.getContextForCurrentThread();
        Observable run = null;
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD)) {
            this.isExecutedInThread.set(true);
            run = Observable.create((Observable.OnSubscribe)new Observable.OnSubscribe<R>(){

                public void call(Subscriber<? super R> s) {
                    HystrixObservableCommand.this.executionHook.onRunStart(_self);
                    HystrixObservableCommand.this.executionHook.onThreadStart(_self);
                    if (HystrixObservableCommand.this.isCommandTimedOut.get() == HystrixExecutableBase.TimedOutStatus.TIMED_OUT) {
                        s.onError((Throwable)new RuntimeException("timed out before executing run()"));
                    } else {
                        try {
                            final Action0 endCurrentThread = Hystrix.startCurrentThreadExecutingCommand(HystrixObservableCommand.this.getCommandKey());
                            HystrixObservableCommand.this.run().doOnTerminate(new Action0(){

                                public void call() {
                                    HystrixObservableCommand.this.executionHook.onThreadComplete(_self);
                                    endCurrentThread.call();
                                }
                            }).unsafeSubscribe(s);
                        }
                        catch (Throwable t) {
                            Observable.error((Throwable)t).unsafeSubscribe(s);
                        }
                    }
                }
            }).subscribeOn(this.threadPool.getScheduler());
        } else {
            this.executionHook.onRunStart(_self);
            try {
                run = this.run();
            }
            catch (Throwable t) {
                run = Observable.error((Throwable)t);
            }
        }
        run = run.doOnEach(new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> n) {
                HystrixObservableCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        }).map(new Func1<R, R>(){

            public R call(R t1) {
                return HystrixObservableCommand.this.executionHook.onRunSuccess(_cmd, t1);
            }
        }).doOnCompleted(new Action0(){

            public void call() {
                if (HystrixObservableCommand.this.isCommandTimedOut.get() != HystrixExecutableBase.TimedOutStatus.TIMED_OUT) {
                    long duration = System.currentTimeMillis() - HystrixObservableCommand.this.invocationStartTime;
                    HystrixObservableCommand.this.metrics.addCommandExecutionTime(duration);
                    HystrixObservableCommand.this.executionResult = HystrixObservableCommand.this.executionResult.addEvents(HystrixEventType.SUCCESS);
                    HystrixObservableCommand.this.metrics.markSuccess(duration);
                    HystrixObservableCommand.this.circuitBreaker.markSuccess();
                    HystrixObservableCommand.this.eventNotifier.markCommandExecution(HystrixObservableCommand.this.getCommandKey(), HystrixObservableCommand.this.properties.executionIsolationStrategy().get(), (int)duration, HystrixObservableCommand.this.executionResult.events);
                }
            }
        }).onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

            public Observable<R> call(Throwable t) {
                Exception e = HystrixObservableCommand.this.getExceptionFromThrowable(t);
                if (e instanceof RejectedExecutionException) {
                    HystrixObservableCommand.this.metrics.markThreadPoolRejection();
                    return HystrixObservableCommand.this.getFallbackOrThrowException(HystrixEventType.THREAD_POOL_REJECTED, HystrixRuntimeException.FailureType.REJECTED_THREAD_EXECUTION, "could not be queued for execution", e);
                }
                if (t instanceof HystrixBadRequestException) {
                    try {
                        Exception decorated = HystrixObservableCommand.this.executionHook.onRunError(_self, (Exception)t);
                        if (decorated instanceof HystrixBadRequestException) {
                            t = (HystrixBadRequestException)decorated;
                        } else {
                            logger.warn("ExecutionHook.onRunError returned an exception that was not an instance of HystrixBadRequestException so will be ignored.", (Throwable)decorated);
                        }
                    }
                    catch (Exception hookException) {
                        logger.warn("Error calling ExecutionHook.onRunError", (Throwable)hookException);
                    }
                    return Observable.error((Throwable)t);
                }
                try {
                    e = HystrixObservableCommand.this.executionHook.onRunError(_self, e);
                }
                catch (Exception hookException) {
                    logger.warn("Error calling ExecutionHook.endRunFailure", (Throwable)hookException);
                }
                if (HystrixObservableCommand.this.isCommandTimedOut.get() == HystrixExecutableBase.TimedOutStatus.TIMED_OUT) {
                    logger.debug("Error executing HystrixCommand.run() [TimedOut]. Proceeding to fallback logic ...", (Throwable)e);
                    return Observable.empty();
                }
                logger.debug("Error executing HystrixCommand.run(). Proceeding to fallback logic ...", (Throwable)e);
                HystrixObservableCommand.this.metrics.markFailure(System.currentTimeMillis() - HystrixObservableCommand.this.invocationStartTime);
                HystrixObservableCommand.this.executionResult = HystrixObservableCommand.this.executionResult.setException(e);
                return HystrixObservableCommand.this.getFallbackOrThrowException(HystrixEventType.FAILURE, HystrixRuntimeException.FailureType.COMMAND_EXCEPTION, "failed", e);
            }
        }).doOnEach(new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> n) {
                HystrixObservableCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        }).map(new Func1<R, R>(){

            public R call(R t1) {
                return HystrixObservableCommand.this.executionHook.onComplete(_cmd, t1);
            }
        });
        if (this.properties.executionIsolationStrategy().get().equals((Object)HystrixCommandProperties.ExecutionIsolationStrategy.THREAD) && !Schedulers.immediate().equals(observeOn)) {
            run = run.observeOn((Scheduler)new HystrixContextScheduler(this.concurrencyStrategy, observeOn));
        }
        return run;
    }

    private Observable<R> getFallbackWithProtection() {
        final HystrixExecutableBase.TryableSemaphore fallbackSemaphore = this.getFallbackSemaphore();
        if (fallbackSemaphore.tryAcquire()) {
            this.executionHook.onFallbackStart(this);
            final HystrixObservableCommand _cmd = this;
            Observable fallback = null;
            try {
                fallback = this.getFallback();
            }
            catch (Throwable t) {
                fallback = Observable.error((Throwable)t);
            }
            return fallback.map(new Func1<R, R>(){

                public R call(R t1) {
                    return HystrixObservableCommand.this.executionHook.onFallbackSuccess(_cmd, t1);
                }
            }).onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

                public Observable<R> call(Throwable t) {
                    Exception e = HystrixObservableCommand.this.getExceptionFromThrowable(t);
                    Exception decorated = HystrixObservableCommand.this.executionHook.onFallbackError(_cmd, e);
                    if (decorated instanceof RuntimeException) {
                        e = (RuntimeException)decorated;
                    } else {
                        logger.warn("ExecutionHook.onFallbackError returned an exception that was not an instance of RuntimeException so will be ignored.", (Throwable)decorated);
                    }
                    return Observable.error((Throwable)e);
                }
            }).doOnTerminate(new Action0(){

                public void call() {
                    fallbackSemaphore.release();
                }
            });
        }
        this.metrics.markFallbackRejection();
        logger.debug("HystrixCommand Fallback Rejection.");
        return Observable.error((Throwable)new HystrixRuntimeException(HystrixRuntimeException.FailureType.REJECTED_SEMAPHORE_FALLBACK, this.getClass(), this.getLogMessagePrefix() + " fallback execution rejected.", null, null));
    }

    private Observable<R> getFallbackOrThrowException(HystrixEventType eventType, HystrixRuntimeException.FailureType failureType, String message) {
        return this.getFallbackOrThrowException(eventType, failureType, message, null);
    }

    private Observable<R> getFallbackOrThrowException(HystrixEventType eventType, final HystrixRuntimeException.FailureType failureType, final String message, final Exception originalException) {
        final HystrixRequestContext currentRequestContext = HystrixRequestContext.getContextForCurrentThread();
        if (this.properties.fallbackEnabled().get().booleanValue()) {
            this.executionResult = this.executionResult.addEvents(eventType);
            final HystrixObservableCommand _cmd = this;
            return this.getFallbackWithProtection().map(new Func1<R, R>(){

                public R call(R t1) {
                    return HystrixObservableCommand.this.executionHook.onComplete(_cmd, t1);
                }
            }).doOnCompleted(new Action0(){

                public void call() {
                    HystrixObservableCommand.this.metrics.markFallbackSuccess();
                    HystrixObservableCommand.this.executionResult = HystrixObservableCommand.this.executionResult.addEvents(HystrixEventType.FALLBACK_SUCCESS);
                }
            }).onErrorResumeNext(new Func1<Throwable, Observable<R>>(){

                public Observable<R> call(Throwable t) {
                    Exception e = originalException;
                    Exception fe = HystrixObservableCommand.this.getExceptionFromThrowable(t);
                    if (fe instanceof UnsupportedOperationException) {
                        logger.debug("No fallback for HystrixCommand. ", (Throwable)fe);
                        try {
                            e = HystrixObservableCommand.this.executionHook.onError(_cmd, failureType, e);
                        }
                        catch (Exception hookException) {
                            logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
                        }
                        return Observable.error((Throwable)new HystrixRuntimeException(failureType, _cmd.getClass(), HystrixObservableCommand.this.getLogMessagePrefix() + " " + message + " and no fallback available.", e, (Throwable)fe));
                    }
                    logger.debug("HystrixCommand execution " + failureType.name() + " and fallback retrieval failed.", (Throwable)fe);
                    HystrixObservableCommand.this.metrics.markFallbackFailure();
                    HystrixObservableCommand.this.executionResult = HystrixObservableCommand.this.executionResult.addEvents(HystrixEventType.FALLBACK_FAILURE);
                    try {
                        e = HystrixObservableCommand.this.executionHook.onError(_cmd, failureType, e);
                    }
                    catch (Exception hookException) {
                        logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
                    }
                    return Observable.error((Throwable)new HystrixRuntimeException(failureType, _cmd.getClass(), HystrixObservableCommand.this.getLogMessagePrefix() + " " + message + " and failed retrieving fallback.", e, (Throwable)fe));
                }
            }).doOnTerminate(new Action0(){

                public void call() {
                    HystrixObservableCommand.this.isExecutionComplete.set(true);
                }
            }).doOnEach(new Action1<Notification<? super R>>(){

                public void call(Notification<? super R> n) {
                    HystrixObservableCommand.setRequestContextIfNeeded(currentRequestContext);
                }
            });
        }
        Exception e = originalException;
        logger.debug("Fallback disabled for HystrixCommand so will throw HystrixRuntimeException. ", (Throwable)e);
        this.executionResult = this.executionResult.addEvents(eventType);
        try {
            e = this.executionHook.onError(this, failureType, e);
        }
        catch (Exception hookException) {
            logger.warn("Error calling ExecutionHook.onError", (Throwable)hookException);
        }
        return Observable.error((Throwable)new HystrixRuntimeException(failureType, this.getClass(), this.getLogMessagePrefix() + " " + message + " and fallback disabled.", e, null)).doOnTerminate(new Action0(){

            public void call() {
                HystrixObservableCommand.this.isExecutionComplete.set(true);
            }
        }).doOnEach(new Action1<Notification<? super R>>(){

            public void call(Notification<? super R> n) {
                HystrixObservableCommand.setRequestContextIfNeeded(currentRequestContext);
            }
        });
    }

    private static void setRequestContextIfNeeded(HystrixRequestContext currentRequestContext) {
        if (!HystrixRequestContext.isCurrentThreadInitialized()) {
            HystrixRequestContext.setContextOnCurrentThread(currentRequestContext);
        }
    }

    private static class HystrixObservableTimeoutOperator<R>
    implements Observable.Operator<R, R> {
        final HystrixObservableCommand<R> originalCommand;
        final boolean isNonBlocking;

        public HystrixObservableTimeoutOperator(HystrixObservableCommand<R> originalCommand, boolean isNonBlocking) {
            this.originalCommand = originalCommand;
            this.isNonBlocking = isNonBlocking;
        }

        public Subscriber<? super R> call(final Subscriber<? super R> child) {
            final CompositeSubscription s = new CompositeSubscription();
            child.add((Subscription)s);
            final HystrixContextRunnable timeoutRunnable = new HystrixContextRunnable(this.originalCommand.concurrencyStrategy, new Runnable(){

                @Override
                public void run() {
                    try {
                        Observable v = HystrixObservableTimeoutOperator.this.originalCommand.getFallbackOrThrowException(HystrixEventType.TIMEOUT, HystrixRuntimeException.FailureType.TIMEOUT, "timed-out", new TimeoutException());
                        v.subscribeOn((Scheduler)new HystrixContextScheduler(HystrixObservableTimeoutOperator.this.originalCommand.concurrencyStrategy, Schedulers.computation())).unsafeSubscribe(child);
                    }
                    catch (HystrixRuntimeException re) {
                        child.onError((Throwable)re);
                    }
                }
            });
            HystrixTimer.TimerListener listener = new HystrixTimer.TimerListener(){

                @Override
                public void tick() {
                    if (HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(HystrixExecutableBase.TimedOutStatus.NOT_EXECUTED, HystrixExecutableBase.TimedOutStatus.TIMED_OUT)) {
                        HystrixObservableTimeoutOperator.this.originalCommand.metrics.markTimeout(System.currentTimeMillis() - HystrixObservableTimeoutOperator.this.originalCommand.invocationStartTime);
                        HystrixObservableTimeoutOperator.this.originalCommand.recordTotalExecutionTime(HystrixObservableTimeoutOperator.this.originalCommand.invocationStartTime);
                        timeoutRunnable.run();
                    }
                    s.unsubscribe();
                }

                @Override
                public int getIntervalTimeInMilliseconds() {
                    return HystrixObservableTimeoutOperator.this.originalCommand.properties.executionIsolationThreadTimeoutInMilliseconds().get();
                }
            };
            Reference<HystrixTimer.TimerListener> _tl = null;
            _tl = this.isNonBlocking ? HystrixTimer.getInstance().addTimerListener(listener) : new SoftReference<2>(listener);
            final Reference<HystrixTimer.TimerListener> tl = _tl;
            this.originalCommand.timeoutTimer.set(tl);
            return new Subscriber<R>(s){

                public void onCompleted() {
                    if (HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(HystrixExecutableBase.TimedOutStatus.NOT_EXECUTED, HystrixExecutableBase.TimedOutStatus.COMPLETED)) {
                        tl.clear();
                        child.onCompleted();
                    }
                }

                public void onError(Throwable e) {
                    if (HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.compareAndSet(HystrixExecutableBase.TimedOutStatus.NOT_EXECUTED, HystrixExecutableBase.TimedOutStatus.COMPLETED)) {
                        tl.clear();
                        child.onError(e);
                    }
                }

                public void onNext(R v) {
                    if (((HystrixExecutableBase.TimedOutStatus)((Object)HystrixObservableTimeoutOperator.this.originalCommand.isCommandTimedOut.get())).equals((Object)HystrixExecutableBase.TimedOutStatus.NOT_EXECUTED)) {
                        child.onNext(v);
                    }
                }
            };
        }
    }

    @NotThreadSafe
    public static class Setter {
        protected final HystrixCommandGroupKey groupKey;
        protected HystrixCommandKey commandKey;
        protected HystrixThreadPoolKey threadPoolKey;
        protected HystrixCommandProperties.Setter commandPropertiesDefaults;
        protected HystrixThreadPoolProperties.Setter threadPoolPropertiesDefaults;

        protected Setter(HystrixCommandGroupKey groupKey) {
            this.groupKey = groupKey;
            this.commandPropertiesDefaults = this.setDefaults(HystrixCommandProperties.Setter());
        }

        public static Setter withGroupKey(HystrixCommandGroupKey groupKey) {
            return new Setter(groupKey);
        }

        public Setter andCommandKey(HystrixCommandKey commandKey) {
            this.commandKey = commandKey;
            return this;
        }

        public Setter andCommandPropertiesDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            this.commandPropertiesDefaults = this.setDefaults(commandPropertiesDefaults);
            return this;
        }

        private HystrixCommandProperties.Setter setDefaults(HystrixCommandProperties.Setter commandPropertiesDefaults) {
            if (commandPropertiesDefaults.getExecutionIsolationStrategy() == null) {
                commandPropertiesDefaults.withExecutionIsolationStrategy(HystrixCommandProperties.ExecutionIsolationStrategy.SEMAPHORE);
            }
            return commandPropertiesDefaults;
        }
    }
}

