/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.collapser;

import com.netflix.hystrix.HystrixCollapser;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscriber;
import rx.Subscription;
import rx.subscriptions.BooleanSubscription;

class CollapsedRequestObservableFunction<T, R>
implements HystrixCollapser.CollapsedRequest<T, R>,
Observable.OnSubscribe<T> {
    private final R argument;
    private final AtomicReference<ResponseHolder<T>> rh = new AtomicReference(new ResponseHolder());
    private final BooleanSubscription subscription = new BooleanSubscription();

    public CollapsedRequestObservableFunction(R arg) {
        this.argument = arg;
    }

    @Override
    public R getArgument() {
        return this.argument;
    }

    @Override
    public void setResponse(T response) {
        ResponseHolder<T> nr;
        ResponseHolder<T> r;
        do {
            if ((r = this.rh.get()).isResponseSet()) {
                throw new IllegalStateException("setResponse can only be called once");
            }
            if (r.getException() != null) {
                throw new IllegalStateException("Exception is already set so response can not be => Response: " + response + " subscription: " + this.subscription.isUnsubscribed() + "  observer: " + r.getObserver() + "  Exception: " + r.getException().getMessage(), r.getException());
            }
            if (!this.subscription.isUnsubscribed()) continue;
            return;
        } while (!this.rh.compareAndSet(r, nr = r.setResponse(response)));
        CollapsedRequestObservableFunction.sendResponseIfRequired(this.subscription, nr);
    }

    public void setExceptionIfResponseNotReceived(Exception e) {
        block2: {
            ResponseHolder<T> nr;
            ResponseHolder<T> r;
            do {
                if (this.subscription.isUnsubscribed()) {
                    return;
                }
                r = this.rh.get();
                if (r.isResponseSet() || r.getException() != null) break block2;
            } while (!this.rh.compareAndSet(r, nr = r.setException(e)));
            CollapsedRequestObservableFunction.sendResponseIfRequired(this.subscription, nr);
        }
    }

    @Override
    public void setException(Exception e) {
        ResponseHolder<T> nr;
        ResponseHolder<T> r;
        do {
            if ((r = this.rh.get()).getException() != null) {
                throw new IllegalStateException("setException can only be called once");
            }
            if (r.isResponseSet()) {
                throw new IllegalStateException("Response is already set so exception can not be => Response: " + r.getResponse() + "  Exception: " + e.getMessage(), e);
            }
            if (!this.subscription.isUnsubscribed()) continue;
            return;
        } while (!this.rh.compareAndSet(r, nr = r.setException(e)));
        CollapsedRequestObservableFunction.sendResponseIfRequired(this.subscription, nr);
    }

    public void call(Subscriber<? super T> observer) {
        ResponseHolder<? super T> nr;
        ResponseHolder<? super T> r;
        observer.add((Subscription)this.subscription);
        do {
            if ((r = this.rh.get()).getObserver() == null) continue;
            throw new IllegalStateException("Only 1 Observer can subscribe. Use multicast/publish/cache/etc for multiple subscribers.");
        } while (!this.rh.compareAndSet(r, nr = r.setObserver((Observer<? super T>)observer)));
        CollapsedRequestObservableFunction.sendResponseIfRequired(this.subscription, nr);
    }

    private static <T> void sendResponseIfRequired(BooleanSubscription subscription, ResponseHolder<T> r) {
        if (!subscription.isUnsubscribed()) {
            Observer<T> o = r.getObserver();
            if (o == null || r.getException() == null && !r.isResponseSet()) {
                return;
            }
            if (r.getException() != null) {
                o.onError((Throwable)r.getException());
            } else {
                o.onNext(r.getResponse());
                o.onCompleted();
            }
        }
    }

    private static class ResponseHolder<T> {
        private final AtomicReference<T> r;
        private final Exception e;
        private final Observer<? super T> o;

        public ResponseHolder() {
            this(null, null, null);
        }

        private ResponseHolder(AtomicReference<T> response, Exception exception, Observer<? super T> observer) {
            this.o = observer;
            this.r = response;
            this.e = exception;
        }

        public ResponseHolder<T> setResponse(T response) {
            return new ResponseHolder<T>(new AtomicReference<T>(response), this.e, this.o);
        }

        public ResponseHolder<T> setObserver(Observer<? super T> observer) {
            return new ResponseHolder<T>(this.r, this.e, observer);
        }

        public ResponseHolder<T> setException(Exception exception) {
            return new ResponseHolder<T>(this.r, exception, this.o);
        }

        public Observer<? super T> getObserver() {
            return this.o;
        }

        public T getResponse() {
            if (this.r == null) {
                return null;
            }
            return this.r.get();
        }

        public boolean isResponseSet() {
            return this.r != null;
        }

        public Exception getException() {
            return this.e;
        }
    }
}

