/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.metrics;

import com.netflix.hystrix.HystrixCircuitBreaker;
import com.netflix.hystrix.HystrixCommandGroupKey;
import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandMetrics;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherCommand;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;
import java.util.concurrent.ConcurrentHashMap;

public class HystrixMetricsPublisherFactory {
    private static HystrixMetricsPublisherFactory SINGLETON = new HystrixMetricsPublisherFactory();
    private final HystrixMetricsPublisher strategy;
    private final ConcurrentHashMap<String, HystrixMetricsPublisherCommand> commandPublishers = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, HystrixMetricsPublisherThreadPool> threadPoolPublishers = new ConcurrentHashMap();

    public static HystrixMetricsPublisherThreadPool createOrRetrievePublisherForThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        return SINGLETON.getPublisherForThreadPool(threadPoolKey, metrics, properties);
    }

    public static HystrixMetricsPublisherCommand createOrRetrievePublisherForCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandOwner, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        return SINGLETON.getPublisherForCommand(commandKey, commandOwner, metrics, circuitBreaker, properties);
    }

    private HystrixMetricsPublisherFactory() {
        this(HystrixPlugins.getInstance().getMetricsPublisher());
    }

    HystrixMetricsPublisherFactory(HystrixMetricsPublisher strategy) {
        this.strategy = strategy;
    }

    HystrixMetricsPublisherCommand getPublisherForCommand(HystrixCommandKey commandKey, HystrixCommandGroupKey commandOwner, HystrixCommandMetrics metrics, HystrixCircuitBreaker circuitBreaker, HystrixCommandProperties properties) {
        HystrixMetricsPublisherCommand publisher = this.commandPublishers.get(commandKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = this.strategy.getMetricsPublisherForCommand(commandKey, commandOwner, metrics, circuitBreaker, properties);
        HystrixMetricsPublisherCommand existing = this.commandPublishers.putIfAbsent(commandKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }

    HystrixMetricsPublisherThreadPool getPublisherForThreadPool(HystrixThreadPoolKey threadPoolKey, HystrixThreadPoolMetrics metrics, HystrixThreadPoolProperties properties) {
        HystrixMetricsPublisherThreadPool publisher = this.threadPoolPublishers.get(threadPoolKey.name());
        if (publisher != null) {
            return publisher;
        }
        publisher = this.strategy.getMetricsPublisherForThreadPool(threadPoolKey, metrics, properties);
        HystrixMetricsPublisherThreadPool existing = this.threadPoolPublishers.putIfAbsent(threadPoolKey.name(), publisher);
        if (existing == null) {
            publisher.initialize();
            return publisher;
        }
        return existing;
    }
}

