/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import java.util.Arrays;
import java.util.HashSet;

public class ExceptionThreadingUtility {
    private static final String messageForCause = "Calling Thread included as the last 'caused by' on the chain.";
    private static ThreadLocal<Thread> callingThreadCache = new ThreadLocal();

    static void attachCallingThreadStack(Throwable e, StackTraceElement[] stack) {
        HashSet<Throwable> seenCauses = new HashSet<Throwable>();
        Throwable callingThrowable = new Throwable(messageForCause);
        if (stack[0].toString().startsWith("java.lang.Thread.getStackTrace")) {
            StackTraceElement[] newStack = Arrays.copyOfRange(stack, 1, stack.length);
            stack = newStack;
        }
        callingThrowable.setStackTrace(stack);
        while (e.getCause() != null && !seenCauses.contains(e = e.getCause())) {
            seenCauses.add(e);
        }
        if (!messageForCause.equals(e.getMessage())) {
            try {
                e.initCause(callingThrowable);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
    }

    private static String getStackTraceAsString(StackTraceElement[] stack) {
        StringBuilder s = new StringBuilder();
        boolean firstLine = true;
        for (StackTraceElement e : stack) {
            if (e.toString().startsWith("java.lang.Thread.getStackTrace")) continue;
            if (!firstLine) {
                s.append("\n\t");
            }
            s.append(e.toString());
            firstLine = false;
        }
        return s.toString();
    }

    public static void attachCallingThreadStack(Throwable e) {
        try {
            if (callingThreadCache.get() != null) {
                ExceptionThreadingUtility.attachCallingThreadStack(e, callingThreadCache.get().getStackTrace());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void assignCallingThread(Thread callingThread) {
        callingThreadCache.set(callingThread);
    }
}

