/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import com.netflix.hystrix.strategy.properties.HystrixProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.HdrHistogram.AbstractHistogram;
import org.HdrHistogram.IntCountsHistogram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixRollingPercentile {
    private static final Logger logger = LoggerFactory.getLogger(HystrixRollingPercentile.class);
    private static final Time ACTUAL_TIME = new ActualTime();
    private final Time time;
    final BucketCircularArray buckets;
    private final HystrixProperty<Integer> timeInMilliseconds;
    private final HystrixProperty<Integer> numberOfBuckets;
    private final HystrixProperty<Boolean> enabled;
    volatile PercentileSnapshot currentPercentileSnapshot = new PercentileSnapshot();
    private ReentrantLock newBucketLock = new ReentrantLock();

    public HystrixRollingPercentile(HystrixProperty<Integer> timeInMilliseconds, HystrixProperty<Integer> numberOfBuckets, HystrixProperty<Boolean> enabled) {
        this(ACTUAL_TIME, timeInMilliseconds, numberOfBuckets, enabled);
    }

    @Deprecated
    public HystrixRollingPercentile(HystrixProperty<Integer> timeInMilliseconds, HystrixProperty<Integer> numberOfBuckets, HystrixProperty<Integer> bucketDataLength, HystrixProperty<Boolean> enabled) {
        this(ACTUAL_TIME, timeInMilliseconds, numberOfBuckets, enabled);
    }

    HystrixRollingPercentile(Time time, HystrixProperty<Integer> timeInMilliseconds, HystrixProperty<Integer> numberOfBuckets, HystrixProperty<Boolean> enabled) {
        this.time = time;
        this.timeInMilliseconds = timeInMilliseconds;
        this.numberOfBuckets = numberOfBuckets;
        this.enabled = enabled;
        if (this.timeInMilliseconds.get() % this.numberOfBuckets.get() != 0) {
            throw new IllegalArgumentException("The timeInMilliseconds must divide equally into numberOfBuckets. For example 1000/10 is ok, 1000/11 is not.");
        }
        this.buckets = new BucketCircularArray(this.numberOfBuckets.get());
    }

    public void addValue(int ... value) {
        if (!this.enabled.get().booleanValue()) {
            return;
        }
        for (int v : value) {
            try {
                this.getCurrentBucket().bucketData.addValue(v);
            }
            catch (Exception e) {
                logger.error("Failed to add value: " + v, (Throwable)e);
            }
        }
    }

    public int getPercentile(double percentile) {
        if (!this.enabled.get().booleanValue()) {
            return -1;
        }
        this.getCurrentBucket();
        return this.getCurrentPercentileSnapshot().getPercentile(percentile);
    }

    public int getMean() {
        if (!this.enabled.get().booleanValue()) {
            return -1;
        }
        this.getCurrentBucket();
        return this.getCurrentPercentileSnapshot().getMean();
    }

    private PercentileSnapshot getCurrentPercentileSnapshot() {
        return this.currentPercentileSnapshot;
    }

    private int getBucketSizeInMilliseconds() {
        return this.timeInMilliseconds.get() / this.numberOfBuckets.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bucket getCurrentBucket() {
        long currentTime = this.time.getCurrentTimeInMillis();
        Bucket currentBucket = this.buckets.peekLast();
        if (currentBucket != null && currentTime < currentBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) {
            return currentBucket;
        }
        if (this.newBucketLock.tryLock()) {
            try {
                if (this.buckets.peekLast() == null) {
                    Bucket newBucket = new Bucket(currentTime);
                    this.buckets.addLast(newBucket);
                    Bucket bucket = newBucket;
                    return bucket;
                }
                for (int i = 0; i < this.numberOfBuckets.get(); ++i) {
                    Bucket bucket;
                    Bucket lastBucket = this.buckets.peekLast();
                    if (currentTime < lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) {
                        bucket = lastBucket;
                        return bucket;
                    }
                    if (currentTime - (lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()) > (long)this.timeInMilliseconds.get().intValue()) {
                        this.reset();
                        bucket = this.getCurrentBucket();
                        return bucket;
                    }
                    Bucket[] allBuckets = this.buckets.getArray();
                    this.buckets.addLast(new Bucket(lastBucket.windowStart + (long)this.getBucketSizeInMilliseconds()));
                    this.currentPercentileSnapshot = new PercentileSnapshot(allBuckets);
                }
                Bucket i = this.buckets.peekLast();
                return i;
            }
            finally {
                this.newBucketLock.unlock();
            }
        }
        currentBucket = this.buckets.peekLast();
        if (currentBucket != null) {
            return currentBucket;
        }
        try {
            Thread.sleep(5L);
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.getCurrentBucket();
    }

    public void reset() {
        if (!this.enabled.get().booleanValue()) {
            return;
        }
        this.buckets.clear();
    }

    private static class ActualTime
    implements Time {
        private ActualTime() {
        }

        @Override
        public long getCurrentTimeInMillis() {
            return System.currentTimeMillis();
        }
    }

    static interface Time {
        public long getCurrentTimeInMillis();
    }

    static class Bucket {
        final long windowStart;
        final PercentileBucketData bucketData;

        Bucket(long startTime) {
            this.windowStart = startTime;
            this.bucketData = new PercentileBucketData();
        }

        public Bucket(long startTime, int[] data) {
            this.windowStart = startTime;
            this.bucketData = new PercentileBucketData();
            this.bucketData.addValue(data);
        }
    }

    class BucketCircularArray
    implements Iterable<Bucket> {
        private final AtomicReference<ListState> state;
        private final int dataLength;
        private final int numBuckets;

        BucketCircularArray(int size) {
            AtomicReferenceArray _buckets = new AtomicReferenceArray(size + 1);
            this.state = new AtomicReference<ListState>(new ListState(_buckets, 0, 0));
            this.dataLength = _buckets.length();
            this.numBuckets = size;
        }

        public void clear() {
            ListState newState;
            ListState current;
            while (!this.state.compareAndSet(current = this.state.get(), newState = current.clear())) {
            }
        }

        @Override
        public Iterator<Bucket> iterator() {
            return Collections.unmodifiableList(Arrays.asList(this.getArray())).iterator();
        }

        public void addLast(Bucket o) {
            ListState newState;
            ListState currentState = this.state.get();
            if (this.state.compareAndSet(currentState, newState = currentState.addBucket(o))) {
                return;
            }
        }

        public int size() {
            return this.state.get().size;
        }

        public Bucket peekLast() {
            return this.state.get().tail();
        }

        private Bucket[] getArray() {
            return this.state.get().getArray();
        }

        private class ListState {
            private final AtomicReferenceArray<Bucket> data;
            private final int size;
            private final int tail;
            private final int head;

            private ListState(AtomicReferenceArray<Bucket> data, int head, int tail) {
                this.head = head;
                this.tail = tail;
                this.size = head == 0 && tail == 0 ? 0 : (tail + BucketCircularArray.this.dataLength - head) % BucketCircularArray.this.dataLength;
                this.data = data;
            }

            public Bucket tail() {
                if (this.size == 0) {
                    return null;
                }
                return this.data.get(this.convert(this.size - 1));
            }

            private Bucket[] getArray() {
                ArrayList<Bucket> array = new ArrayList<Bucket>();
                for (int i = 0; i < this.size; ++i) {
                    array.add(this.data.get(this.convert(i)));
                }
                return array.toArray(new Bucket[array.size()]);
            }

            private ListState incrementTail() {
                if (this.size == BucketCircularArray.this.numBuckets) {
                    return new ListState(this.data, (this.head + 1) % BucketCircularArray.this.dataLength, (this.tail + 1) % BucketCircularArray.this.dataLength);
                }
                return new ListState(this.data, this.head, (this.tail + 1) % BucketCircularArray.this.dataLength);
            }

            public ListState clear() {
                return new ListState(new AtomicReferenceArray<Bucket>(BucketCircularArray.this.dataLength), 0, 0);
            }

            public ListState addBucket(Bucket b) {
                this.data.set(this.tail, b);
                return this.incrementTail();
            }

            private int convert(int index) {
                return (index + this.head) % BucketCircularArray.this.dataLength;
            }
        }
    }

    static class PercentileSnapshot {
        private final IntCountsHistogram aggregateHistogram = new IntCountsHistogram(4);
        private final long count;
        private final int mean;
        private final int p0;
        private final int p5;
        private final int p10;
        private final int p25;
        private final int p50;
        private final int p75;
        private final int p90;
        private final int p95;
        private final int p99;
        private final int p995;
        private final int p999;
        private final int p100;

        PercentileSnapshot() {
            this(new Bucket[0]);
        }

        PercentileSnapshot(long startTime, int ... data) {
            this(new Bucket[]{new Bucket(startTime, data)});
        }

        PercentileSnapshot(Bucket[] buckets) {
            for (Bucket bucket : buckets) {
                this.aggregateHistogram.add((AbstractHistogram)bucket.bucketData.histogram);
            }
            this.count = this.aggregateHistogram.getTotalCount();
            this.mean = (int)this.aggregateHistogram.getMean();
            this.p0 = (int)this.aggregateHistogram.getValueAtPercentile(0.0);
            this.p5 = (int)this.aggregateHistogram.getValueAtPercentile(5.0);
            this.p10 = (int)this.aggregateHistogram.getValueAtPercentile(10.0);
            this.p25 = (int)this.aggregateHistogram.getValueAtPercentile(25.0);
            this.p50 = (int)this.aggregateHistogram.getValueAtPercentile(50.0);
            this.p75 = (int)this.aggregateHistogram.getValueAtPercentile(75.0);
            this.p90 = (int)this.aggregateHistogram.getValueAtPercentile(90.0);
            this.p95 = (int)this.aggregateHistogram.getValueAtPercentile(95.0);
            this.p99 = (int)this.aggregateHistogram.getValueAtPercentile(99.0);
            this.p995 = (int)this.aggregateHistogram.getValueAtPercentile(99.5);
            this.p999 = (int)this.aggregateHistogram.getValueAtPercentile(99.9);
            this.p100 = (int)this.aggregateHistogram.getValueAtPercentile(100.0);
        }

        int getMean() {
            return this.mean;
        }

        public int getPercentile(double percentile) {
            if (this.count == 0L) {
                return 0;
            }
            int permyriad = (int)(percentile * 100.0);
            switch (permyriad) {
                case 0: {
                    return this.p0;
                }
                case 500: {
                    return this.p5;
                }
                case 1000: {
                    return this.p10;
                }
                case 2500: {
                    return this.p25;
                }
                case 5000: {
                    return this.p50;
                }
                case 7500: {
                    return this.p75;
                }
                case 9000: {
                    return this.p90;
                }
                case 9500: {
                    return this.p95;
                }
                case 9900: {
                    return this.p99;
                }
                case 9950: {
                    return this.p995;
                }
                case 9990: {
                    return this.p999;
                }
                case 10000: {
                    return this.p100;
                }
            }
            return this.getArbitraryPercentile(percentile);
        }

        private synchronized int getArbitraryPercentile(double percentile) {
            return (int)this.aggregateHistogram.getValueAtPercentile(percentile);
        }
    }

    private static class PercentileBucketData {
        private final IntCountsHistogram histogram = new IntCountsHistogram(4);

        public void addValue(int ... latency) {
            for (int l : latency) {
                this.histogram.recordValue((long)l);
            }
        }

        public int length() {
            return (int)this.histogram.getTotalCount();
        }
    }
}

