/*
 * Decompiled with CFR 0.152.
 */
package rx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import rx.Notification;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.observables.BlockingObservable;
import rx.observables.ConnectableObservable;
import rx.observables.GroupedObservable;
import rx.operators.OperationAll;
import rx.operators.OperationAny;
import rx.operators.OperationAverage;
import rx.operators.OperationBuffer;
import rx.operators.OperationCache;
import rx.operators.OperationCombineLatest;
import rx.operators.OperationConcat;
import rx.operators.OperationDebounce;
import rx.operators.OperationDefer;
import rx.operators.OperationDematerialize;
import rx.operators.OperationDistinct;
import rx.operators.OperationDistinctUntilChanged;
import rx.operators.OperationElementAt;
import rx.operators.OperationFilter;
import rx.operators.OperationFinally;
import rx.operators.OperationFirstOrDefault;
import rx.operators.OperationGroupBy;
import rx.operators.OperationInterval;
import rx.operators.OperationMap;
import rx.operators.OperationMaterialize;
import rx.operators.OperationMerge;
import rx.operators.OperationMergeDelayError;
import rx.operators.OperationMulticast;
import rx.operators.OperationObserveOn;
import rx.operators.OperationOnErrorResumeNextViaFunction;
import rx.operators.OperationOnErrorResumeNextViaObservable;
import rx.operators.OperationOnErrorReturn;
import rx.operators.OperationOnExceptionResumeNextViaObservable;
import rx.operators.OperationParallel;
import rx.operators.OperationRetry;
import rx.operators.OperationSample;
import rx.operators.OperationScan;
import rx.operators.OperationSkip;
import rx.operators.OperationSkipWhile;
import rx.operators.OperationSubscribeOn;
import rx.operators.OperationSum;
import rx.operators.OperationSwitch;
import rx.operators.OperationSynchronize;
import rx.operators.OperationTake;
import rx.operators.OperationTakeLast;
import rx.operators.OperationTakeUntil;
import rx.operators.OperationTakeWhile;
import rx.operators.OperationThrottleFirst;
import rx.operators.OperationTimestamp;
import rx.operators.OperationToObservableFuture;
import rx.operators.OperationToObservableIterable;
import rx.operators.OperationToObservableList;
import rx.operators.OperationToObservableSortedList;
import rx.operators.OperationWindow;
import rx.operators.OperationZip;
import rx.operators.SafeObservableSubscription;
import rx.operators.SafeObserver;
import rx.plugins.RxJavaObservableExecutionHook;
import rx.plugins.RxJavaPlugins;
import rx.subjects.PublishSubject;
import rx.subjects.ReplaySubject;
import rx.subjects.Subject;
import rx.subscriptions.Subscriptions;
import rx.util.Closing;
import rx.util.OnErrorNotImplementedException;
import rx.util.Opening;
import rx.util.Range;
import rx.util.Timestamped;
import rx.util.functions.Action0;
import rx.util.functions.Action1;
import rx.util.functions.Func0;
import rx.util.functions.Func1;
import rx.util.functions.Func2;
import rx.util.functions.Func3;
import rx.util.functions.Func4;
import rx.util.functions.Func5;
import rx.util.functions.Func6;
import rx.util.functions.Func7;
import rx.util.functions.Func8;
import rx.util.functions.Func9;
import rx.util.functions.FuncN;
import rx.util.functions.Function;
import rx.util.functions.Functions;

public class Observable<T> {
    private final OnSubscribeFunc<T> onSubscribe;
    private static final RxJavaObservableExecutionHook hook = RxJavaPlugins.getInstance().getObservableExecutionHook();

    protected Observable(OnSubscribeFunc<T> onSubscribe) {
        this.onSubscribe = onSubscribe;
    }

    public Subscription subscribe(Observer<? super T> observer) {
        OnSubscribeFunc<Object> onSubscribeFunction = hook.onSubscribeStart(this, this.onSubscribe);
        if (observer == null) {
            throw new IllegalArgumentException("observer can not be null");
        }
        if (onSubscribeFunction == null) {
            throw new IllegalStateException("onSubscribe function can not be null.");
        }
        try {
            if (this.isInternalImplementation(observer)) {
                Subscription s = onSubscribeFunction.onSubscribe(observer);
                if (s == null) {
                    return hook.onSubscribeReturn(this, Subscriptions.empty());
                }
                return hook.onSubscribeReturn(this, s);
            }
            SafeObservableSubscription subscription = new SafeObservableSubscription();
            subscription.wrap(onSubscribeFunction.onSubscribe(new SafeObserver<T>(subscription, observer)));
            return hook.onSubscribeReturn(this, subscription);
        }
        catch (OnErrorNotImplementedException e) {
            throw e;
        }
        catch (Throwable e) {
            try {
                observer.onError(hook.onSubscribeError(this, e));
            }
            catch (OnErrorNotImplementedException e2) {
                throw e2;
            }
            catch (Throwable e2) {
                RuntimeException r = new RuntimeException("Error occurred attempting to subscribe [" + e.getMessage() + "] and then again while trying to pass to onError.", e2);
                hook.onSubscribeError(this, r);
                throw r;
            }
            return Subscriptions.empty();
        }
    }

    public Subscription subscribe(Observer<? super T> observer, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(observer);
    }

    private Subscription protectivelyWrapAndSubscribe(Observer<? super T> o) {
        SafeObservableSubscription subscription = new SafeObservableSubscription();
        return subscription.wrap(this.subscribe(new SafeObserver<T>(subscription, o)));
    }

    public Subscription subscribe(final Action1<? super T> onNext) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                Observable.this.handleError(e);
                throw new OnErrorNotImplementedException(e);
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public Subscription subscribe(Action1<? super T> onNext, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext);
    }

    public Subscription subscribe(final Action1<? super T> onNext, final Action1<Throwable> onError) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
            }

            @Override
            public void onError(Throwable e) {
                Observable.this.handleError(e);
                onError.call(e);
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext, onError);
    }

    public Subscription subscribe(final Action1<? super T> onNext, final Action1<Throwable> onError, final Action0 onComplete) {
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onComplete == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        return this.protectivelyWrapAndSubscribe(new Observer<T>(){

            @Override
            public void onCompleted() {
                onComplete.call();
            }

            @Override
            public void onError(Throwable e) {
                Observable.this.handleError(e);
                onError.call(e);
            }

            @Override
            public void onNext(T args) {
                onNext.call(args);
            }
        });
    }

    public Subscription subscribe(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onComplete, Scheduler scheduler) {
        return this.subscribeOn(scheduler).subscribe(onNext, onError, onComplete);
    }

    public <R> ConnectableObservable<R> multicast(Subject<? super T, ? extends R> subject) {
        return OperationMulticast.multicast(this, subject);
    }

    private void handleError(Throwable e) {
        RxJavaPlugins.getInstance().getErrorHandler().handleError(e);
    }

    public static <T> Observable<T> create(OnSubscribeFunc<T> func) {
        return new Observable<T>(func);
    }

    public static <T> Observable<T> empty() {
        return Observable.from(new ArrayList());
    }

    public static <T> Observable<T> error(Throwable exception) {
        return new ThrowObservable(exception);
    }

    public static <T> Observable<T> from(Iterable<? extends T> iterable) {
        return Observable.create(OperationToObservableIterable.toObservableIterable(iterable));
    }

    public static <T> Observable<T> from(T[] items) {
        return Observable.create(OperationToObservableIterable.toObservableIterable(Arrays.asList(items)));
    }

    public static <T> Observable<T> from(T t1) {
        return Observable.from(Arrays.asList(t1));
    }

    public static <T> Observable<T> from(T t1, T t2) {
        return Observable.from(Arrays.asList(t1, t2));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3) {
        return Observable.from(Arrays.asList(t1, t2, t3));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> from(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9, T t10) {
        return Observable.from(Arrays.asList(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10));
    }

    public static Observable<Integer> range(int start, int count) {
        return Observable.from(Range.createWithCount(start, count));
    }

    public static <T> Observable<T> defer(Func0<? extends Observable<? extends T>> observableFactory) {
        return Observable.create(OperationDefer.defer(observableFactory));
    }

    public static <T> Observable<T> just(T value) {
        ArrayList<T> list = new ArrayList<T>();
        list.add(value);
        return Observable.from(list);
    }

    public static <T> Observable<T> merge(Observable<? extends Observable<? extends T>> source) {
        return Observable.create(OperationMerge.merge(source));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationMerge.merge(t1, t2));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationMerge.merge(t1, t2, t3));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationMerge.merge(t1, t2, t3, t4));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationMerge.merge(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationMerge.merge(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationMerge.merge(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationMerge.merge(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> merge(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationMerge.merge(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> concat(Observable<? extends Observable<? extends T>> observables) {
        return Observable.create(OperationConcat.concat(observables));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationConcat.concat(t1, t2));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationConcat.concat(t1, t2, t3));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> concat(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationConcat.concat(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends Observable<? extends T>> source) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(source));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7, t8));
    }

    public static <T> Observable<T> mergeDelayError(Observable<? extends T> t1, Observable<? extends T> t2, Observable<? extends T> t3, Observable<? extends T> t4, Observable<? extends T> t5, Observable<? extends T> t6, Observable<? extends T> t7, Observable<? extends T> t8, Observable<? extends T> t9) {
        return Observable.create(OperationMergeDelayError.mergeDelayError(t1, t2, t3, t4, t5, t6, t7, t8, t9));
    }

    public static <T> Observable<T> never() {
        return new NeverObservable();
    }

    @Deprecated
    public static <T> Observable<T> switchDo(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public static <T> Observable<T> switchOnNext(Observable<? extends Observable<? extends T>> sequenceOfSequences) {
        return Observable.create(OperationSwitch.switchDo(sequenceOfSequences));
    }

    public Observable<T> synchronize() {
        return Observable.create(OperationSynchronize.synchronize(this));
    }

    @Deprecated
    public static <T> Observable<T> synchronize(Observable<T> source) {
        return Observable.create(OperationSynchronize.synchronize(source));
    }

    public static Observable<Long> interval(long interval, TimeUnit unit) {
        return Observable.create(OperationInterval.interval(interval, unit));
    }

    public static Observable<Long> interval(long interval, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationInterval.interval(interval, unit, scheduler));
    }

    public Observable<T> debounce(long timeout, TimeUnit unit) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit));
    }

    public Observable<T> debounce(long timeout, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit, scheduler));
    }

    public Observable<T> throttleWithTimeout(long timeout, TimeUnit unit) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit));
    }

    public Observable<T> throttleWithTimeout(long timeout, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationDebounce.debounce(this, timeout, unit, scheduler));
    }

    public Observable<T> throttleFirst(long windowDuration, TimeUnit unit) {
        return Observable.create(OperationThrottleFirst.throttleFirst(this, windowDuration, unit));
    }

    public Observable<T> throttleFirst(long skipDuration, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationThrottleFirst.throttleFirst(this, skipDuration, unit, scheduler));
    }

    public Observable<T> throttleLast(long intervalDuration, TimeUnit unit) {
        return this.sample(intervalDuration, unit);
    }

    public Observable<T> throttleLast(long intervalDuration, TimeUnit unit, Scheduler scheduler) {
        return this.sample(intervalDuration, unit, scheduler);
    }

    public Observable<Timestamped<T>> timestamp() {
        return Observable.create(OperationTimestamp.timestamp(this));
    }

    public static <T> Observable<T> from(Future<? extends T> future) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future));
    }

    public static <T> Observable<T> from(Future<? extends T> future, Scheduler scheduler) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future)).subscribeOn(scheduler);
    }

    public static <T> Observable<T> from(Future<? extends T> future, long timeout, TimeUnit unit) {
        return Observable.create(OperationToObservableFuture.toObservableFuture(future, timeout, unit));
    }

    public static <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second) {
        return Observable.sequenceEqual(first, second, new Func2<T, T, Boolean>(){

            @Override
            public Boolean call(T first, T second) {
                return first.equals(second);
            }
        });
    }

    public static <T> Observable<Boolean> sequenceEqual(Observable<? extends T> first, Observable<? extends T> second, Func2<? super T, ? super T, Boolean> equality) {
        return Observable.zip(first, second, equality);
    }

    public static <T1, T2, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, zipFunction));
    }

    public static <T1, T2, T3, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, zipFunction));
    }

    public static <T1, T2, T3, T4, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, o7, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, o7, o8, zipFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> zip(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(o1, o2, o3, o4, o5, o6, o7, o8, o9, zipFunction));
    }

    public static <T1, T2, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Func2<? super T1, ? super T2, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, combineFunction));
    }

    public static <T1, T2, T3, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Func3<? super T1, ? super T2, ? super T3, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, combineFunction));
    }

    public static <T1, T2, T3, T4, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Func4<? super T1, ? super T2, ? super T3, ? super T4, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Func5<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Func6<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Func7<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Func8<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, o8, combineFunction));
    }

    public static <T1, T2, T3, T4, T5, T6, T7, T8, T9, R> Observable<R> combineLatest(Observable<? extends T1> o1, Observable<? extends T2> o2, Observable<? extends T3> o3, Observable<? extends T4> o4, Observable<? extends T5> o5, Observable<? extends T6> o6, Observable<? extends T7> o7, Observable<? extends T8> o8, Observable<? extends T9> o9, Func9<? super T1, ? super T2, ? super T3, ? super T4, ? super T5, ? super T6, ? super T7, ? super T8, ? super T9, ? extends R> combineFunction) {
        return Observable.create(OperationCombineLatest.combineLatest(o1, o2, o3, o4, o5, o6, o7, o8, o9, combineFunction));
    }

    public Observable<List<T>> buffer(Func0<? extends Observable<? extends Closing>> bufferClosingSelector) {
        return Observable.create(OperationBuffer.buffer(this, bufferClosingSelector));
    }

    public Observable<List<T>> buffer(Observable<? extends Opening> bufferOpenings, Func1<Opening, ? extends Observable<? extends Closing>> bufferClosingSelector) {
        return Observable.create(OperationBuffer.buffer(this, bufferOpenings, bufferClosingSelector));
    }

    public Observable<List<T>> buffer(int count) {
        return Observable.create(OperationBuffer.buffer(this, count));
    }

    public Observable<List<T>> buffer(int count, int skip) {
        return Observable.create(OperationBuffer.buffer(this, count, skip));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, scheduler));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit, int count) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, count));
    }

    public Observable<List<T>> buffer(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, unit, count, scheduler));
    }

    public Observable<List<T>> buffer(long timespan, long timeshift, TimeUnit unit) {
        return Observable.create(OperationBuffer.buffer(this, timespan, timeshift, unit));
    }

    public Observable<List<T>> buffer(long timespan, long timeshift, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationBuffer.buffer(this, timespan, timeshift, unit, scheduler));
    }

    public Observable<Observable<T>> window(Func0<? extends Observable<? extends Closing>> closingSelector) {
        return Observable.create(OperationWindow.window(this, closingSelector));
    }

    public Observable<Observable<T>> window(Observable<? extends Opening> windowOpenings, Func1<Opening, ? extends Observable<? extends Closing>> closingSelector) {
        return Observable.create(OperationWindow.window(this, windowOpenings, closingSelector));
    }

    public Observable<Observable<T>> window(int count) {
        return Observable.create(OperationWindow.window(this, count));
    }

    public Observable<Observable<T>> window(int count, int skip) {
        return Observable.create(OperationWindow.window(this, count, skip));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit) {
        return Observable.create(OperationWindow.window(this, timespan, unit));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, unit, scheduler));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit, int count) {
        return Observable.create(OperationWindow.window(this, timespan, unit, count));
    }

    public Observable<Observable<T>> window(long timespan, TimeUnit unit, int count, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, unit, count, scheduler));
    }

    public Observable<Observable<T>> window(long timespan, long timeshift, TimeUnit unit) {
        return Observable.create(OperationWindow.window(this, timespan, timeshift, unit));
    }

    public Observable<Observable<T>> window(long timespan, long timeshift, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationWindow.window(this, timespan, timeshift, unit, scheduler));
    }

    public static <R> Observable<R> zip(Observable<? extends Observable<?>> ws, final FuncN<? extends R> zipFunction) {
        return ws.toList().mapMany(new Func1<List<? extends Observable<?>>, Observable<? extends R>>(){

            @Override
            public Observable<R> call(List<? extends Observable<?>> wsList) {
                return Observable.create(OperationZip.zip(wsList, zipFunction));
            }
        });
    }

    public static <R> Observable<R> zip(Iterable<? extends Observable<?>> ws, FuncN<? extends R> zipFunction) {
        return Observable.create(OperationZip.zip(ws, zipFunction));
    }

    public Observable<T> filter(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationFilter.filter(this, predicate));
    }

    public Observable<T> distinctUntilChanged() {
        return Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(this));
    }

    public <U> Observable<T> distinctUntilChanged(Func1<? super T, ? extends U> keySelector) {
        return Observable.create(OperationDistinctUntilChanged.distinctUntilChanged(this, keySelector));
    }

    public Observable<T> distinct() {
        return Observable.create(OperationDistinct.distinct(this));
    }

    public <U> Observable<T> distinct(Func1<? super T, ? extends U> keySelector) {
        return Observable.create(OperationDistinct.distinct(this, keySelector));
    }

    public Observable<T> elementAt(int index) {
        return Observable.create(OperationElementAt.elementAt(this, index));
    }

    public Observable<T> elementAtOrDefault(int index, T defaultValue) {
        return Observable.create(OperationElementAt.elementAtOrDefault(this, index, defaultValue));
    }

    public Observable<Boolean> exists(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationAny.exists(this, predicate));
    }

    public Observable<T> finallyDo(Action0 action) {
        return Observable.create(OperationFinally.finallyDo(this, action));
    }

    public <R> Observable<R> flatMap(Func1<? super T, ? extends Observable<? extends R>> func) {
        return this.mapMany(func);
    }

    public Observable<T> where(Func1<? super T, Boolean> predicate) {
        return this.filter(predicate);
    }

    public <R> Observable<R> map(Func1<? super T, ? extends R> func) {
        return Observable.create(OperationMap.map(this, func));
    }

    public <R> Observable<R> mapWithIndex(Func2<? super T, Integer, ? extends R> func) {
        return Observable.create(OperationMap.mapWithIndex(this, func));
    }

    public <R> Observable<R> mapMany(Func1<? super T, ? extends Observable<? extends R>> func) {
        return Observable.create(OperationMap.mapMany(this, func));
    }

    public Observable<Notification<T>> materialize() {
        return Observable.create(OperationMaterialize.materialize(this));
    }

    public Observable<T> subscribeOn(Scheduler scheduler) {
        return Observable.create(OperationSubscribeOn.subscribeOn(this, scheduler));
    }

    public Observable<T> observeOn(Scheduler scheduler) {
        return Observable.create(OperationObserveOn.observeOn(this, scheduler));
    }

    public <T2> Observable<T2> dematerialize() {
        return Observable.create(OperationDematerialize.dematerialize(this));
    }

    public Observable<T> onErrorResumeNext(Func1<Throwable, ? extends Observable<? extends T>> resumeFunction) {
        return Observable.create(OperationOnErrorResumeNextViaFunction.onErrorResumeNextViaFunction(this, resumeFunction));
    }

    public Observable<T> onErrorResumeNext(Observable<? extends T> resumeSequence) {
        return Observable.create(OperationOnErrorResumeNextViaObservable.onErrorResumeNextViaObservable(this, resumeSequence));
    }

    public Observable<T> onExceptionResumeNext(Observable<? extends T> resumeSequence) {
        return Observable.create(OperationOnExceptionResumeNextViaObservable.onExceptionResumeNextViaObservable(this, resumeSequence));
    }

    public Observable<T> onErrorReturn(Func1<Throwable, ? extends T> resumeFunction) {
        return Observable.create(OperationOnErrorReturn.onErrorReturn(this, resumeFunction));
    }

    public Observable<T> reduce(Func2<T, T, T> accumulator) {
        return Observable.create(OperationScan.scan(this, accumulator)).takeLast(1);
    }

    public Observable<Integer> count() {
        return this.reduce(0, new Func2<Integer, T, Integer>(){

            @Override
            public Integer call(Integer t1, T t2) {
                return t1 + 1;
            }
        });
    }

    public static Observable<Integer> sum(Observable<Integer> source) {
        return OperationSum.sum(source);
    }

    public static Observable<Long> sumLongs(Observable<Long> source) {
        return OperationSum.sumLongs(source);
    }

    public static Observable<Float> sumFloats(Observable<Float> source) {
        return OperationSum.sumFloats(source);
    }

    public static Observable<Double> sumDoubles(Observable<Double> source) {
        return OperationSum.sumDoubles(source);
    }

    public static Observable<Integer> average(Observable<Integer> source) {
        return OperationAverage.average(source);
    }

    public static Observable<Long> averageLongs(Observable<Long> source) {
        return OperationAverage.averageLongs(source);
    }

    public static Observable<Float> averageFloats(Observable<Float> source) {
        return OperationAverage.averageFloats(source);
    }

    public static Observable<Double> averageDoubles(Observable<Double> source) {
        return OperationAverage.averageDoubles(source);
    }

    public ConnectableObservable<T> replay() {
        return OperationMulticast.multicast(this, ReplaySubject.create());
    }

    public Observable<T> retry(int retryCount) {
        return Observable.create(OperationRetry.retry(this, retryCount));
    }

    public Observable<T> retry() {
        return Observable.create(OperationRetry.retry(this));
    }

    public Observable<T> cache() {
        return Observable.create(OperationCache.cache(this));
    }

    public <R> Observable<R> parallel(Func1<Observable<T>, Observable<R>> f) {
        return OperationParallel.parallel(this, f);
    }

    public <R> Observable<R> parallel(Func1<Observable<T>, Observable<R>> f, Scheduler s) {
        return OperationParallel.parallel(this, f, s);
    }

    public ConnectableObservable<T> publish() {
        return OperationMulticast.multicast(this, PublishSubject.create());
    }

    public Observable<T> aggregate(Func2<T, T, T> accumulator) {
        return this.reduce(accumulator);
    }

    public <R> Observable<R> reduce(R initialValue, Func2<R, ? super T, R> accumulator) {
        return Observable.create(OperationScan.scan(this, initialValue, accumulator)).takeLast(1);
    }

    public <R> Observable<R> aggregate(R initialValue, Func2<R, ? super T, R> accumulator) {
        return this.reduce(initialValue, accumulator);
    }

    public Observable<T> scan(Func2<T, T, T> accumulator) {
        return Observable.create(OperationScan.scan(this, accumulator));
    }

    public Observable<T> sample(long period, TimeUnit unit) {
        return Observable.create(OperationSample.sample(this, period, unit));
    }

    public Observable<T> sample(long period, TimeUnit unit, Scheduler scheduler) {
        return Observable.create(OperationSample.sample(this, period, unit, scheduler));
    }

    public <R> Observable<R> scan(R initialValue, Func2<R, ? super T, R> accumulator) {
        return Observable.create(OperationScan.scan(this, initialValue, accumulator));
    }

    public Observable<Boolean> all(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationAll.all(this, predicate));
    }

    public Observable<T> skip(int num) {
        return Observable.create(OperationSkip.skip(this, num));
    }

    public Observable<T> first() {
        return this.take(1);
    }

    public Observable<T> first(Func1<? super T, Boolean> predicate) {
        return this.skipWhile(Functions.not(predicate)).take(1);
    }

    public Observable<T> firstOrDefault(T defaultValue) {
        return Observable.create(OperationFirstOrDefault.firstOrDefault(this, defaultValue));
    }

    public Observable<T> firstOrDefault(Func1<? super T, Boolean> predicate, T defaultValue) {
        return Observable.create(OperationFirstOrDefault.firstOrDefault(this, predicate, defaultValue));
    }

    public Observable<T> take(int num) {
        return Observable.create(OperationTake.take(this, num));
    }

    public Observable<T> takeWhile(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationTakeWhile.takeWhile(this, predicate));
    }

    public Observable<T> takeWhileWithIndex(Func2<? super T, ? super Integer, Boolean> predicate) {
        return Observable.create(OperationTakeWhile.takeWhileWithIndex(this, predicate));
    }

    public Observable<T> takeFirst() {
        return this.first();
    }

    public Observable<T> takeFirst(Func1<? super T, Boolean> predicate) {
        return this.first(predicate);
    }

    public Observable<T> takeLast(int count) {
        return Observable.create(OperationTakeLast.takeLast(this, count));
    }

    public <E> Observable<T> takeUntil(Observable<? extends E> other) {
        return OperationTakeUntil.takeUntil(this, other);
    }

    public Observable<T> skipWhileWithIndex(Func2<? super T, Integer, Boolean> predicate) {
        return Observable.create(OperationSkipWhile.skipWhileWithIndex(this, predicate));
    }

    public Observable<T> skipWhile(Func1<? super T, Boolean> predicate) {
        return Observable.create(OperationSkipWhile.skipWhile(this, predicate));
    }

    public Observable<List<T>> toList() {
        return Observable.create(OperationToObservableList.toObservableList(this));
    }

    public Observable<List<T>> toSortedList() {
        return Observable.create(OperationToObservableSortedList.toSortedList(this));
    }

    public Observable<List<T>> toSortedList(Func2<? super T, ? super T, Integer> sortFunction) {
        return Observable.create(OperationToObservableSortedList.toSortedList(this, sortFunction));
    }

    public Observable<T> startWith(Iterable<T> values) {
        return Observable.concat(Observable.from(values), this);
    }

    public Observable<T> startWith(T t1) {
        return Observable.concat(Observable.from(t1), this);
    }

    public Observable<T> startWith(T t1, T t2) {
        return Observable.concat(Observable.from(t1, t2), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3) {
        return Observable.concat(Observable.from(t1, t2, t3), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4) {
        return Observable.concat(Observable.from(t1, t2, t3, t4), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8), this);
    }

    public Observable<T> startWith(T t1, T t2, T t3, T t4, T t5, T t6, T t7, T t8, T t9) {
        return Observable.concat(Observable.from(t1, t2, t3, t4, t5, t6, t7, t8, t9), this);
    }

    public <K, R> Observable<GroupedObservable<K, R>> groupBy(Func1<? super T, ? extends K> keySelector, Func1<? super T, ? extends R> elementSelector) {
        return Observable.create(OperationGroupBy.groupBy(this, keySelector, elementSelector));
    }

    public <K> Observable<GroupedObservable<K, T>> groupBy(Func1<? super T, ? extends K> keySelector) {
        return Observable.create(OperationGroupBy.groupBy(this, keySelector));
    }

    public Observable<Boolean> isEmpty() {
        return Observable.create(OperationAny.isEmpty(this));
    }

    public BlockingObservable<T> toBlockingObservable() {
        return BlockingObservable.from(this);
    }

    private boolean isInternalImplementation(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof SafeObserver) {
            return true;
        }
        Package p = o.getClass().getPackage();
        return p != null && p.getName().startsWith("rx.operators");
    }

    private static class ThrowObservable<T>
    extends Observable<T> {
        public ThrowObservable(final Throwable exception) {
            super(new OnSubscribeFunc<T>(){

                @Override
                public Subscription onSubscribe(Observer<? super T> observer) {
                    observer.onError(exception);
                    return Subscriptions.empty();
                }
            });
        }
    }

    private static class NeverObservable<T>
    extends Observable<T> {
        public NeverObservable() {
            super(new OnSubscribeFunc<T>(){

                @Override
                public Subscription onSubscribe(Observer<? super T> t1) {
                    return Subscriptions.empty();
                }
            });
        }
    }

    public static interface OnSubscribeFunc<T>
    extends Function {
        public Subscription onSubscribe(Observer<? super T> var1);
    }
}

