/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.concurrency.TestScheduler;
import rx.operators.OperationInterval;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;

public final class OperationSample {
    public static <T> Observable.OnSubscribeFunc<T> sample(Observable<? extends T> source, long period, TimeUnit unit) {
        return new Sample(source, period, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> sample(Observable<? extends T> source, long period, TimeUnit unit, Scheduler scheduler) {
        return new Sample(source, period, unit, scheduler);
    }

    public static class UnitTest {
        private TestScheduler scheduler;
        private Observer<Long> observer;

        @Before
        public void before() {
            this.scheduler = new TestScheduler();
            this.observer = (Observer)Mockito.mock(Observer.class);
        }

        @Test
        public void testSample() {
            Observable<Long> source = Observable.create(new Observable.OnSubscribeFunc<Long>(){

                @Override
                public Subscription onSubscribe(final Observer<? super Long> observer1) {
                    UnitTest.this.scheduler.schedule(new Action0(){

                        @Override
                        public void call() {
                            observer1.onNext(1L);
                        }
                    }, 1L, TimeUnit.SECONDS);
                    UnitTest.this.scheduler.schedule(new Action0(){

                        @Override
                        public void call() {
                            observer1.onNext(2L);
                        }
                    }, 2L, TimeUnit.SECONDS);
                    UnitTest.this.scheduler.schedule(new Action0(){

                        @Override
                        public void call() {
                            observer1.onCompleted();
                        }
                    }, 3L, TimeUnit.SECONDS);
                    return Subscriptions.empty();
                }
            });
            Observable<Long> sampled = Observable.create(OperationSample.sample(source, 400L, TimeUnit.MILLISECONDS, this.scheduler));
            sampled.subscribe(this.observer);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(800L, TimeUnit.MILLISECONDS);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(Mockito.any(Long.class));
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(1200L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(1L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(1600L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(1L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(2000L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(1L);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            this.scheduler.advanceTimeTo(3000L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.never())).onNext(1L);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)2))).onNext(2L);
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify(this.observer, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
        }
    }

    private static class Sample<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> source;
        private final long period;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final AtomicBoolean hasValue = new AtomicBoolean();
        private final AtomicReference<T> latestValue = new AtomicReference();

        private Sample(Observable<? extends T> source, long interval, TimeUnit unit, Scheduler scheduler) {
            this.source = source;
            this.period = interval;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            Observable<Long> clock = Observable.create(OperationInterval.interval(this.period, this.unit, this.scheduler));
            final Subscription clockSubscription = clock.subscribe(new Observer<Long>(){

                @Override
                public void onCompleted() {
                }

                @Override
                public void onError(Throwable e) {
                }

                @Override
                public void onNext(Long tick) {
                    if (Sample.this.hasValue.get()) {
                        observer.onNext(Sample.this.latestValue.get());
                    }
                }
            });
            final Subscription sourceSubscription = this.source.subscribe(new Observer<T>(){

                @Override
                public void onCompleted() {
                    clockSubscription.unsubscribe();
                    observer.onCompleted();
                }

                @Override
                public void onError(Throwable e) {
                    clockSubscription.unsubscribe();
                    observer.onError(e);
                }

                @Override
                public void onNext(T value) {
                    Sample.this.latestValue.set(value);
                    Sample.this.hasValue.set(true);
                }
            });
            return Subscriptions.create(new Action0(){

                @Override
                public void call() {
                    clockSubscription.unsubscribe();
                    sourceSubscription.unsubscribe();
                }
            });
        }
    }
}

