/*
 * Decompiled with CFR 0.152.
 */
package rx.subscriptions;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import rx.Subscription;
import rx.util.CompositeException;

public class CompositeSubscription
implements Subscription {
    private AtomicBoolean unsubscribed = new AtomicBoolean(false);
    private final ConcurrentHashMap<Subscription, Boolean> subscriptions = new ConcurrentHashMap();

    public CompositeSubscription(List<Subscription> subscriptions) {
        for (Subscription s : subscriptions) {
            this.subscriptions.put(s, Boolean.TRUE);
        }
    }

    public CompositeSubscription(Subscription ... subscriptions) {
        for (Subscription s : subscriptions) {
            this.subscriptions.put(s, Boolean.TRUE);
        }
    }

    public void remove(Subscription s) {
        this.subscriptions.remove(s);
    }

    public boolean isUnsubscribed() {
        return this.unsubscribed.get();
    }

    public synchronized void add(Subscription s) {
        if (this.unsubscribed.get()) {
            s.unsubscribe();
        } else {
            this.subscriptions.put(s, Boolean.TRUE);
        }
    }

    @Override
    public synchronized void unsubscribe() {
        if (this.unsubscribed.compareAndSet(false, true)) {
            ArrayList<Throwable> es = null;
            for (Subscription s : this.subscriptions.keySet()) {
                try {
                    s.unsubscribe();
                }
                catch (Throwable e) {
                    if (es == null) {
                        es = new ArrayList<Throwable>();
                    }
                    es.add(e);
                }
            }
            if (es != null) {
                throw new CompositeException("Failed to unsubscribe to 1 or more subscriptions.", es);
            }
        }
    }

    public static class UnitTest {
        @Test
        public void testSuccess() {
            final AtomicInteger counter = new AtomicInteger();
            CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
            s.add(new Subscription(){

                @Override
                public void unsubscribe() {
                    counter.incrementAndGet();
                }
            });
            s.add(new Subscription(){

                @Override
                public void unsubscribe() {
                    counter.incrementAndGet();
                }
            });
            s.unsubscribe();
            Assert.assertEquals((long)2L, (long)counter.get());
        }

        @Test
        public void testException() {
            final AtomicInteger counter = new AtomicInteger();
            CompositeSubscription s = new CompositeSubscription(new Subscription[0]);
            s.add(new Subscription(){

                @Override
                public void unsubscribe() {
                    throw new RuntimeException("failed on first one");
                }
            });
            s.add(new Subscription(){

                @Override
                public void unsubscribe() {
                    counter.incrementAndGet();
                }
            });
            try {
                s.unsubscribe();
                Assert.fail((String)"Expecting an exception");
            }
            catch (CompositeException e) {
                Assert.assertEquals((long)1L, (long)e.getExceptions().size());
            }
            Assert.assertEquals((long)1L, (long)counter.get());
        }
    }
}

