/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Mockito;
import rx.Observable;
import rx.Observer;
import rx.Scheduler;
import rx.Subscription;
import rx.concurrency.Schedulers;
import rx.concurrency.TestScheduler;
import rx.operators.SynchronizedObserver;
import rx.subscriptions.Subscriptions;
import rx.util.functions.Action0;

public final class OperationDebounce {
    public static <T> Observable.OnSubscribeFunc<T> debounce(Observable<T> items, long timeout, TimeUnit unit) {
        return OperationDebounce.debounce(items, timeout, unit, Schedulers.threadPoolForComputation());
    }

    public static <T> Observable.OnSubscribeFunc<T> debounce(final Observable<T> items, final long timeout, final TimeUnit unit, final Scheduler scheduler) {
        return new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                return new Debounce(items, timeout, unit, scheduler).onSubscribe(observer);
            }
        };
    }

    public static class UnitTest {
        private TestScheduler scheduler;
        private Observer<String> observer;

        @Before
        public void before() {
            this.scheduler = new TestScheduler();
            this.observer = (Observer)Mockito.mock(Observer.class);
        }

        @Test
        public void testDebounceWithCompleted() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.publishNext(observer, 100L, "one");
                    UnitTest.this.publishNext(observer, 400L, "two");
                    UnitTest.this.publishNext(observer, 900L, "three");
                    UnitTest.this.publishCompleted(observer, 1000L);
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationDebounce.debounce(source, 400L, TimeUnit.MILLISECONDS, this.scheduler));
            sampled.subscribe(this.observer);
            this.scheduler.advanceTimeTo(0L, TimeUnit.MILLISECONDS);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(800L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onNext("two");
            this.scheduler.advanceTimeTo(1000L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
            inOrder.verifyNoMoreInteractions();
        }

        @Test
        public void testDebounceNeverEmits() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    UnitTest.this.publishNext(observer, 100L, "a");
                    UnitTest.this.publishNext(observer, 200L, "b");
                    UnitTest.this.publishNext(observer, 300L, "c");
                    UnitTest.this.publishNext(observer, 400L, "d");
                    UnitTest.this.publishNext(observer, 500L, "e");
                    UnitTest.this.publishNext(observer, 600L, "f");
                    UnitTest.this.publishNext(observer, 700L, "g");
                    UnitTest.this.publishNext(observer, 800L, "h");
                    UnitTest.this.publishCompleted(observer, 900L);
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationDebounce.debounce(source, 200L, TimeUnit.MILLISECONDS, this.scheduler));
            sampled.subscribe(this.observer);
            this.scheduler.advanceTimeTo(0L, TimeUnit.MILLISECONDS);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)0))).onNext(Mockito.anyString());
            this.scheduler.advanceTimeTo(1000L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer, Mockito.times((int)1))).onCompleted();
            inOrder.verifyNoMoreInteractions();
        }

        @Test
        public void testDebounceWithError() {
            Observable<String> source = Observable.create(new Observable.OnSubscribeFunc<String>(){

                @Override
                public Subscription onSubscribe(Observer<? super String> observer) {
                    TestException error = new TestException();
                    UnitTest.this.publishNext(observer, 100L, "one");
                    UnitTest.this.publishNext(observer, 600L, "two");
                    UnitTest.this.publishError(observer, 700L, error);
                    return Subscriptions.empty();
                }
            });
            Observable<String> sampled = Observable.create(OperationDebounce.debounce(source, 400L, TimeUnit.MILLISECONDS, this.scheduler));
            sampled.subscribe(this.observer);
            this.scheduler.advanceTimeTo(0L, TimeUnit.MILLISECONDS);
            InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.observer});
            this.scheduler.advanceTimeTo(500L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer)).onNext("one");
            this.scheduler.advanceTimeTo(701L, TimeUnit.MILLISECONDS);
            ((Observer)inOrder.verify(this.observer)).onError((Throwable)Mockito.any(TestException.class));
            inOrder.verifyNoMoreInteractions();
        }

        private <T> void publishCompleted(final Observer<T> observer, long delay) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onCompleted();
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private <T> void publishError(final Observer<T> observer, long delay, final Exception error) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onError(error);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private <T> void publishNext(final Observer<T> observer, long delay, final T value) {
            this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    observer.onNext(value);
                }
            }, delay, TimeUnit.MILLISECONDS);
        }

        private class TestException
        extends Exception {
            private TestException() {
            }
        }
    }

    private static class DebounceObserver<T>
    implements Observer<T> {
        private final Observer<? super T> observer;
        private final long timeout;
        private final TimeUnit unit;
        private final Scheduler scheduler;
        private final AtomicReference<Subscription> lastScheduledNotification = new AtomicReference();

        public DebounceObserver(Observer<? super T> observer, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.observer = new SynchronizedObserver<T>(observer);
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public void onCompleted() {
            this.lastScheduledNotification.get().unsubscribe();
            this.observer.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.lastScheduledNotification.get().unsubscribe();
            this.observer.onError(e);
        }

        @Override
        public void onNext(final T v) {
            Subscription previousSubscription = this.lastScheduledNotification.getAndSet(this.scheduler.schedule(new Action0(){

                @Override
                public void call() {
                    DebounceObserver.this.observer.onNext(v);
                }
            }, this.timeout, this.unit));
            if (previousSubscription != null) {
                previousSubscription.unsubscribe();
            }
        }
    }

    private static class Debounce<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<T> items;
        private final long timeout;
        private final TimeUnit unit;
        private final Scheduler scheduler;

        public Debounce(Observable<T> items, long timeout, TimeUnit unit, Scheduler scheduler) {
            this.items = items;
            this.timeout = timeout;
            this.unit = unit;
            this.scheduler = scheduler;
        }

        @Override
        public Subscription onSubscribe(Observer<? super T> observer) {
            return this.items.subscribe(new DebounceObserver<T>(observer, this.timeout, this.unit, this.scheduler));
        }
    }
}

