/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func1;

public final class OperationOnErrorResumeNextViaObservable<T> {
    public static <T> Observable.OnSubscribeFunc<T> onErrorResumeNextViaObservable(Observable<? extends T> originalSequence, Observable<? extends T> resumeSequence) {
        return new OnErrorResumeNextViaObservable<T>(originalSequence, resumeSequence);
    }

    public static class UnitTest {
        @Test
        public void testResumeNext() {
            Subscription s = (Subscription)Mockito.mock(Subscription.class);
            TestObservable f = new TestObservable(s, "one", "fail", "two", "three");
            Observable<String> w = Observable.create(f);
            Observable<String> resume = Observable.from("twoResume", "threeResume");
            Observable<String> observable = Observable.create(OperationOnErrorResumeNextViaObservable.onErrorResumeNextViaObservable(w, resume));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            try {
                f.t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("twoResume");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("threeResume");
        }

        @Test
        public void testMapResumeAsyncNext() {
            Subscription sr = (Subscription)Mockito.mock(Subscription.class);
            Observable<String> w = Observable.from("one", "fail", "two", "three", "fail");
            TestObservable f = new TestObservable(sr, "twoResume", "threeResume");
            Observable<String> resume = Observable.create(f);
            w = w.map(new Func1<String, String>(){

                @Override
                public String call(String s) {
                    if ("fail".equals(s)) {
                        throw new RuntimeException("Forced Failure");
                    }
                    System.out.println("BadMapper:" + s);
                    return s;
                }
            });
            Observable<String> observable = Observable.create(OperationOnErrorResumeNextViaObservable.onErrorResumeNextViaObservable(w, resume));
            Observer aObserver = (Observer)Mockito.mock(Observer.class);
            observable.subscribe(aObserver);
            try {
                f.t.join();
            }
            catch (InterruptedException e) {
                Assert.fail((String)e.getMessage());
            }
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onError((Throwable)Mockito.any(Throwable.class));
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onCompleted();
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("one");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("two");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.never())).onNext("three");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("twoResume");
            ((Observer)Mockito.verify((Object)aObserver, (VerificationMode)Mockito.times((int)1))).onNext("threeResume");
        }

        private static class TestObservable
        implements Observable.OnSubscribeFunc<String> {
            final Subscription s;
            final String[] values;
            Thread t = null;

            public TestObservable(Subscription s, String ... values) {
                this.s = s;
                this.values = values;
            }

            @Override
            public Subscription onSubscribe(final Observer<? super String> observer) {
                System.out.println("TestObservable subscribed to ...");
                this.t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            System.out.println("running TestObservable thread");
                            for (String s : TestObservable.this.values) {
                                if ("fail".equals(s)) {
                                    throw new RuntimeException("Forced Failure");
                                }
                                System.out.println("TestObservable onNext: " + s);
                                observer.onNext(s);
                            }
                            System.out.println("TestObservable onCompleted");
                            observer.onCompleted();
                        }
                        catch (Throwable e) {
                            System.out.println("TestObservable onError: " + e);
                            observer.onError(e);
                        }
                    }
                });
                System.out.println("starting TestObservable thread");
                this.t.start();
                System.out.println("done starting TestObservable thread");
                return this.s;
            }
        }
    }

    private static class OnErrorResumeNextViaObservable<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> resumeSequence;
        private final Observable<? extends T> originalSequence;

        public OnErrorResumeNextViaObservable(Observable<? extends T> originalSequence, Observable<? extends T> resumeSequence) {
            this.resumeSequence = resumeSequence;
            this.originalSequence = originalSequence;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            final AtomicReference<SafeObservableSubscription> subscriptionRef = new AtomicReference<SafeObservableSubscription>(subscription);
            subscription.wrap(this.originalSequence.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    if (subscriptionRef.get() == subscription) {
                        observer.onNext(value);
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    SafeObservableSubscription innerSubscription;
                    SafeObservableSubscription currentSubscription = (SafeObservableSubscription)subscriptionRef.get();
                    if (currentSubscription == subscription && !subscriptionRef.compareAndSet(currentSubscription, innerSubscription = new SafeObservableSubscription(OnErrorResumeNextViaObservable.this.resumeSequence.subscribe(observer)))) {
                        innerSubscription.unsubscribe();
                    }
                }

                @Override
                public void onCompleted() {
                    if (subscriptionRef.get() == subscription) {
                        observer.onCompleted();
                    }
                }
            }));
            return new Subscription(){

                @Override
                public void unsubscribe() {
                    Subscription s = subscriptionRef.getAndSet(null);
                    if (s != null) {
                        s.unsubscribe();
                    }
                }
            };
        }
    }
}

