/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.util.functions.Func1;

public final class OperationFilter<T> {
    public static <T> Observable.OnSubscribeFunc<T> filter(Observable<? extends T> that, Func1<? super T, Boolean> predicate) {
        return new Filter<T>(that, predicate);
    }

    private static class Filter<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> that;
        private final Func1<? super T, Boolean> predicate;

        public Filter(Observable<? extends T> that, Func1<? super T, Boolean> predicate) {
            this.that = that;
            this.predicate = predicate;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            final SafeObservableSubscription subscription = new SafeObservableSubscription();
            return subscription.wrap(this.that.subscribe(new Observer<T>(){

                @Override
                public void onNext(T value) {
                    try {
                        if (((Boolean)Filter.this.predicate.call(value)).booleanValue()) {
                            observer.onNext(value);
                        }
                    }
                    catch (Throwable ex) {
                        observer.onError(ex);
                        subscription.unsubscribe();
                    }
                }

                @Override
                public void onError(Throwable ex) {
                    observer.onError(ex);
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            }));
        }
    }
}

