/*
 * Decompiled with CFR 0.152.
 */
package rx.operators;

import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.util.functions.Func2;

public final class OperationScan {
    public static <T, R> Observable.OnSubscribeFunc<R> scan(Observable<? extends T> sequence, R initialValue, Func2<R, ? super T, R> accumulator) {
        return new Accumulator(sequence, initialValue, accumulator);
    }

    public static <T> Observable.OnSubscribeFunc<T> scan(Observable<? extends T> sequence, Func2<T, T, T> accumulator) {
        return new AccuWithoutInitialValue(sequence, accumulator);
    }

    private static class AccumulatingObserver<T, R>
    implements Observer<T> {
        private final Observer<? super R> observer;
        private final Func2<R, ? super T, R> accumulatorFunction;
        private R acc;

        private AccumulatingObserver(Observer<? super R> observer, R initialValue, Func2<R, ? super T, R> accumulator) {
            this.observer = observer;
            this.accumulatorFunction = accumulator;
            this.acc = initialValue;
        }

        @Override
        public synchronized void onNext(T value) {
            try {
                this.acc = this.accumulatorFunction.call(this.acc, value);
                this.observer.onNext(this.acc);
            }
            catch (Throwable ex) {
                this.observer.onError(ex);
            }
        }

        @Override
        public void onError(Throwable e) {
            this.observer.onError(e);
        }

        @Override
        public void onCompleted() {
            this.observer.onCompleted();
        }
    }

    private static class Accumulator<T, R>
    implements Observable.OnSubscribeFunc<R> {
        private final Observable<? extends T> sequence;
        private final R initialValue;
        private final Func2<R, ? super T, R> accumulatorFunction;

        private Accumulator(Observable<? extends T> sequence, R initialValue, Func2<R, ? super T, R> accumulator) {
            this.sequence = sequence;
            this.initialValue = initialValue;
            this.accumulatorFunction = accumulator;
        }

        @Override
        public Subscription onSubscribe(Observer<? super R> observer) {
            observer.onNext(this.initialValue);
            return this.sequence.subscribe(new AccumulatingObserver(observer, this.initialValue, this.accumulatorFunction));
        }
    }

    private static class AccuWithoutInitialValue<T>
    implements Observable.OnSubscribeFunc<T> {
        private final Observable<? extends T> sequence;
        private final Func2<T, T, T> accumulatorFunction;
        private AccumulatingObserver<T, T> accumulatingObserver;

        private AccuWithoutInitialValue(Observable<? extends T> sequence, Func2<T, T, T> accumulator) {
            this.sequence = sequence;
            this.accumulatorFunction = accumulator;
        }

        @Override
        public Subscription onSubscribe(final Observer<? super T> observer) {
            return this.sequence.subscribe(new Observer<T>(){

                @Override
                public synchronized void onNext(T value) {
                    if (AccuWithoutInitialValue.this.accumulatingObserver == null) {
                        observer.onNext(value);
                        AccuWithoutInitialValue.this.accumulatingObserver = new AccumulatingObserver(observer, value, AccuWithoutInitialValue.this.accumulatorFunction);
                    } else {
                        AccuWithoutInitialValue.this.accumulatingObserver.onNext(value);
                    }
                }

                @Override
                public void onError(Throwable e) {
                    observer.onError(e);
                }

                @Override
                public void onCompleted() {
                    observer.onCompleted();
                }
            });
        }
    }
}

