/*
 * Decompiled with CFR 0.152.
 */
package rx.subjects;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import rx.Observable;
import rx.Observer;
import rx.Subscription;
import rx.operators.SafeObservableSubscription;
import rx.subjects.Subject;

public class AsyncSubject<T>
extends Subject<T, T> {
    private final ConcurrentHashMap<Subscription, Observer<? super T>> observers;
    private final AtomicReference<T> currentValue;
    private final AtomicBoolean hasValue = new AtomicBoolean();

    public static <T> AsyncSubject<T> create() {
        final ConcurrentHashMap<Subscription, Observer<? super T>> observers = new ConcurrentHashMap<Subscription, Observer<? super T>>();
        Observable.OnSubscribeFunc onSubscribe = new Observable.OnSubscribeFunc<T>(){

            @Override
            public Subscription onSubscribe(Observer<? super T> observer) {
                final SafeObservableSubscription subscription = new SafeObservableSubscription();
                subscription.wrap(new Subscription(){

                    @Override
                    public void unsubscribe() {
                        observers.remove(subscription);
                    }
                });
                observers.put(subscription, observer);
                return subscription;
            }
        };
        return new AsyncSubject<T>(onSubscribe, observers);
    }

    protected AsyncSubject(Observable.OnSubscribeFunc<T> onSubscribe, ConcurrentHashMap<Subscription, Observer<? super T>> observers) {
        super(onSubscribe);
        this.observers = observers;
        this.currentValue = new AtomicReference();
    }

    @Override
    public void onCompleted() {
        T finalValue = this.currentValue.get();
        for (Observer<T> observer : this.observers.values()) {
            if (this.hasValue.get()) {
                observer.onNext(finalValue);
            }
            observer.onCompleted();
        }
    }

    @Override
    public void onError(Throwable e) {
        for (Observer<T> observer : this.observers.values()) {
            observer.onError(e);
        }
    }

    @Override
    public void onNext(T args) {
        this.hasValue.set(true);
        this.currentValue.set(args);
    }
}

